/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.encoding.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HashCalculator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HashCalculator.class));
    private static final Pattern PATTERN_NON_WORD_CHAR = Pattern.compile("\\W");
    private static volatile String[] fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] fields() {
        String[] tmp = fields;
        if (null != tmp) return tmp;
        Class<HashCalculator> clazz = HashCalculator.class;
        synchronized (HashCalculator.class) {
            tmp = fields;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            String fieldList = null == service ? "" : service.getProperty("com.openexchange.cookie.hash.fields", "");
            tmp = Pattern.compile("\\s*,\\s*").split(fieldList, 0);
            fields = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static String getHash(HttpServletRequest req, String client) {
        return HashCalculator.getHash(req, HashCalculator.getUserAgent(req), client);
    }

    public static String getHash(HttpServletRequest req, String userAgent, String client) {
        try {
            String[] fields;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((null == userAgent ? HashCalculator.parseUserAgent(req, "") : userAgent).getBytes(Charsets.UTF_8));
            if (null != client) {
                md.update(client.getBytes(Charsets.UTF_8));
            }
            for (String field : fields = HashCalculator.fields()) {
                String header = req.getHeader(field);
                if (HashCalculator.isEmpty(header)) continue;
                md.update(header.getBytes(Charsets.UTF_8));
            }
            return PATTERN_NON_WORD_CHAR.matcher(Base64.encode(md.digest())).replaceAll("");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.fatal((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getHash(HttpServletRequest req) {
        return HashCalculator.getHash(req, HashCalculator.getClient(req));
    }

    public static String getClient(HttpServletRequest req) {
        String parameter = req.getParameter("client");
        return HashCalculator.isEmpty(parameter) ? "default" : parameter;
    }

    private static String parseUserAgent(HttpServletRequest req, String defaultValue) {
        String parameter = req.getParameter("clientUserAgent");
        return HashCalculator.isEmpty(parameter) ? defaultValue : parameter;
    }

    private static String getUserAgent(HttpServletRequest req) {
        String header = req.getHeader("user-agent");
        if (header == null) {
            return "";
        }
        return header;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

