/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormLogin
implements LoginRequestHandler {
    private LoginConfiguration conf;

    public FormLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doFormLogin(req, resp);
        }
        catch (OXException e) {
            String errorPage = this.conf.getErrorPageTemplate().replace("ERROR_MESSAGE", e.getMessage());
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(errorPage);
        }
    }

    private void doFormLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        LoginRequest request = Login.parseLogin(req, "login", true, this.conf.getDefaultClient());
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        properties.put("http.request", req);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        LoginResult result = LoginPerformer.getInstance().doLogin(request, properties);
        Session session = result.getSession();
        User user = result.getUser();
        Tools.disableCaching(resp);
        Login.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName(), this.conf);
        resp.sendRedirect(LoginTools.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("autologin"), session, user.getPreferredLanguage(), this.conf.getUiWebPath()));
    }
}

