/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;

public final class HTMLDetector {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HTMLDetector.class));

    private HTMLDetector() {
    }

    public static boolean containsHTMLTags(byte[] sequence) {
        if (HTMLDetector.containsHTMLTag(sequence, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "body")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "script")) {
            return true;
        }
        return HTMLDetector.containsHTMLTag(sequence, "img");
    }

    public static boolean containsHTMLTag(byte[] sequence, String tag) {
        StringBuilder tmp = new StringBuilder(tag.length() + 2);
        if (HTMLDetector.indexOf(sequence, tmp.append('<').append(tag.toLowerCase()).append('>').toString().getBytes(Charsets.US_ASCII), 0, sequence.length, null) != -1) {
            return true;
        }
        tmp.setLength(0);
        return HTMLDetector.indexOf(sequence, tmp.append('<').append(tag.toUpperCase()).append('>').toString().getBytes(Charsets.US_ASCII), 0, sequence.length, null) != -1;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex, int[] computedFailures) {
        int[] failure;
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex - beginIndex));
        }
        if (computedFailures == null) {
            failure = HTMLDetector.computeFailure(pattern);
            if (failure == null) {
                throw new IllegalArgumentException("pattern is null");
            }
        } else {
            failure = computedFailures;
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

