/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;
import com.openexchange.ajax.customizer.folder.BulkAdditionalFolderFieldsList;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.ajax.parser.MessagingFolderParser;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.ajax.writer.FolderWriter;
import com.openexchange.ajax.writer.MessagingFolderWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.api2.RdbFolderSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.internal.performers.UpdatePerformer;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.SessionMailCache;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.json.writer.FolderWriter;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.messaging.DefaultMessagingFolder;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingAccountAccess;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingFolder;
import com.openexchange.messaging.MessagingFolderAccess;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.CompletionFuture;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class Folder
extends SessionServlet
implements OXExceptionConstants {
    private static final String STR_INBOX = "INBOX";
    private static final int DEFAULT_MAX_RUNNING_MILLIS = 120000;
    private static final long serialVersionUID = -889739420660750770L;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Folder.class));
    private static final AdditionalFolderFieldList FIELDS = new AdditionalFolderFieldList();
    public static final String PARAMETER_PARENT = "parent";
    public static final String PARAMETER_MAIL = "mail";
    public static final int MAX_PERMISSION = 64;
    private static final String STRING_1 = "1";
    private static final String STRING_DELETED = "deleted";
    private static final Date DATE_0 = new Date(0L);
    private static final Pattern PATERN_SPLIT = Pattern.compile(" *, *");
    private static final int RADIX = 10;

    public static AdditionalFolderFieldList getAdditionalFields() {
        return FIELDS;
    }

    private static final OXException getWrappingOXException(Throwable cause) {
        if (LOG.isWarnEnabled()) {
            StringBuilder warnBuilder = new StringBuilder(140);
            warnBuilder.append("An unexpected exception occurred, which is going to be wrapped for proper display.\n");
            warnBuilder.append("For safety reason its original content is display here.");
            LOG.warn((Object)warnBuilder.toString(), cause);
        }
        String message = cause.getMessage();
        return OXFolderExceptionCode.UNKNOWN_EXCEPTION.create(cause, null == message ? "[Not available]" : message);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        try {
            this.actionGet(req, resp);
        }
        catch (Exception e) {
            LOG.error((Object)"doGet", (Throwable)e);
            Folder.writeError(e.toString(), new JSONWriter((Writer)resp.getWriter()));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        try {
            this.actionPut(req, resp);
        }
        catch (Exception e) {
            LOG.error((Object)"doPut", (Throwable)e);
            Folder.writeError(e.toString(), new JSONWriter((Writer)resp.getWriter()));
        }
    }

    private static final void writeError(String error, JSONWriter jsonWriter) {
        try {
            Folder.startResponse(jsonWriter);
            jsonWriter.value(JSONObject.NULL);
            Folder.endResponse(jsonWriter, null, error);
        }
        catch (Exception exc) {
            LOG.error((Object)"writeError", (Throwable)exc);
        }
    }

    private final void actionGet(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String actionStr = Folder.checkStringParam(req, "action");
        if (actionStr.equalsIgnoreCase("root")) {
            this.actionGetRoot(req, resp);
        } else if (actionStr.equalsIgnoreCase("list")) {
            this.actionGetSubfolders(req, resp);
        } else if (actionStr.equalsIgnoreCase("path")) {
            this.actionGetPath(req, resp);
        } else if (actionStr.equalsIgnoreCase("updates")) {
            this.actionGetUpdatedFolders(req, resp);
        } else if (actionStr.equalsIgnoreCase("get")) {
            this.actionGetFolder(req, resp);
        } else {
            throw Folder.getWrappingOXException(new Exception("Action \"" + actionStr + "\" NOT supported via GET on " + DefaultDispatcherPrefixService.getInstance().getPrefix() + "folders"));
        }
    }

    private final void actionPut(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String actionStr = Folder.checkStringParam(req, "action");
        if (actionStr.equalsIgnoreCase("update")) {
            this.actionPutUpdateFolder(req, resp);
        } else if (actionStr.equalsIgnoreCase("new")) {
            this.actionPutInsertFolder(req, resp);
        } else if (actionStr.equalsIgnoreCase("delete")) {
            this.actionPutDeleteFolder(req, resp);
        } else if (actionStr.equalsIgnoreCase("clear")) {
            this.actionPutClearFolder(req, resp);
        } else if (actionStr.equalsIgnoreCase("removetestfolders")) {
            this.actionPutRemoveTestFolder(req, resp);
        } else {
            throw Folder.getWrappingOXException(new Exception("Action \"" + actionStr + "\" NOT supported via PUT on " + DefaultDispatcherPrefixService.getInstance().getPrefix() + "folders"));
        }
    }

    public void actionGetRoot(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionGetRoot(session, ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionGetRoot(HttpServletRequest req, HttpServletResponse resp) throws JSONException, IOException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        ResponseWriter.write(this.actionGetRoot(session, ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetRoot(ServerSession session, ParamContainer paramContainer) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        long lastModified = 0L;
        jsonWriter.array();
        try {
            Context ctx = session.getContext();
            int[] columns = paramContainer.checkIntArrayParam("columns");
            RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
            String timeZoneId = paramContainer.getStringParam("timezone");
            FolderWriter folderWriter = new FolderWriter(jsonWriter, session, ctx, timeZoneId, FIELDS);
            FolderWriter.FolderFieldWriter[] writers = folderWriter.getFolderFieldWriter(columns);
            Queue<FolderObject> q = ((FolderObjectIterator)foldersqlinterface.getRootFolderForUser()).asQueue();
            int size = q.size();
            Iterator iter = q.iterator();
            for (int i = 0; i < size; ++i) {
                Date modified;
                FolderObject rootFolder = (FolderObject)iter.next();
                int hasSubfolder = -1;
                if (rootFolder.getObjectID() == 4 || rootFolder.getObjectID() == 7) continue;
                if (rootFolder.getObjectID() == 3 && !session.getUserConfiguration().hasFullSharedFolderAccess()) {
                    hasSubfolder = 0;
                }
                lastModified = (modified = rootFolder.getLastModified()) == null ? lastModified : Math.max(lastModified, modified.getTime());
                jsonWriter.array();
                try {
                    for (FolderWriter.FolderFieldWriter ffw : writers) {
                        ffw.writeField(jsonWriter, rootFolder, false, FolderObject.getFolderString(rootFolder.getObjectID(), session.getUser().getLocale()), hasSubfolder);
                    }
                    continue;
                }
                finally {
                    jsonWriter.endArray();
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Folder.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModified == 0L ? null : new Date(lastModified));
        return response;
    }

    public void actionGetSubfolders(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionGetSubfolders(session, ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionGetSubfolders(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetSubfolders(session, ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Response actionGetSubfolders(ServerSession session, ParamContainer paramContainer) throws JSONException {
        block147: {
            response = new Response(session);
            jsonWriter = new OXJSONWriter();
            warning = null;
            lastModifiedDate = null;
            jsonWriter.array();
            try {
                ctx = session.getContext();
                locale = session.getUser().getLocale();
                strHelper = StringHelper.valueOf(locale);
                columns = paramContainer.checkIntArrayParam("columns");
                parentIdentifier = paramContainer.checkStringParam("parent");
                ignore = paramContainer.getStringParam("ignore");
                timeZoneId = paramContainer.getStringParam("timezone");
                ignoreMailfolder = false;
                if (ignore != null && "mailfolder".equalsIgnoreCase(ignore)) {
                    ignoreMailfolder = true;
                }
                fieldList = new BulkAdditionalFolderFieldsList(Folder.FIELDS);
                folderWriter = new FolderWriter(jsonWriter, session, ctx, timeZoneId, fieldList);
                parentId = -1;
                parentId = Folder.getUnsignedInteger(parentIdentifier);
                if (parentId >= 0) {
                    lastModified = -9223372036854775808L;
                    foldersqlinterface = new RdbFolderSQLInterface(session);
                    writers = folderWriter.getFolderFieldWriter(columns);
                    if (parentId == 11) {
                        q = ((FolderObjectIterator)foldersqlinterface.getNonTreeVisiblePublicTaskFolders()).asQueue();
                        fieldList.warmUp(q, session);
                        size = q.size();
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            listFolder = (FolderObject)iter.next();
                            modified = listFolder.getLastModified();
                            lastModified = null == modified ? lastModified : Math.max(lastModified, modified.getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, listFolder, false);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                    } else if (parentId == 12) {
                        q = ((FolderObjectIterator)foldersqlinterface.getNonTreeVisiblePublicCalendarFolders()).asQueue();
                        fieldList.warmUp(q, session);
                        size = q.size();
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            listFolder = (FolderObject)iter.next();
                            modified = listFolder.getLastModified();
                            lastModified = null == modified ? lastModified : Math.max(lastModified, modified.getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, listFolder, false);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                    } else if (parentId == 13) {
                        q = ((FolderObjectIterator)foldersqlinterface.getNonTreeVisiblePublicContactFolders()).asQueue();
                        fieldList.warmUp(q, session);
                        size = q.size();
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            listFolder = (FolderObject)iter.next();
                            modified = listFolder.getLastModified();
                            lastModified = null == modified ? lastModified : Math.max(lastModified, modified.getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, listFolder, false);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                    } else if (parentId == 14) {
                        q = ((FolderObjectIterator)foldersqlinterface.getNonTreeVisiblePublicInfostoreFolders()).asQueue();
                        fieldList.warmUp(q, session);
                        size = q.size();
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            listFolder = (FolderObject)iter.next();
                            modified = listFolder.getLastModified();
                            lastModified = modified == null ? lastModified : Math.max(lastModified, modified.getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, listFolder, false);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                    } else if (parentId == 9) {
                        if (!session.getUserConfiguration().hasInfostore()) {
                            throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(new Object[]{OXFolderUtility.getUserName(session), OXFolderUtility.folderModule2String(8), ctx.getContextId()});
                        }
                        lastModified = FolderCacheManager.isEnabled() != false ? FolderCacheManager.getInstance().getFolderObject(parentId, true, ctx, null).getLastModified().getTime() : FolderObject.loadFolderObjectFromDB(parentId, ctx).getLastModified().getTime();
                        q = ((FolderObjectIterator)foldersqlinterface.getSubfolders(parentId, null)).asQueue();
                        size = q.size();
                        iter = q.iterator();
                        l = new ArrayList<FolderObject>(size);
                        for (j = 0; j < size; ++j) {
                            fo = (FolderObject)iter.next();
                            if (fo.getObjectID() == 10) {
                                l.add(0, fo);
                                continue;
                            }
                            l.add(fo);
                        }
                        fieldList.warmUp(l, session);
                        iter = l.iterator();
                        for (i = 0; i < size; ++i) {
                            fo = (FolderObject)iter.next();
                            modified = fo.getLastModified();
                            lastModified = null == modified ? lastModified : Math.max(lastModified, modified.getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, fo, false, FolderObject.getFolderString(fo.getObjectID(), locale), -1);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                        it = null;
                        try {
                            it = foldersqlinterface.getNonTreeVisiblePublicInfostoreFolders();
                            if (!it.hasNext()) ** GOTO lbl365
                            virtualListFolder = FolderObject.createVirtualFolderObject(14, FolderObject.getFolderString(14, locale), 8, true, 5);
                            folderWriter.writeOXFolderFieldsAsArray(columns, virtualListFolder, locale);
                        }
                        finally {
                            if (it != null) {
                                it.close();
                                it = null;
                            }
                        }
                    } else if (parentId == 3) {
                        us = UserStorage.getInstance();
                        q = ((FolderObjectIterator)foldersqlinterface.getSubfolders(3, null)).asQueue();
                        size = q.size();
                        displayNames = new HashMap<String, Integer>(size);
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            sharedFolder = (FolderObject)iter.next();
                            try {
                                creatorDisplayName = us.getUser(sharedFolder.getCreatedBy(), ctx).getDisplayName();
                            }
                            catch (OXException e) {
                                if (sharedFolder.getCreatedBy() != 0) {
                                    throw e;
                                }
                                creatorDisplayName = strHelper.getString("All users");
                            }
                            if (displayNames.containsKey(creatorDisplayName)) continue;
                            displayNames.put(creatorDisplayName, sharedFolder.getCreatedBy());
                        }
                        sortedDisplayNames = new ArrayList<K>(displayNames.keySet());
                        Collections.sort(sortedDisplayNames, new DisplayNameComparator(locale));
                        for (String displayName : sortedDisplayNames) {
                            virtualOwnerFolder = FolderObject.createVirtualSharedFolderObject((Integer)displayNames.get(displayName), displayName);
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, virtualOwnerFolder, false, null, 1);
                                }
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                    } else {
                        isSystemPrivateFolder = parentId == 1;
                        v0 = isSystemPublicFolder = parentId == 2;
                        if (isSystemPrivateFolder) {
                            if (session.getUserConfiguration().hasWebMail() && !ignoreMailfolder) {
                                if (session.getUserConfiguration().isMultipleMailAccounts()) {
                                    storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                                    accountsArr = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                                    tmp = new ArrayList<MailAccount>(accountsArr.length);
                                    tmp.addAll(Arrays.asList(accountsArr));
                                    Collections.sort(tmp, new MailAccountComparator(locale));
                                    accounts = tmp;
                                } else {
                                    accounts = new ArrayList<MailAccount>(1);
                                    storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                                    accounts.add(storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()));
                                }
                                messagingAccounts = new ArrayList<E>();
                                msr = ServerServiceRegistry.getInstance().getService(MessagingServiceRegistry.class);
                                if (null != msr) {
                                    allServices = msr.getAllServices(session.getUserId(), session.getContextId());
                                    for (MessagingService messagingService : allServices) {
                                        if (messagingService.getId().equals("com.openexchange.messaging.mail")) continue;
                                        messagingAccounts.addAll(messagingService.getAccountManager().getAccounts((Session)session));
                                    }
                                }
                                if (!accounts.isEmpty() || !messagingAccounts.isEmpty()) {
                                    if (!(accounts.isEmpty() || !"unifiedinbox".equals(((MailAccount)accounts.get(0)).getMailProtocol()) || null != (uim = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && uim.isEnabled(session.getUserId(), session.getContextId()))) {
                                        accounts.remove(0);
                                    }
                                    size = accounts.size() + messagingAccounts.size();
                                    arrays = new JSONArray[size];
                                    logger = Folder.LOG;
                                    tasks = new ArrayList<AbstractTask>(size);
                                    sz = accounts.size();
                                    index = 0;
                                    for (i = 0; i < sz; ++i) {
                                        mailAccount = (MailAccount)accounts.get(i);
                                        tasks.add(new MailRootFolderWriter(arrays, session, logger, mailAccount, columns, index++));
                                    }
                                    sz = messagingAccounts.size();
                                    for (i = 0; i < sz; ++i) {
                                        ma = (MessagingAccount)messagingAccounts.get(i);
                                        tasks.add(new MessagingRootFolderWriter(arrays, session, logger, ma, columns, index++));
                                    }
                                    completionFuture = ThreadPools.getThreadPool().invoke(tasks);
                                    try {
                                        for (i = 0; i < size; ++i) {
                                            f = completionFuture.take();
                                            if (null == f) continue;
                                            try {
                                                f.get();
                                                continue;
                                            }
                                            catch (ExecutionException e) {
                                                t = e.getCause();
                                                if (t instanceof OXException) {
                                                    if (null != warning) continue;
                                                    warning = (OXException)t;
                                                    warning.setCategory(Category.CATEGORY_WARNING);
                                                    continue;
                                                }
                                                if (t instanceof MessagingException) {
                                                    if (null != warning) continue;
                                                    warning = (OXException)t;
                                                    warning.setCategory(Category.CATEGORY_WARNING);
                                                    continue;
                                                }
                                                throw e;
                                            }
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                        throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
                                    }
                                    catch (ExecutionException e) {
                                        throw (OXException)ThreadPools.launderThrowable((ExecutionException)e, OXException.class);
                                    }
                                    for (k = 0; k < size; ++k) {
                                        array = arrays[k];
                                        if (null == array) continue;
                                        jsonWriter.value(array);
                                    }
                                }
                            }
                        } else if (isSystemPublicFolder) {
                            try {
                                internalUsers = foldersqlinterface.getFolderById(6);
                                lastModified = Math.max(lastModified, internalUsers.getLastModified().getTime());
                                folderWriter.writeOXFolderFieldsAsArray(columns, internalUsers, FolderObject.getFolderString(internalUsers.getObjectID(), locale), -1);
                            }
                            catch (OXException e) {
                                if (e.isGeneric(OXException.Generic.NO_PERMISSION)) {
                                    Folder.LOG.debug((Object)e.getMessage(), (Throwable)e);
                                }
                                throw e;
                            }
                        }
                        q = ((FolderObjectIterator)foldersqlinterface.getSubfolders(parentId, null)).asQueue();
                        fieldList.warmUp(q, session);
                        size = q.size();
                        iter = q.iterator();
                        for (i = 0; i < size; ++i) {
                            fo = (FolderObject)iter.next();
                            lastModified = fo.getLastModified() == null ? lastModified : Math.max(lastModified, fo.getLastModified().getTime());
                            jsonWriter.array();
                            try {
                                for (FolderWriter.FolderFieldWriter writer : writers) {
                                    writer.writeField(jsonWriter, fo, false);
                                }
                                continue;
                            }
                            finally {
                                jsonWriter.endArray();
                            }
                        }
                        if (isSystemPublicFolder) {
                            block146: {
                                block145: {
                                    it = null;
                                    try {
                                        it = foldersqlinterface.getNonTreeVisiblePublicCalendarFolders();
                                        if (it.hasNext()) {
                                            virtualListFolder = FolderObject.createVirtualFolderObject(12, FolderObject.getFolderString(12, locale), 5, true, 5);
                                            if (FolderCacheManager.isInitialized()) {
                                                FolderCacheManager.getInstance().putFolderObject(virtualListFolder, ctx);
                                            }
                                            folderWriter.writeOXFolderFieldsAsArray(columns, virtualListFolder, locale);
                                        }
                                    }
                                    catch (OXException e) {
                                        if (e.getCode() == OXFolderExceptionCode.NO_MODULE_ACCESS.getNumber() && Folder.CATEGORY_PERMISSION_DENIED.equals(e.getCategory())) {
                                            if (Folder.LOG.isTraceEnabled()) {
                                                Folder.LOG.trace((Object)e.getMessage(), (Throwable)e);
                                            }
                                            break block145;
                                        }
                                        throw e;
                                    }
                                    finally {
                                        if (it != null) {
                                            it.close();
                                            it = null;
                                        }
                                    }
                                }
                                try {
                                    it = foldersqlinterface.getNonTreeVisiblePublicContactFolders();
                                    if (it.hasNext()) {
                                        virtualListFolder = FolderObject.createVirtualFolderObject(13, FolderObject.getFolderString(13, locale), 5, true, 5);
                                        if (FolderCacheManager.isInitialized()) {
                                            FolderCacheManager.getInstance().putFolderObject(virtualListFolder, ctx);
                                        }
                                        folderWriter.writeOXFolderFieldsAsArray(columns, virtualListFolder, locale);
                                    }
                                }
                                catch (OXException e) {
                                    if (OXFolderExceptionCode.NO_MODULE_ACCESS.getNumber() == e.getCode() && Folder.CATEGORY_PERMISSION_DENIED.equals(e.getCategory())) {
                                        if (Folder.LOG.isTraceEnabled()) {
                                            Folder.LOG.trace((Object)e.getMessage(), (Throwable)e);
                                        }
                                        break block146;
                                    }
                                    throw e;
                                }
                                finally {
                                    if (it != null) {
                                        it.close();
                                        it = null;
                                    }
                                }
                            }
                            try {
                                it = foldersqlinterface.getNonTreeVisiblePublicTaskFolders();
                                if (!it.hasNext()) ** GOTO lbl365
                                virtualListFolder = FolderObject.createVirtualFolderObject(11, FolderObject.getFolderString(11, locale), 5, true, 5);
                                if (FolderCacheManager.isInitialized()) {
                                    FolderCacheManager.getInstance().putFolderObject(virtualListFolder, ctx);
                                }
                                folderWriter.writeOXFolderFieldsAsArray(columns, virtualListFolder, locale);
                            }
                            catch (OXException e) {
                                if (e.getCode() == OXFolderExceptionCode.NO_MODULE_ACCESS.getNumber() && Folder.CATEGORY_PERMISSION_DENIED.equals(e.getCategory())) {
                                    if (!Folder.LOG.isTraceEnabled()) ** GOTO lbl365
                                    Folder.LOG.trace((Object)e.getMessage(), (Throwable)e);
                                }
                                throw e;
                            }
                            finally {
                                if (it != null) {
                                    it.close();
                                    it = null;
                                }
                            }
                        }
                    }
lbl365:
                    // 13 sources

                    lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
                    break block147;
                }
                if (parentIdentifier.startsWith("u:")) {
                    lastModified = 0L;
                    foldersqlinterface = new RdbFolderSQLInterface(session);
                    try {
                        sharedOwner = Integer.parseInt(parentIdentifier.substring(2));
                    }
                    catch (NumberFormatException exc) {
                        throw Folder.getWrappingOXException(exc);
                    }
                    writers = folderWriter.getFolderFieldWriter(columns);
                    q = ((FolderObjectIterator)foldersqlinterface.getSharedFoldersFrom(sharedOwner, null)).asQueue();
                    fieldList.warmUp(q, session);
                    size = q.size();
                    iter = q.iterator();
                    for (i = 0; i < size; ++i) {
                        sharedFolder = (FolderObject)iter.next();
                        lastModified = sharedFolder.getLastModified() == null ? lastModified : Math.max(lastModified, sharedFolder.getLastModified().getTime());
                        jsonWriter.array();
                        try {
                            for (FolderWriter.FolderFieldWriter ffw : writers) {
                                ffw.writeField(jsonWriter, sharedFolder, false, null, 0);
                            }
                            continue;
                        }
                        finally {
                            jsonWriter.endArray();
                        }
                    }
                    lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
                    break block147;
                }
                all = "1".equals(paramContainer.getStringParam("all"));
                mfi = MessagingFolderIdentifier.parseFQN(parentIdentifier);
                if (null == mfi) {
                    it = null;
                    mailInterface = null;
                    try {
                        mailInterface = MailServletInterface.getInstance(session);
                        it = mailInterface.getChildFolders(parentIdentifier, all);
                        warnings = mailInterface.getWarnings();
                        if (!warnings.isEmpty()) {
                            warning = warnings.iterator().next();
                        }
                        writers = com.openexchange.mail.json.writer.FolderWriter.getMailFolderFieldWriter(columns, mailInterface.getMailConfig(), session);
                        size = it.size();
                        inboxFound = false;
                        putter = Folder.newArrayPutter();
                        for (i = 0; i < size; ++i) {
                            f = (MailFolder)it.next();
                            if (!inboxFound && "INBOX".equals(f.getFullname())) {
                                inboxFound = true;
                                ja = new JSONArray();
                                putter.setJSONArray(ja);
                                for (FolderWriter.MailFolderFieldWriter writer : writers) {
                                    writer.writeField(putter, mailInterface.getAccountID(), f, strHelper.getString(MailStrings.INBOX), -1, null, -1, all);
                                }
                                jsonWriter.value(ja);
                                continue;
                            }
                            ja = new JSONArray();
                            putter.setJSONArray(ja);
                            for (FolderWriter.MailFolderFieldWriter writer : writers) {
                                writer.writeField(putter, mailInterface.getAccountID(), f, null, -1, null, -1, all);
                            }
                            jsonWriter.value(ja);
                        }
                        break block147;
                    }
                    finally {
                        if (it != null) {
                            it.close();
                            it = null;
                        }
                        if (mailInterface != null) {
                            try {
                                mailInterface.close(true);
                                mailInterface = null;
                            }
                            catch (OXException e) {
                                Folder.LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                serviceId = mfi.getServiceId();
                messagingService = Folder.messagingServiceRegistry().getMessagingService(serviceId, session.getUserId(), session.getContextId());
                accountId = mfi.getAccountId();
                accountAccess = messagingService.getAccountAccess(accountId, (Session)session);
                accountAccess.connect();
                try {
                    subfolders = accountAccess.getFolderAccess().getSubfolders(mfi.getFullname(), all);
                    writers = MessagingFolderWriter.getMessagingFolderFieldWriter(columns, session);
                    putter = Folder.newMessagingArrayPutter();
                    for (MessagingFolder subfolder : subfolders) {
                        ja = new JSONArray();
                        putter.setJSONArray(ja);
                        for (MessagingFolderWriter.MessagingFolderFieldWriter writer : writers) {
                            writer.writeField(putter, serviceId, accountId, subfolder, null, -1, null, -1, all);
                        }
                        jsonWriter.value(ja);
                    }
                }
                finally {
                    accountAccess.close();
                }
            }
            catch (OXException e) {
                Folder.LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                wrapper = Folder.getWrappingOXException(e);
                Folder.LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        jsonWriter.endArray();
        if (null != warning) {
            response.addWarning(warning);
        }
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionGetPath(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionGetPath(session, ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionGetPath(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetPath(session, ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetPath(ServerSession session, ParamContainer paramContainer) throws JSONException {
        long lastModified;
        OXJSONWriter jsonWriter;
        Response response;
        block38: {
            response = new Response(session);
            jsonWriter = new OXJSONWriter();
            lastModified = 0L;
            jsonWriter.array();
            try {
                Context ctx = session.getContext();
                String folderIdentifier = paramContainer.checkStringParam("id");
                int[] columns = paramContainer.checkIntArrayParam("columns");
                String timeZoneId = paramContainer.getStringParam("timezone");
                FolderWriter folderWriter = new FolderWriter(jsonWriter, session, ctx, timeZoneId, FIELDS);
                int folderId = -1;
                folderId = Folder.getUnsignedInteger(folderIdentifier);
                if (folderId >= 0) {
                    RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
                    FolderWriter.FolderFieldWriter[] writers = folderWriter.getFolderFieldWriter(columns);
                    Queue<FolderObject> q = ((FolderObjectIterator)foldersqlinterface.getPathToRoot(folderId)).asQueue();
                    int size = q.size();
                    Iterator iter = q.iterator();
                    for (int i = 0; i < size; ++i) {
                        FolderObject fo = (FolderObject)iter.next();
                        if (fo.containsLastModified()) {
                            lastModified = fo.getLastModified().getTime() > lastModified ? fo.getLastModified().getTime() : lastModified;
                        }
                        jsonWriter.array();
                        try {
                            for (FolderWriter.FolderFieldWriter ffw : writers) {
                                ffw.writeField(jsonWriter, fo, false);
                            }
                            continue;
                        }
                        finally {
                            jsonWriter.endArray();
                        }
                    }
                    break block38;
                }
                if (folderIdentifier.startsWith("u:")) {
                    int userId = Integer.parseInt(folderIdentifier.substring(2));
                    ArrayList<FolderObject> list = new ArrayList<FolderObject>(2);
                    User user = UserStorage.getInstance().getUser(userId, ctx);
                    list.add(FolderObject.createVirtualSharedFolderObject(userId, user.getDisplayName()));
                    FolderObject systemShared = new OXFolderAccess(ctx).getFolderObject(3);
                    systemShared.setFolderName(FolderObject.getFolderString(3, user.getLocale()));
                    list.add(systemShared);
                    FolderWriter.FolderFieldWriter[] writers = folderWriter.getFolderFieldWriter(columns);
                    for (int i = 0; i < 2; ++i) {
                        FolderObject fo = (FolderObject)list.get(i);
                        if (fo.containsLastModified()) {
                            lastModified = fo.getLastModified().getTime() > lastModified ? fo.getLastModified().getTime() : lastModified;
                        }
                        jsonWriter.array();
                        try {
                            for (FolderWriter.FolderFieldWriter ffw : writers) {
                                ffw.writeField(jsonWriter, fo, false);
                            }
                            continue;
                        }
                        finally {
                            jsonWriter.endArray();
                        }
                    }
                    break block38;
                }
                MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(folderIdentifier);
                if (null == mfi) {
                    MailServletInterface mailInterface = null;
                    SearchIterator<MailFolder> it = null;
                    try {
                        mailInterface = MailServletInterface.getInstance(session);
                        it = mailInterface.getPathToDefaultFolder(folderIdentifier);
                        FolderWriter.MailFolderFieldWriter[] writers = com.openexchange.mail.json.writer.FolderWriter.getMailFolderFieldWriter(columns, mailInterface.getMailConfig(), session);
                        int size = it.size();
                        int accountID = mailInterface.getAccountID();
                        FolderWriter.JSONArrayPutter putter = Folder.newArrayPutter();
                        for (int i = 0; i < size; ++i) {
                            MailFolder fld = (MailFolder)it.next();
                            JSONArray ja = new JSONArray();
                            putter.setJSONArray(ja);
                            for (FolderWriter.MailFolderFieldWriter w : writers) {
                                w.writeField(putter, accountID, fld);
                            }
                            jsonWriter.value(ja);
                        }
                        it.close();
                        it = null;
                        String preparedFullname = MailFolderUtility.prepareFullname(accountID, "default");
                        MailFolder defaultFolder = mailInterface.getFolder(preparedFullname, true);
                        if (defaultFolder != null) {
                            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                            MailAccount mailAccount = storageService.getMailAccount(accountID, session.getUserId(), session.getContextId());
                            JSONArray ja = new JSONArray();
                            putter.setJSONArray(ja);
                            for (FolderWriter.MailFolderFieldWriter w : writers) {
                                w.writeField(putter, accountID, defaultFolder, mailAccount.getName(), 1, preparedFullname, 5, false);
                            }
                            jsonWriter.value(ja);
                        }
                        FolderObject privateFolder = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(1, true, ctx, null) : FolderObject.loadFolderObjectFromDB(1, ctx);
                        folderWriter.writeOXFolderFieldsAsArray(columns, privateFolder, FolderObject.getFolderString(1, session.getUser().getLocale()), -1);
                        break block38;
                    }
                    finally {
                        if (it != null) {
                            it.close();
                            it = null;
                        }
                        if (mailInterface != null) {
                            try {
                                mailInterface.close(true);
                                mailInterface = null;
                            }
                            catch (OXException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                String serviceId = mfi.getServiceId();
                MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(serviceId, session.getUserId(), session.getContextId());
                int accountId = mfi.getAccountId();
                MessagingAccountAccess accountAccess = messagingService.getAccountAccess(accountId, (Session)session);
                accountAccess.connect();
                try {
                    String parentId;
                    MessagingFolderAccess folderAccess = accountAccess.getFolderAccess();
                    ArrayList<MessagingFolder> path = new ArrayList<MessagingFolder>();
                    MessagingFolder folder = folderAccess.getFolder(mfi.getFullname());
                    path.add(folder);
                    while (!"".equals(parentId = folder.getParentId()) && parentId != null) {
                        folder = folderAccess.getFolder(parentId);
                        path.add(folder);
                    }
                    MessagingFolderWriter.MessagingFolderFieldWriter[] writers = MessagingFolderWriter.getMessagingFolderFieldWriter(columns, session);
                    MessagingFolderWriter.JSONArrayPutter putter = Folder.newMessagingArrayPutter();
                    for (MessagingFolder messagingFolder : path) {
                        JSONArray ja = new JSONArray();
                        putter.setJSONArray(ja);
                        for (MessagingFolderWriter.MessagingFolderFieldWriter w : writers) {
                            w.writeField(putter, serviceId, accountId, messagingFolder);
                        }
                        jsonWriter.value(ja);
                    }
                    MessagingFolder rootFolder = folderAccess.getFolder("");
                    JSONArray ja = new JSONArray();
                    putter.setJSONArray(ja);
                    String fqn = MessagingFolderIdentifier.getFQN(serviceId, accountId, "");
                    String name = messagingService.getAccountManager().getAccount(accountId, (Session)session).getDisplayName();
                    for (MessagingFolderWriter.MessagingFolderFieldWriter w : writers) {
                        w.writeField(putter, serviceId, accountId, rootFolder, name, 1, fqn, 13, false);
                    }
                    jsonWriter.value(ja);
                    FolderObject privateFolder = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(1, true, ctx, null) : FolderObject.loadFolderObjectFromDB(1, ctx);
                    folderWriter.writeOXFolderFieldsAsArray(columns, privateFolder, FolderObject.getFolderString(1, session.getUser().getLocale()), -1);
                }
                finally {
                    accountAccess.close();
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Folder.getWrappingOXException(e);
                LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModified == 0L ? null : new Date(lastModified));
        return response;
    }

    public void actionGetUpdatedFolders(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionGetUpdatedFolders(session, ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionGetUpdatedFolders(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetUpdatedFolders(session, ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetUpdatedFolders(ServerSession session, ParamContainer paramContainer) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        Date lastModifiedDate = null;
        OXException warning = null;
        jsonWriter.array();
        try {
            long lastModified = 0L;
            Context ctx = session.getContext();
            int[] columns = paramContainer.checkIntArrayParam("columns");
            String timeZoneId = paramContainer.getStringParam("timezone");
            BulkAdditionalFolderFieldsList fieldList = new BulkAdditionalFolderFieldsList(FIELDS);
            FolderWriter folderWriter = new FolderWriter(jsonWriter, session, ctx, timeZoneId, fieldList);
            Date timestamp = paramContainer.checkDateParam("timestamp");
            boolean includeMailFolders = STRING_1.equals(paramContainer.getStringParam(PARAMETER_MAIL));
            boolean ignoreDeleted = STRING_DELETED.equalsIgnoreCase(paramContainer.getStringParam("ignore"));
            lastModified = Math.max(timestamp.getTime(), lastModified);
            RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
            FolderWriter.FolderFieldWriter[] writers = folderWriter.getFolderFieldWriter(columns);
            Queue<FolderObject> q = ((FolderObjectIterator)foldersqlinterface.getAllModifiedFolders(timestamp)).asQueue();
            fieldList.warmUp(q, session);
            OXFolderAccess access = new OXFolderAccess(ctx);
            LinkedList<FolderObject> updatedQueue = new LinkedList<FolderObject>();
            LinkedList<FolderObject> deletedQueue = ignoreDeleted ? null : new LinkedList<FolderObject>();
            HashMap<String, Integer> displayNames = new HashMap<String, Integer>();
            boolean addSystemSharedFolder = false;
            boolean checkVirtualListFolders = false;
            int size = q.size();
            Iterator iter = q.iterator();
            UserConfiguration userConf = session.getUserConfiguration();
            UserStorage us = UserStorage.getInstance();
            StringHelper strHelper = StringHelper.valueOf(session.getUser().getLocale());
            boolean sharedFolderAccess = userConf.hasFullSharedFolderAccess();
            for (int i = 0; i < size; ++i) {
                FolderObject fo = (FolderObject)iter.next();
                if (fo.isVisible(session.getUserId(), userConf)) {
                    if (fo.isShared(session.getUserId())) {
                        if (sharedFolderAccess) {
                            String creatorDisplayName;
                            try {
                                creatorDisplayName = us.getUser(fo.getCreatedBy(), ctx).getDisplayName();
                            }
                            catch (OXException e) {
                                if (fo.getCreatedBy() != 0) {
                                    throw e;
                                }
                                creatorDisplayName = strHelper.getString("All users");
                            }
                            if (!displayNames.containsKey(creatorDisplayName)) {
                                displayNames.put(creatorDisplayName, fo.getCreatedBy());
                            }
                            addSystemSharedFolder = true;
                        } else if (!ignoreDeleted) {
                            deletedQueue.add(fo);
                        }
                    } else if (2 == fo.getType()) {
                        if (access.getFolderPermission(fo.getParentFolderID(), session.getUserId(), userConf).isFolderVisible()) {
                            updatedQueue.add(access.getFolderObject(fo.getParentFolderID()));
                        } else {
                            updatedQueue.add(fo.getModule() == 8 ? access.getFolderObject(9) : access.getFolderObject(2));
                        }
                    }
                    updatedQueue.add(fo);
                    continue;
                }
                checkVirtualListFolders |= 2 == fo.getType();
                if (ignoreDeleted) continue;
                deletedQueue.add(fo);
            }
            if (checkVirtualListFolders && !ignoreDeleted) {
                if (userConf.hasTask() && !foldersqlinterface.getNonTreeVisiblePublicTaskFolders().hasNext()) {
                    FolderObject virtualTasks = new FolderObject(11);
                    virtualTasks.setLastModified(DATE_0);
                    deletedQueue.add(virtualTasks);
                }
                if (userConf.hasCalendar() && !foldersqlinterface.getNonTreeVisiblePublicCalendarFolders().hasNext()) {
                    FolderObject virtualCalendar = new FolderObject(12);
                    virtualCalendar.setLastModified(DATE_0);
                    deletedQueue.add(virtualCalendar);
                }
                if (userConf.hasContact() && !foldersqlinterface.getNonTreeVisiblePublicContactFolders().hasNext()) {
                    FolderObject virtualContact = new FolderObject(13);
                    virtualContact.setLastModified(DATE_0);
                    deletedQueue.add(virtualContact);
                }
                if (userConf.hasInfostore() && !foldersqlinterface.getNonTreeVisiblePublicInfostoreFolders().hasNext()) {
                    FolderObject virtualInfostore = new FolderObject(14);
                    virtualInfostore.setLastModified(DATE_0);
                    deletedQueue.add(virtualInfostore);
                }
            }
            if (addSystemSharedFolder) {
                FolderObject sharedFolder = access.getFolderObject(3);
                sharedFolder.setFolderName(FolderObject.getFolderString(3, session.getUser().getLocale()));
                updatedQueue.add(sharedFolder);
                if (!displayNames.isEmpty()) {
                    for (Map.Entry entry : displayNames.entrySet()) {
                        updatedQueue.add(FolderObject.createVirtualSharedFolderObject((Integer)entry.getValue(), (String)entry.getKey()));
                    }
                }
            }
            size = updatedQueue.size();
            iter = updatedQueue.iterator();
            for (int i = 0; i < size; ++i) {
                FolderObject fo = (FolderObject)iter.next();
                Date modified = fo.getLastModified();
                if (null != modified) {
                    lastModified = Math.max(modified.getTime(), lastModified);
                }
                jsonWriter.array();
                try {
                    for (FolderWriter.FolderFieldWriter ffw : writers) {
                        ffw.writeField(jsonWriter, fo, false);
                    }
                    continue;
                }
                finally {
                    jsonWriter.endArray();
                }
            }
            if (!ignoreDeleted) {
                q = ((FolderObjectIterator)foldersqlinterface.getDeletedFolders(timestamp)).asQueue();
                q.addAll(deletedQueue);
                FolderWriter.FolderFieldWriter idWriter = folderWriter.getFolderFieldWriter(new int[]{1})[0];
                size = q.size();
                iter = q.iterator();
                for (int i = 0; i < size; ++i) {
                    FolderObject fo = (FolderObject)iter.next();
                    lastModified = Math.max(fo.getLastModified().getTime(), lastModified);
                    jsonWriter.array();
                    try {
                        idWriter.writeField(jsonWriter, fo, false);
                        continue;
                    }
                    finally {
                        jsonWriter.endArray();
                    }
                }
            }
            if (includeMailFolders) {
                ArrayList<MailAccount> accounts;
                MailAccountStorageService storageService;
                if (session.getUserConfiguration().isMultipleMailAccounts()) {
                    storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                    MailAccount[] accountsArr = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                    ArrayList<MailAccount> tmp = new ArrayList<MailAccount>(accountsArr.length);
                    tmp.addAll(Arrays.asList(accountsArr));
                    Collections.sort(tmp, new MailAccountComparator(session.getUser().getLocale()));
                    accounts = tmp;
                } else {
                    accounts = new ArrayList<MailAccount>(1);
                    storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                    accounts.add(storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()));
                }
                ArrayList messagingAccounts = new ArrayList();
                MessagingServiceRegistry msr = ServerServiceRegistry.getInstance().getService(MessagingServiceRegistry.class);
                if (null != msr) {
                    List allServices = msr.getAllServices(session.getUserId(), session.getContextId());
                    for (MessagingService messagingService : allServices) {
                        if (messagingService.getId().equals("com.openexchange.messaging.mail")) continue;
                        messagingAccounts.addAll(messagingService.getAccountManager().getAccounts((Session)session));
                    }
                }
                if (!accounts.isEmpty() || !messagingAccounts.isEmpty()) {
                    int i;
                    UnifiedInboxManagement uim;
                    if (!(accounts.isEmpty() || !"unifiedinbox".equals(((MailAccount)accounts.get(0)).getMailProtocol()) || null != (uim = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && uim.isEnabled(session.getUserId(), session.getContextId()))) {
                        accounts.remove(0);
                    }
                    int accountSize = accounts.size() + messagingAccounts.size();
                    final JSONArray[] arrays = new JSONArray[accountSize];
                    org.apache.commons.logging.Log logger = LOG;
                    ArrayList<AbstractTask> tasks2 = new ArrayList<AbstractTask>(accountSize);
                    int sz = accounts.size();
                    for (i = 0; i < sz; ++i) {
                        boolean initialized;
                        MailAccount mailAccount = (MailAccount)accounts.get(i);
                        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
                        Boolean b = (Boolean)mailSessionCache.getParameter(mailAccount.getId(), MailSessionParameterNames.getParamDefaultFolderChecked());
                        boolean bl = initialized = b != null && b != false;
                        if (initialized) {
                            SessionMailCache.getInstance(session, mailAccount.getId()).clear();
                            tasks2.add(new MailRootFolderWriter(arrays, session, logger, mailAccount, columns, i));
                            continue;
                        }
                        final int index = i;
                        tasks2.add(new AbstractTask<Object>(){

                            public Object call() throws Exception {
                                arrays[index] = null;
                                return null;
                            }
                        });
                    }
                    sz = messagingAccounts.size();
                    for (i = 0; i < sz; ++i) {
                        MessagingAccount ma = (MessagingAccount)messagingAccounts.get(i);
                        tasks2.add(new MessagingRootFolderWriter(arrays, session, logger, ma, columns, i));
                    }
                    CompletionFuture completionFuture = ThreadPools.getThreadPool().invoke(tasks2);
                    try {
                        for (int i2 = 0; i2 < accountSize; ++i2) {
                            try {
                                completionFuture.take().get();
                                continue;
                            }
                            catch (ExecutionException e) {
                                Throwable t = e.getCause();
                                if (t instanceof OXException) {
                                    if (null != warning) continue;
                                    warning = (OXException)t;
                                    warning.setCategory(Category.CATEGORY_WARNING);
                                    continue;
                                }
                                if (t instanceof MessagingException) {
                                    if (null != warning) continue;
                                    warning = (OXException)t;
                                    warning.setCategory(Category.CATEGORY_WARNING);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
                    }
                    catch (ExecutionException e) {
                        throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
                    }
                    for (JSONArray array : arrays) {
                        if (null == array) continue;
                        jsonWriter.value(array);
                    }
                }
            }
            lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Folder.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        if (null != warning) {
            response.addWarning(warning);
        }
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionGetFolder(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionGetFolder(session, ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionGetFolder(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetFolder(session, ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetFolder(ServerSession session, ParamContainer paramContainer) {
        Date lastModifiedDate;
        OXJSONWriter jsonWriter;
        Response response;
        block21: {
            response = new Response(session.getUser().getLocale());
            jsonWriter = null;
            lastModifiedDate = null;
            try {
                Context ctx = session.getContext();
                String folderIdentifier = paramContainer.checkStringParam("id");
                int[] columns = paramContainer.checkIntArrayParam("columns");
                String timeZoneId = paramContainer.getStringParam("timezone");
                int folderId = -1;
                folderId = Folder.getUnsignedInteger(folderIdentifier);
                if (folderId >= 0) {
                    RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
                    FolderObject fo = foldersqlinterface.getFolderById(folderId);
                    lastModifiedDate = fo.getLastModified();
                    jsonWriter = new OXJSONWriter();
                    new FolderWriter(jsonWriter, session, ctx, timeZoneId, FIELDS).writeOXFolderFieldsAsObject(columns, fo, session.getUser().getLocale());
                    break block21;
                }
                if (folderIdentifier.startsWith("u:")) {
                    int userId = -1;
                    try {
                        userId = Integer.parseInt(folderIdentifier.substring(2));
                    }
                    catch (NumberFormatException exc) {
                        throw Folder.getWrappingOXException(exc);
                    }
                    User user = UserStorage.getInstance().getUser(userId, ctx);
                    FolderObject fo = FolderObject.createVirtualSharedFolderObject(userId, user.getDisplayName());
                    jsonWriter = new OXJSONWriter();
                    new FolderWriter(jsonWriter, session, ctx, timeZoneId, FIELDS).writeOXFolderFieldsAsObject(columns, fo, user.getLocale());
                    break block21;
                }
                MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(folderIdentifier);
                if (null == mfi) {
                    MailServletInterface mailInterface = null;
                    try {
                        mailInterface = MailServletInterface.getInstance(session);
                        MailFolder f = mailInterface.getFolder(folderIdentifier, true);
                        FolderWriter.MailFolderFieldWriter[] writers = com.openexchange.mail.json.writer.FolderWriter.getMailFolderFieldWriter(columns, mailInterface.getMailConfig(), session);
                        JSONObject jo = new JSONObject();
                        FolderWriter.JSONObjectPutter putter = Folder.newObjectPutter().setJSONObject(jo);
                        for (FolderWriter.MailFolderFieldWriter writer : writers) {
                            writer.writeField(putter, mailInterface.getAccountID(), f);
                        }
                        jsonWriter = new OXJSONWriter(jo);
                        break block21;
                    }
                    finally {
                        try {
                            if (mailInterface != null) {
                                mailInterface.close(true);
                            }
                        }
                        catch (OXException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                String serviceId = mfi.getServiceId();
                MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(serviceId, session.getUserId(), session.getContextId());
                int accountId = mfi.getAccountId();
                MessagingAccountAccess accountAccess = messagingService.getAccountAccess(accountId, (Session)session);
                accountAccess.connect();
                try {
                    MessagingFolder f = accountAccess.getFolderAccess().getFolder(mfi.getFullname());
                    MessagingFolderWriter.MessagingFolderFieldWriter[] writers = MessagingFolderWriter.getMessagingFolderFieldWriter(columns, session);
                    JSONObject jo = new JSONObject();
                    MessagingFolderWriter.JSONObjectPutter putter = Folder.newMessagingObjectPutter().setJSONObject(jo);
                    for (MessagingFolderWriter.MessagingFolderFieldWriter writer : writers) {
                        writer.writeField(putter, serviceId, accountId, f);
                    }
                    jsonWriter = new OXJSONWriter(jo);
                }
                finally {
                    accountAccess.close();
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Folder.getWrappingOXException(e);
                LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        response.setData(jsonWriter == null ? JSONObject.NULL : jsonWriter.getObject());
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionPutUpdateFolder(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionPutUpdateFolder(session, requestObj.getString("data"), ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionPutUpdateFolder(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutUpdateFolder(session, Folder.getBody(req), ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutUpdateFolder(ServerSession session, String body, ParamContainer paramContainer) {
        Object retval;
        Date lastModifiedDate;
        Response response;
        block18: {
            response = new Response(session);
            lastModifiedDate = null;
            retval = JSONObject.NULL;
            try {
                MessagingFolderIdentifier pfi;
                Context ctx = session.getContext();
                String folderIdentifier = paramContainer.checkStringParam("id");
                Date timestamp = null;
                JSONObject jsonObj = new JSONObject(body);
                int updateFolderId = -1;
                updateFolderId = Folder.getUnsignedInteger(folderIdentifier);
                if (updateFolderId >= 0) {
                    timestamp = paramContainer.checkDateParam("timestamp");
                    RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
                    FolderObject fo = new FolderObject(updateFolderId);
                    new FolderParser(session.getUserConfiguration()).parse(fo, jsonObj);
                    fo = foldersqlinterface.saveFolderObject(fo, timestamp);
                    retval = Integer.toString(fo.getObjectID());
                    lastModifiedDate = fo.getLastModified();
                    break block18;
                }
                if (folderIdentifier.startsWith("u:")) {
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(session), folderIdentifier, ctx.getContextId());
                }
                MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(folderIdentifier);
                if (null == mfi) {
                    MailServletInterface mailInterface = MailServletInterface.getInstance(session);
                    try {
                        MailFolder updateFolder = mailInterface.getFolder(folderIdentifier, true);
                        if (updateFolder != null) {
                            MailFolderDescription mfd = new MailFolderDescription();
                            mfd.setFullname(updateFolder.getFullname());
                            mfd.setAccountId(MailFolderUtility.prepareMailFolderParam(folderIdentifier).getAccountId());
                            mfd.setExists(updateFolder.exists());
                            mfd.setSeparator(updateFolder.getSeparator());
                            com.openexchange.mail.json.parser.FolderParser.parse(jsonObj, mfd, session, mailInterface.getAccountID());
                            retval = mailInterface.saveFolder(mfd);
                        }
                        break block18;
                    }
                    finally {
                        try {
                            mailInterface.close(true);
                        }
                        catch (OXException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                int accountId = mfi.getAccountId();
                boolean done = false;
                if (jsonObj.has("folder_id") && accountId != (pfi = new MessagingFolderIdentifier(jsonObj.getString("folder_id"))).getAccountId()) {
                    MessagingFolderParser.ParsedMessagingFolder pmf = new MessagingFolderParser.ParsedMessagingFolder();
                    pmf.setID(mfi.toString());
                    pmf.parse(jsonObj);
                    UpdatePerformer up = new UpdatePerformer(session, new FolderServiceDecorator().put("permissions", paramContainer.getStringParam("permissions")));
                    up.doUpdate(pmf, null);
                    retval = mfi.toString();
                    done = true;
                }
                if (done) break block18;
                String serviceId = mfi.getServiceId();
                MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(serviceId, session.getUserId(), session.getContextId());
                MessagingAccountAccess accountAccess = messagingService.getAccountAccess(accountId, (Session)session);
                accountAccess.connect();
                try {
                    MessagingFolder updateFolder = accountAccess.getFolderAccess().getFolder(mfi.getFullname());
                    DefaultMessagingFolder dmf = new DefaultMessagingFolder();
                    dmf.setId(updateFolder.getId());
                    dmf.setExists(true);
                    dmf.setSeparator(updateFolder.getSeparator());
                    MessagingFolderParser.parse(jsonObj, dmf, session);
                    accountAccess.getFolderAccess().updateFolder(updateFolder.getId(), (MessagingFolder)dmf);
                    retval = mfi.toString();
                }
                finally {
                    accountAccess.close();
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Folder.getWrappingOXException(e);
                LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        response.setData(retval);
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionPutInsertFolder(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionPutInsertFolder(session, requestObj.getJSONObject("data"), ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionPutInsertFolder(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutInsertFolder(session, new JSONObject(Folder.getBody(req)), ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutInsertFolder(ServerSession session, JSONObject jsonObj, ParamContainer paramContainer) {
        Object retval;
        Date lastModifiedDate;
        Response response;
        block16: {
            response = new Response(session);
            lastModifiedDate = null;
            retval = JSONObject.NULL;
            try {
                Context ctx = session.getContext();
                String parentFolder = paramContainer.checkStringParam("folder_id");
                int parentFolderId = -1;
                parentFolderId = Folder.getUnsignedInteger(parentFolder);
                if (parentFolderId >= 0) {
                    RdbFolderSQLInterface foldersqlinterface = new RdbFolderSQLInterface(session);
                    FolderObject fo = new FolderObject();
                    fo.setParentFolderID(parentFolderId);
                    new FolderParser(session.getUserConfiguration()).parse(fo, jsonObj);
                    fo = foldersqlinterface.saveFolderObject(fo, null);
                    retval = Integer.toString(fo.getObjectID());
                    lastModifiedDate = fo.getLastModified();
                    break block16;
                }
                if (parentFolder.startsWith("u:")) {
                    throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(session), parentFolder, ctx.getContextId());
                }
                MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(parentFolder);
                if (null == mfi) {
                    MailServletInterface mailInterface = MailServletInterface.getInstance(session);
                    try {
                        FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(parentFolder);
                        MailFolder parent = mailInterface.getFolder(parentFolder, true);
                        MailFolderDescription mfd = new MailFolderDescription();
                        mfd.setParentFullname(arg.getFullname());
                        mfd.setParentAccountId(arg.getAccountId());
                        mfd.setSeparator(parent.getSeparator());
                        com.openexchange.mail.json.parser.FolderParser.parse(jsonObj, mfd, session, arg.getAccountId());
                        mfd.setExists(false);
                        retval = mailInterface.saveFolder(mfd);
                        break block16;
                    }
                    finally {
                        try {
                            mailInterface.close(true);
                        }
                        catch (OXException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                String serviceId = mfi.getServiceId();
                MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(serviceId, session.getUserId(), session.getContextId());
                int accountId = mfi.getAccountId();
                MessagingAccountAccess accountAccess = messagingService.getAccountAccess(accountId, (Session)session);
                accountAccess.connect();
                try {
                    MessagingFolder parent = accountAccess.getFolderAccess().getFolder(mfi.getFullname());
                    DefaultMessagingFolder dmf = new DefaultMessagingFolder();
                    dmf.setParentId(mfi.getFullname());
                    dmf.setSeparator(parent.getSeparator());
                    MessagingFolderParser.parse(jsonObj, dmf, session);
                    dmf.setExists(false);
                    String newId = accountAccess.getFolderAccess().createFolder((MessagingFolder)dmf);
                    retval = MessagingFolderIdentifier.getFQN(serviceId, accountId, newId);
                }
                finally {
                    accountAccess.close();
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Folder.getWrappingOXException(e);
                LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        response.setData(retval);
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionPutDeleteFolder(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionPutDeleteFolder(session, requestObj.getString("data"), ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionPutDeleteFolder(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutDeleteFolder(session, Folder.getBody(req), ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutDeleteFolder(ServerSession session, String body, ParamContainer paramContainer) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        Date lastModifiedDate = null;
        jsonWriter.array();
        try {
            Date timestamp = null;
            JSONArray jsonArr = new JSONArray(body);
            RdbFolderSQLInterface foldersqlinterface = null;
            MailServletInterface mailInterface = null;
            try {
                long lastModified = 0L;
                int arrayLength = jsonArr.length();
                Context ctx = session.getContext();
                OXFolderAccess access = new OXFolderAccess(ctx);
                for (int i = 0; i < arrayLength; ++i) {
                    String deleteIdentifier = jsonArr.getString(i);
                    int delFolderId = -1;
                    delFolderId = Folder.getUnsignedInteger(deleteIdentifier);
                    if (delFolderId >= 0) {
                        FolderObject delFolderObj;
                        if (timestamp == null) {
                            timestamp = paramContainer.checkDateParam("timestamp");
                        }
                        if (foldersqlinterface == null) {
                            foldersqlinterface = new RdbFolderSQLInterface(session, access);
                        }
                        try {
                            delFolderObj = access.getFolderObject(delFolderId);
                        }
                        catch (OXException exc) {
                            continue;
                        }
                        if (delFolderObj.getLastModified().getTime() > timestamp.getTime()) {
                            jsonWriter.value(delFolderObj.getObjectID());
                            continue;
                        }
                        foldersqlinterface.deleteFolderObject(delFolderObj, timestamp);
                        lastModified = Math.max(lastModified, delFolderObj.getLastModified().getTime());
                        continue;
                    }
                    if (deleteIdentifier.startsWith("u:")) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(session), deleteIdentifier, ctx.getContextId());
                    }
                    MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(deleteIdentifier);
                    if (null == mfi) {
                        if (session.getUserConfiguration().hasWebMail()) {
                            if (mailInterface == null) {
                                mailInterface = MailServletInterface.getInstance(session);
                            }
                            mailInterface.deleteFolder(deleteIdentifier);
                            continue;
                        }
                        jsonWriter.value(deleteIdentifier);
                        continue;
                    }
                    MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(mfi.getServiceId(), session.getUserId(), session.getContextId());
                    MessagingAccountAccess accountAccess = messagingService.getAccountAccess(mfi.getAccountId(), (Session)session);
                    accountAccess.connect();
                    try {
                        accountAccess.getFolderAccess().deleteFolder(mfi.getFullname());
                        continue;
                    }
                    finally {
                        accountAccess.close();
                    }
                }
                if (lastModified != 0L) {
                    lastModifiedDate = new Date(lastModified);
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                    mailInterface = null;
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Folder.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    public void actionPutClearFolder(ServerSession session, JSONWriter w, JSONObject requestObj) throws JSONException {
        ResponseWriter.write(this.actionPutClearFolder(session, requestObj.getString("data"), ParamContainer.getInstance(requestObj, EnumComponent.FOLDER)), w, Folder.localeFrom(session));
    }

    private final void actionPutClearFolder(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutClearFolder(session, Folder.getBody(req), ParamContainer.getInstance(req, EnumComponent.FOLDER, resp)), resp.getWriter(), Folder.localeFrom(session));
        }
        catch (JSONException e) {
            try {
                ResponseWriter.writeException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]), new JSONWriter((Writer)resp.getWriter()), Folder.localeFrom(session));
            }
            catch (JSONException jsonError) {
                throw new ServletException(e.getMessage(), (Throwable)jsonError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutClearFolder(ServerSession session, String body, ParamContainer paramContainer) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        Date lastModifiedDate = null;
        jsonWriter.array();
        try {
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            Date timestamp = null;
            JSONArray jsonArr = new JSONArray(body);
            int length = jsonArr.length();
            RdbFolderSQLInterface folderInterface = null;
            MailServletInterface mailInterface = null;
            try {
                long lastModified = 0L;
                OXFolderAccess access = new OXFolderAccess(ctx);
                for (int i = 0; i < length; ++i) {
                    String deleteIdentifier = jsonArr.getString(i);
                    int delFolderId = -1;
                    delFolderId = Folder.getUnsignedInteger(deleteIdentifier);
                    if (delFolderId >= 0) {
                        FolderObject delFolderObj;
                        if (timestamp == null) {
                            timestamp = paramContainer.checkDateParam("timestamp");
                        }
                        if (folderInterface == null) {
                            folderInterface = new RdbFolderSQLInterface(session, access);
                        }
                        try {
                            delFolderObj = access.getFolderObject(delFolderId);
                        }
                        catch (OXException exc) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)exc.getMessage(), (Throwable)exc);
                            continue;
                        }
                        if (delFolderObj.getLastModified().getTime() > timestamp.getTime()) {
                            jsonWriter.value(delFolderObj.getObjectID());
                            continue;
                        }
                        folderInterface.clearFolder(delFolderObj, timestamp);
                        lastModified = Math.max(lastModified, delFolderObj.getLastModified().getTime());
                        continue;
                    }
                    if (deleteIdentifier.startsWith("u:")) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(session.getUserId(), ctx), deleteIdentifier, ctx.getContextId());
                    }
                    MessagingFolderIdentifier mfi = MessagingFolderIdentifier.parseFQN(deleteIdentifier);
                    if (null == mfi) {
                        if (UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), ctx).hasWebMail()) {
                            if (mailInterface == null) {
                                mailInterface = MailServletInterface.getInstance(session);
                            }
                            mailInterface.clearFolder(deleteIdentifier);
                            continue;
                        }
                        jsonWriter.value(deleteIdentifier);
                        continue;
                    }
                    MessagingService messagingService = Folder.messagingServiceRegistry().getMessagingService(mfi.getServiceId(), session.getUserId(), session.getContextId());
                    MessagingAccountAccess accountAccess = messagingService.getAccountAccess(mfi.getAccountId(), (Session)session);
                    accountAccess.connect();
                    try {
                        accountAccess.getFolderAccess().clearFolder(mfi.getFullname());
                        continue;
                    }
                    finally {
                        accountAccess.close();
                    }
                }
                if (lastModified != 0L) {
                    lastModifiedDate = new Date(lastModified);
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                    mailInterface = null;
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            if (!e.getCategory().equals(Category.CATEGORY_PERMISSION_DENIED)) {
                response.setException(e);
            }
        }
        catch (Exception e) {
            OXException wrapper = Folder.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(lastModifiedDate);
        return response;
    }

    private final void actionPutRemoveTestFolder(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        OXJSONWriter jsonWriter = new OXJSONWriter();
        ServerSession session = Folder.getSessionObject((ServletRequest)req);
        long lastModified = 0L;
        String error = null;
        AJAXServlet.startResponse(jsonWriter);
        String dataObj = "FAILED";
        try {
            int[] delids = Folder.checkIntArrayParam(req, "del_ids");
            OXFolderManager oxma = OXFolderManager.getInstance(session);
            oxma.cleanUpTestFolders(delids, session.getContext());
            dataObj = "OK";
        }
        catch (Exception e) {
            LOG.error((Object)"actionPutRemoveTestFolder", (Throwable)e);
            error = e.toString();
        }
        jsonWriter.value(dataObj);
        AJAXServlet.endResponse(jsonWriter, new Date(0L), error);
        resp.getWriter().flush();
    }

    private static final String checkStringParam(HttpServletRequest req, String paramName) throws OXException {
        String paramVal = req.getParameter(paramName);
        if (paramVal == null) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(paramName);
        }
        return paramVal;
    }

    private static final int[] checkIntArrayParam(HttpServletRequest req, String paramName) throws OXException {
        String tmp = req.getParameter(paramName);
        if (tmp == null) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(paramName);
        }
        String[] sa = PATERN_SPLIT.split(tmp, 0);
        tmp = null;
        int[] intArray = new int[sa.length];
        for (int a = 0; a < sa.length; ++a) {
            try {
                intArray[a] = Integer.parseInt(sa[a]);
                continue;
            }
            catch (NumberFormatException e) {
                throw OXFolderExceptionCode.BAD_PARAM_VALUE.create(e, sa[a], paramName);
            }
        }
        return intArray;
    }

    private static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static FolderWriter.JSONArrayPutter newArrayPutter() {
        return new FolderWriter.JSONArrayPutter();
    }

    private static MessagingFolderWriter.JSONArrayPutter newMessagingArrayPutter() {
        return new MessagingFolderWriter.JSONArrayPutter();
    }

    private static FolderWriter.JSONObjectPutter newObjectPutter() {
        return new FolderWriter.JSONObjectPutter();
    }

    private static MessagingFolderWriter.JSONObjectPutter newMessagingObjectPutter() {
        return new MessagingFolderWriter.JSONObjectPutter();
    }

    private static MessagingServiceRegistry messagingServiceRegistry() throws OXException {
        return ServerServiceRegistry.getInstance().getService(MessagingServiceRegistry.class, true);
    }

    private static final class MailAccountComparator
    implements Comparator<MailAccount> {
        private final Collator collator;

        public MailAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MailAccount o1, MailAccount o2) {
            if ("unifiedinbox".equals(o1.getMailProtocol())) {
                if ("unifiedinbox".equals(o2.getMailProtocol())) {
                    return 0;
                }
                return -1;
            }
            if ("unifiedinbox".equals(o2.getMailProtocol())) {
                return 1;
            }
            if (o1.isDefaultAccount()) {
                if (o2.isDefaultAccount()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isDefaultAccount()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class DisplayNameComparator
    implements Comparator<String> {
        private final Collator collator;

        public DisplayNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String displayName1, String displayName2) {
            return this.collator.compare(displayName1, displayName2);
        }
    }

    private static final class MessagingRootFolderWriter
    extends AbstractTask<Object> {
        private final JSONArray[] arrays;
        private final ServerSession session;
        private final org.apache.commons.logging.Log logger;
        private final MessagingAccount messagingAccount;
        private final int[] columns;
        private final int index;

        MessagingRootFolderWriter(JSONArray[] arrays, ServerSession session, org.apache.commons.logging.Log logger, MessagingAccount messagingAccount, int[] columns, int index) {
            this.arrays = arrays;
            this.session = session;
            this.logger = logger;
            this.messagingAccount = messagingAccount;
            this.columns = columns;
            this.index = index;
        }

        public Object call() throws OXException {
            String serviceId;
            MessagingFolder rootFolder;
            MessagingAccountAccess access;
            int accountId = this.messagingAccount.getId();
            try {
                MessagingService service = this.messagingAccount.getMessagingService();
                access = service.getAccountAccess(accountId, (Session)this.session);
                rootFolder = access.getRootFolder();
                serviceId = service.getId();
            }
            catch (OXException e) {
                this.arrays[this.index] = null;
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.arrays[this.index] = null;
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            try {
                MessagingFolderWriter.MessagingFolderFieldWriter[] writers = MessagingFolderWriter.getMessagingFolderFieldWriter(this.columns, this.session);
                JSONArray ja = new JSONArray();
                MessagingFolderWriter.JSONArrayPutter putter = new MessagingFolderWriter.JSONArrayPutter(ja);
                String displayName = this.messagingAccount.getDisplayName();
                String fqn = MessagingFolderIdentifier.getFQN(serviceId, accountId, "");
                for (MessagingFolderWriter.MessagingFolderFieldWriter writer : writers) {
                    writer.writeField(putter, serviceId, accountId, rootFolder, displayName, -1, fqn, 13, false);
                }
                this.arrays[this.index] = ja;
                Object var10_13 = null;
                return var10_13;
            }
            catch (OXException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                this.arrays[this.index] = null;
                throw e;
            }
            finally {
                access.close();
            }
        }
    }

    private static final class MailRootFolderWriter
    extends AbstractTask<Object> {
        private final JSONArray[] arrays;
        private final ServerSession session;
        private final org.apache.commons.logging.Log logger;
        private final MailAccount mailAccount;
        private final int[] columns;
        private final int index;

        MailRootFolderWriter(JSONArray[] arrays, ServerSession session, org.apache.commons.logging.Log logger, MailAccount mailAccount, int[] columns, int index) {
            this.arrays = arrays;
            this.session = session;
            this.logger = logger;
            this.mailAccount = mailAccount;
            this.columns = columns;
            this.index = index;
        }

        public Object call() throws OXException {
            MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess;
            int accountId = this.mailAccount.getId();
            try {
                mailAccess = MailAccess.getInstance(this.session, accountId);
            }
            catch (OXException e) {
                this.arrays[this.index] = null;
                if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.getNumber() == e.getCode()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    return null;
                }
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            MailFolder rootFolder = mailAccess.getRootFolder();
            try {
                FolderWriter.MailFolderFieldWriter[] mailFolderWriters = com.openexchange.mail.json.writer.FolderWriter.getMailFolderFieldWriter(this.columns, mailAccess.getMailConfig(), this.session);
                JSONArray ja = new JSONArray();
                FolderWriter.JSONArrayPutter putter = new FolderWriter.JSONArrayPutter().setJSONArray(ja);
                for (FolderWriter.MailFolderFieldWriter mailFolderWriter : mailFolderWriters) {
                    mailFolderWriter.writeField(putter, accountId, rootFolder, this.mailAccount.isDefaultAccount() ? "E-Mail" : this.mailAccount.getName(), 1, MailFolderUtility.prepareFullname(accountId, "default"), 5, false);
                }
                this.arrays[this.index] = ja;
                Object var7_9 = null;
                return var7_9;
            }
            catch (OXException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                this.arrays[this.index] = null;
                throw e;
            }
            finally {
                mailAccess.close(true);
            }
        }
    }
}

