/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.messaging.BinaryContent;
import com.openexchange.messaging.ContentType;
import com.openexchange.messaging.ManagedFileContent;
import com.openexchange.messaging.MessagingContent;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.MessagingPart;
import com.openexchange.messaging.SimpleContent;
import com.openexchange.messaging.StringContent;
import com.openexchange.messaging.generic.internet.MimeAddressMessagingHeader;
import com.openexchange.messaging.generic.internet.MimeBinaryContent;
import com.openexchange.messaging.generic.internet.MimeContentDisposition;
import com.openexchange.messaging.generic.internet.MimeContentType;
import com.openexchange.messaging.generic.internet.MimeDateMessagingHeader;
import com.openexchange.messaging.generic.internet.MimeMessagingMessage;
import com.openexchange.messaging.generic.internet.MimeMultipartContent;
import com.openexchange.messaging.generic.internet.MimeStringMessagingHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.logging.Log;

public class MimeMessagingPart
implements MessagingPart {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeMessagingPart.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final HeaderName H_CONTENT_TYPE = HeaderName.valueOf((CharSequence)MessagingHeader.KnownHeader.CONTENT_TYPE.toString());
    private static final String CT_TEXT = "text/";
    private static final String CT_MSG_RFC822 = "message/rfc822";
    private static final String CT_MUL = "multipart/";
    private static final Map<HeaderName, HeaderHandler> HHANDLERS;
    protected final MimePart part;
    private volatile ContentType cachedContentType;
    private boolean b_cachedContentType;
    private volatile MessagingContent cachedContent;
    private volatile Map<String, Collection<MessagingHeader>> headers;
    protected String sectionId;
    protected long size;

    public MimeMessagingPart() {
        this((MimePart)new MimeBodyPart());
    }

    public MimeMessagingPart(MimePart part) {
        this.part = part;
        this.size = -1L;
    }

    public MessagingContent getContent() throws OXException {
        Object tmp = this.cachedContent;
        if (null == tmp) {
            ContentType contentType;
            block12: {
                contentType = null;
                try {
                    contentType = this.getContentType();
                }
                catch (OXException e) {
                    if (!DEBUG) break block12;
                    LOG.debug((Object)"Content-Type header could not be requested.", (Throwable)e);
                }
            }
            if (null != contentType) {
                MimeMessage content;
                if (contentType.startsWith(CT_MUL)) {
                    MimeMultipart content2 = this.getContentObject(MimeMultipart.class);
                    if (null != content2) {
                        MimeMultipartContent multipartContent = new MimeMultipartContent(content2);
                        multipartContent.setSectionId(this.sectionId);
                        this.cachedContent = tmp = multipartContent;
                    }
                } else if (contentType.startsWith(CT_TEXT)) {
                    String content3 = this.getContentObject(String.class);
                    if (null != content3) {
                        this.cachedContent = tmp = new StringContent(content3);
                    }
                } else if (contentType.startsWith(CT_MSG_RFC822) && null != (content = this.getContentObject(MimeMessage.class))) {
                    MimeMessagingMessage message = new MimeMessagingMessage(content);
                    boolean increaseSecId = false;
                    message.setSectionId(this.sectionId);
                    this.cachedContent = tmp = message;
                }
            }
            if (null == tmp) {
                this.cachedContent = tmp = new MimeBinaryContent((Part)this.part);
            }
        }
        return tmp;
    }

    private <O> O getContentObject(Class<O> clazz) {
        try {
            return clazz.cast(this.part.getContent());
        }
        catch (IOException e) {
            if (DEBUG) {
                LOG.debug((Object)(clazz.getSimpleName() + " content could not be obtained."), (Throwable)e);
            }
            return null;
        }
        catch (MessagingException e) {
            if (DEBUG) {
                LOG.debug((Object)(clazz.getSimpleName() + " content could not be obtained."), (Throwable)e);
            }
            return null;
        }
        catch (ClassCastException e) {
            if (DEBUG) {
                LOG.debug((Object)("Content is not a " + clazz.getName() + '.'), (Throwable)e);
            }
            return null;
        }
    }

    public ContentType getContentType() throws OXException {
        if (!this.b_cachedContentType) {
            ContentType tmp = this.cachedContentType;
            if (null == tmp) {
                try {
                    String[] s = this.part.getHeader(MimeContentType.getContentTypeName());
                    if (null == s || 0 == s.length) {
                        this.b_cachedContentType = true;
                        return null;
                    }
                    this.cachedContentType = tmp = new MimeContentType(s[0]);
                    this.b_cachedContentType = true;
                }
                catch (MessagingException e) {
                    throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
            return tmp;
        }
        return this.cachedContentType;
    }

    public String getDisposition() throws OXException {
        try {
            return this.part.getDisposition();
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public String getFileName() throws OXException {
        try {
            return this.part.getFileName();
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public MessagingHeader getFirstHeader(String name) throws OXException {
        Collection<MessagingHeader> collection = this.getHeader(name);
        return null == collection ? null : (collection.isEmpty() ? null : collection.iterator().next());
    }

    public Collection<MessagingHeader> getHeader(String name) throws OXException {
        try {
            return this.getHeaders().get(name);
        }
        catch (OXException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public Map<String, Collection<MessagingHeader>> getHeaders() throws OXException {
        Map<String, Collection<MessagingHeader>> tmp = this.headers;
        if (null == tmp) {
            try {
                tmp = new ConcurrentHashMap<String, Collection<MessagingHeader>>();
                Enumeration allHeaders = this.part.getAllHeaders();
                while (allHeaders.hasMoreElements()) {
                    HeaderName headerName;
                    HeaderHandler hh;
                    Header header = (Header)allHeaders.nextElement();
                    String name = header.getName();
                    Collection<MessagingHeader> collection = tmp.get(name);
                    if (null == collection) {
                        collection = new ArrayList<MessagingHeader>(2);
                        tmp.put(name, collection);
                    }
                    if (null == (hh = HHANDLERS.get(headerName = HeaderName.valueOf((CharSequence)name)))) {
                        if (H_CONTENT_TYPE.equals((Object)headerName)) {
                            MimeContentType mct = new MimeContentType(header.getValue());
                            this.cachedContentType = mct;
                            this.b_cachedContentType = true;
                            collection.add((MessagingHeader)mct);
                            continue;
                        }
                        collection.add(new MimeStringMessagingHeader(name, header.getValue()));
                        continue;
                    }
                    hh.handleHeader(header, collection);
                }
                for (String name : new HashSet<String>(tmp.keySet())) {
                    tmp.put(name, Collections.unmodifiableCollection(tmp.get(name)));
                }
                this.headers = tmp = Collections.unmodifiableMap(tmp);
            }
            catch (MessagingException e) {
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return tmp;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public long getSize() throws OXException {
        if (this.size < 0L) {
            try {
                return this.part.getSize();
            }
            catch (MessagingException e) {
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this.size;
    }

    public void setSize(long size) {
        this.size = size <= 0L ? -1L : size;
    }

    public void writeTo(OutputStream os) throws IOException, OXException {
        try {
            this.part.writeTo(os);
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void addAllHeaders(Map<String, Collection<MessagingHeader>> headers) throws OXException {
        for (Map.Entry<String, Collection<MessagingHeader>> header : headers.entrySet()) {
            for (MessagingHeader mh : header.getValue()) {
                this.addHeader(mh.getName(), mh.getValue());
            }
        }
        this.headers = null;
        this.b_cachedContentType = false;
        this.cachedContentType = null;
    }

    public void addHeader(String headerName, String headerValue) throws OXException {
        try {
            this.part.addHeader(headerName, headerValue);
            this.headers = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void addHeader(MessagingHeader header) throws OXException {
        try {
            this.part.addHeader(header.getName(), header.getValue());
            this.headers = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void removeHeader(String headerName) throws OXException {
        try {
            this.part.removeHeader(headerName);
            this.headers = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setContent(MimeMultipartContent mp) throws OXException {
        try {
            this.part.setContent((Multipart)mp.mimeMultipart);
            this.part.setHeader(H_CONTENT_TYPE.toString(), mp.mimeMultipart.getContentType());
            this.headers = null;
            this.cachedContent = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setContent(MessagingContent content, String type) throws OXException {
        try {
            if (content instanceof MimeMessagingMessage) {
                this.part.setContent((Object)((MimeMessagingMessage)content).mimeMessage, type);
                this.part.setHeader(H_CONTENT_TYPE.toString(), type);
            } else if (content instanceof MimeMultipartContent) {
                this.part.setContent((Multipart)((MimeMultipartContent)content).mimeMultipart);
                this.part.setHeader(H_CONTENT_TYPE.toString(), type);
            } else if (content instanceof SimpleContent) {
                if (content instanceof BinaryContent) {
                    this.part.setDataHandler(new DataHandler((DataSource)new StreamDataSource((StreamDataSource.InputStreamProvider)new BinaryContentISP((BinaryContent)content), type)));
                } else if (content instanceof ManagedFileContent) {
                    this.part.setDataHandler(new DataHandler((DataSource)new StreamDataSource((StreamDataSource.InputStreamProvider)new ManagedFileContentISP((ManagedFileContent)content), type)));
                } else if (content instanceof StringContent) {
                    MimeContentType mct = new MimeContentType(type);
                    this.part.setText(((StringContent)content).getData().toString(), mct.getCharsetParameter(), mct.getSubType());
                } else if (content instanceof SimpleContent) {
                    this.part.setContent(((SimpleContent)content).getData(), type);
                } else {
                    throw MessagingExceptionCodes.UNKNOWN_MESSAGING_CONTENT.create(new Object[]{content.getClass().getName()});
                }
                this.part.setHeader(H_CONTENT_TYPE.toString(), type);
            } else {
                throw MessagingExceptionCodes.UNKNOWN_MESSAGING_CONTENT.create(new Object[]{content.getClass().getName()});
            }
            this.headers = null;
            this.cachedContent = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setDisposition(String disposition) throws OXException {
        try {
            this.part.setDisposition(disposition);
            this.headers = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setFileName(String filename) throws OXException {
        try {
            this.part.setFileName(filename);
            this.headers = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setAllHeaders(Map<String, Collection<MessagingHeader>> headers) throws OXException {
        try {
            Enumeration allHeaders = this.part.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                this.part.removeHeader(((Header)allHeaders.nextElement()).getName());
            }
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
        for (Map.Entry<String, Collection<MessagingHeader>> header : headers.entrySet()) {
            for (MessagingHeader mh : header.getValue()) {
                this.addHeader(mh.getName(), mh.getValue());
            }
        }
        this.headers = null;
        this.b_cachedContentType = false;
        this.cachedContentType = null;
    }

    public void setHeader(String headerName, String headerValue) throws OXException {
        try {
            this.part.setHeader(headerName, headerValue);
            this.headers = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setHeader(MessagingHeader header) throws OXException {
        try {
            this.part.setHeader(header.getName(), header.getValue());
            this.headers = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void setText(String text) throws OXException {
        this.setText(text, null);
    }

    public void setText(String text, String charset) throws OXException {
        this.setText(text, charset, "plain");
    }

    public void setText(String text, String charset, String subtype) throws OXException {
        try {
            this.part.setText(text, charset, subtype);
            this.headers = null;
            this.cachedContent = null;
            this.b_cachedContentType = false;
            this.cachedContentType = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    static {
        HashMap<HeaderName, HeaderHandler> m = new HashMap<HeaderName, HeaderHandler>(8);
        m.put(HeaderName.valueOf((CharSequence)MimeContentDisposition.getContentDispositionName()), new HeaderHandler(){

            @Override
            public void handleHeader(Header header, Collection<MessagingHeader> collection) throws OXException {
                collection.add((MessagingHeader)new MimeContentDisposition(header.getValue()));
            }
        });
        m.put(HeaderName.valueOf((CharSequence)MessagingHeader.KnownHeader.DATE.toString()), new HeaderHandler(){
            private final String name = MessagingHeader.KnownHeader.DATE.toString();

            @Override
            public void handleHeader(Header header, Collection<MessagingHeader> collection) throws OXException {
                collection.add((MessagingHeader)new MimeDateMessagingHeader(this.name, header.getValue()));
            }
        });
        String name = MessagingHeader.KnownHeader.FROM.toString();
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = MessagingHeader.KnownHeader.TO.toString();
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = MessagingHeader.KnownHeader.CC.toString();
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = MessagingHeader.KnownHeader.BCC.toString();
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Reply-To";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-Reply-To";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Disposition-Notification-To";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-From";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Sender";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-Sender";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-To";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-Cc";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        name = "Resent-Bcc";
        m.put(HeaderName.valueOf((CharSequence)name), new AddressHeaderHandler(name));
        HHANDLERS = Collections.unmodifiableMap(m);
    }

    private static final class AddressHeaderHandler
    implements HeaderHandler {
        private final String name;

        AddressHeaderHandler(String name) {
            this.name = name;
        }

        @Override
        public void handleHeader(Header header, Collection<MessagingHeader> collection) throws OXException {
            block2: {
                try {
                    collection.addAll(MimeAddressMessagingHeader.parseRFC822(this.name, header.getValue()));
                }
                catch (OXException e) {
                    if (MessagingExceptionCodes.ADDRESS_ERROR.equals(e)) break block2;
                    throw e;
                }
            }
            collection.add(new MimeStringMessagingHeader(this.name, header.getValue()));
        }
    }

    private static interface HeaderHandler {
        public void handleHeader(Header var1, Collection<MessagingHeader> var2) throws OXException;
    }

    private static final class ManagedFileContentISP
    implements StreamDataSource.InputStreamProvider {
        private final ManagedFileContent fileContent;

        ManagedFileContentISP(ManagedFileContent fileContent) {
            this.fileContent = fileContent;
        }

        public InputStream getInputStream() throws IOException {
            try {
                return (InputStream)this.fileContent.getData();
            }
            catch (OXException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof MessagingException) {
                    MessagingException me = (MessagingException)cause;
                    Exception nextException = me.getNextException();
                    if (nextException instanceof IOException) {
                        throw (IOException)nextException;
                    }
                    IOException ioException = new IOException(me.getMessage());
                    ioException.initCause(me);
                    throw ioException;
                }
                IOException ioException = new IOException(e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
        }

        public String getName() {
            return null;
        }
    }

    private static final class BinaryContentISP
    implements StreamDataSource.InputStreamProvider {
        private final BinaryContent binaryContent;

        BinaryContentISP(BinaryContent binaryContent) {
            this.binaryContent = binaryContent;
        }

        public InputStream getInputStream() throws IOException {
            try {
                return (InputStream)this.binaryContent.getData();
            }
            catch (OXException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof MessagingException) {
                    MessagingException me = (MessagingException)cause;
                    Exception nextException = me.getNextException();
                    if (nextException instanceof IOException) {
                        throw (IOException)nextException;
                    }
                    IOException ioException = new IOException(me.getMessage());
                    ioException.initCause(me);
                    throw ioException;
                }
                IOException ioException = new IOException(e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
        }

        public String getName() {
            return null;
        }
    }
}

