/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.messaging.ContentDisposition;
import com.openexchange.messaging.MessagingHeader;
import java.util.ArrayList;
import java.util.Iterator;

public final class MimeContentDisposition
extends com.openexchange.messaging.generic.internal.ParameterizedHeader
implements ContentDisposition {
    private static final long serialVersionUID = -1040187672540142351L;
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private final com.openexchange.mail.mime.ContentDisposition cdo;

    public static String getContentDispositionName() {
        return CONTENT_DISPOSITION;
    }

    public MimeContentDisposition() {
        super((ParameterizedHeader)new com.openexchange.mail.mime.ContentDisposition());
        this.cdo = (com.openexchange.mail.mime.ContentDisposition)this.delegate;
    }

    public MimeContentDisposition(String contentDisp) throws OXException {
        super((ParameterizedHeader)MimeContentDisposition.toContentDisposition(contentDisp));
        this.cdo = (com.openexchange.mail.mime.ContentDisposition)this.delegate;
    }

    private static com.openexchange.mail.mime.ContentDisposition toContentDisposition(String contentDisposition) throws OXException {
        try {
            return new com.openexchange.mail.mime.ContentDisposition(contentDisposition);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public int compareTo(com.openexchange.messaging.generic.internal.ParameterizedHeader other) {
        int dispComp;
        if (this == other) {
            return 0;
        }
        if (MimeContentDisposition.class.isInstance(other) && (dispComp = this.getDisposition().compareToIgnoreCase(((MimeContentDisposition)other).getDisposition())) != 0) {
            return dispComp;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        return this.cdo.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeContentDisposition other = (MimeContentDisposition)obj;
        return !(this.cdo == null ? other.cdo != null : !this.cdo.equals((Object)other.cdo));
    }

    public void setContentDisposition(MimeContentDisposition contentDisp) {
        if (contentDisp == this) {
            return;
        }
        this.cdo.setContentDisposition(contentDisp.cdo);
    }

    @Override
    public MessagingHeader.HeaderType getHeaderType() {
        return MessagingHeader.HeaderType.PARAMETERIZED;
    }

    public String getDisposition() {
        return this.cdo.getDisposition();
    }

    public void setDisposition(String disposition) {
        this.cdo.setDisposition(disposition);
    }

    public void setFilenameParameter(String filename) {
        this.cdo.setFilenameParameter(filename);
    }

    public String getFilenameParameter() {
        return this.cdo.getFilenameParameter();
    }

    public boolean containsFilenameParameter() {
        return this.cdo.containsFilenameParameter();
    }

    public void setContentDisposition(String contentDisp) throws OXException {
        try {
            this.cdo.setContentDisposition(contentDisp);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    public boolean isInline() {
        return this.cdo.isInline();
    }

    public boolean isAttachment() {
        return this.cdo.isAttachment();
    }

    public String toString() {
        return this.cdo.toString();
    }

    public String toString(boolean skipEmptyParams) {
        return this.cdo.toString(skipEmptyParams);
    }

    public void setContentDispositio(ContentDisposition contentDisp) {
        if (contentDisp == this) {
            return;
        }
        if (contentDisp instanceof MimeContentDisposition) {
            this.cdo.setContentDisposition(((MimeContentDisposition)contentDisp).cdo);
        } else {
            this.cdo.setDisposition(contentDisp.getDisposition());
            ArrayList tmp = new ArrayList(4);
            Iterator it = this.cdo.getParameterNames();
            while (it.hasNext()) {
                tmp.add(it.next());
            }
            for (String name : tmp) {
                this.cdo.removeParameter(name);
            }
            Iterator it2 = contentDisp.getParameterNames();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                this.cdo.addParameter(name, contentDisp.getParameter(name));
            }
        }
    }

    public String getName() {
        return CONTENT_DISPOSITION;
    }

    public String getValue() {
        return this.toString();
    }
}

