/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingAccountManager;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.generic.internal.CachingMessagingAccountStorage;
import com.openexchange.messaging.generic.internal.Modifier;
import com.openexchange.session.Session;
import java.util.List;

public class DefaultMessagingAccountManager
implements MessagingAccountManager {
    private static final CachingMessagingAccountStorage CACHE = CachingMessagingAccountStorage.getInstance();
    private final String serviceId;
    private final MessagingService service;
    private final Modifier modifier;

    public DefaultMessagingAccountManager(MessagingService service) {
        this.serviceId = service.getId();
        this.service = service;
        this.modifier = new DefaultModifier(this);
    }

    protected MessagingAccount modifyIncoming(MessagingAccount account) throws OXException {
        return account;
    }

    protected MessagingAccount modifyOutgoing(MessagingAccount account) throws OXException {
        return account;
    }

    public MessagingAccount getAccount(int id, Session session) throws OXException {
        return CACHE.getAccount(this.serviceId, id, session, this.modifier);
    }

    public List<MessagingAccount> getAccounts(Session session) throws OXException {
        return CACHE.getAccounts(this.serviceId, session, this.modifier);
    }

    public int addAccount(MessagingAccount account, Session session) throws OXException {
        return CACHE.addAccount(this.serviceId, account, session, this.modifier);
    }

    public void deleteAccount(MessagingAccount account, Session session) throws OXException {
        CACHE.deleteAccount(this.serviceId, account, session, this.modifier);
    }

    public void updateAccount(MessagingAccount account, Session session) throws OXException {
        CACHE.updateAccount(this.serviceId, account, session, this.modifier);
    }

    public void migrateToNewSecret(String oldSecret, String newSecret, Session session) throws OXException {
        CACHE.migrateToNewSecret(this.service, oldSecret, newSecret, session);
    }

    public boolean hasAccount(Session session) throws OXException {
        return CACHE.hasAccount(this.service, session);
    }

    private static final class DefaultModifier
    implements Modifier {
        private final DefaultMessagingAccountManager manager;

        public DefaultModifier(DefaultMessagingAccountManager manager) {
            this.manager = manager;
        }

        @Override
        public MessagingAccount modifyIncoming(MessagingAccount account) throws OXException {
            return this.manager.modifyIncoming(account);
        }

        @Override
        public MessagingAccount modifyOutgoing(MessagingAccount account) throws OXException {
            return this.manager.modifyOutgoing(account);
        }
    }
}

