/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.strings;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.tools.strings.StringParser;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TimeSpanParser
implements StringParser {
    private static final Map<String, Long> UNITS = new HashMap<String, Long>(){
        private static final long serialVersionUID = 4341197305332412108L;
        {
            this.put("MS", Autoboxing.L((long)1L));
            this.put("S", Autoboxing.L((long)1000L));
            this.put("M", Autoboxing.L((long)60000L));
            this.put("H", Autoboxing.L((long)3600000L));
            this.put("D", Autoboxing.L((long)86400000L));
            this.put("W", Autoboxing.L((long)604800000L));
        }
    };
    private static final Set<Class<?>> SUPPORTED = new HashSet<Class<?>>(){
        private static final long serialVersionUID = -551644321593953282L;
        {
            this.add(Long.class);
            this.add(Long.TYPE);
            this.add(Date.class);
        }
    };

    public static Long parseTimespan(String span) {
        if (span == null) {
            return -1L;
        }
        StringAllocator numberBuilder = new StringAllocator();
        StringAllocator unitBuilder = new StringAllocator();
        boolean mode = false;
        long tally = 0L;
        for (char c : span.toCharArray()) {
            if (Character.isDigit(c)) {
                if (!mode) {
                    numberBuilder.append(c);
                    continue;
                }
                String unit = 0 == unitBuilder.length() ? "MS" : unitBuilder.toString().toUpperCase();
                Long factor = UNITS.get(unit);
                if (factor == null) {
                    throw new IllegalArgumentException("I don't know unit " + unit);
                }
                tally += Long.parseLong(numberBuilder.toString()) * factor;
                numberBuilder.reinitTo(0);
                unitBuilder.reinitTo(0);
                mode = false;
                numberBuilder.append(c);
                continue;
            }
            if (!Character.isLetter(c)) continue;
            mode = true;
            unitBuilder.append(c);
        }
        if (numberBuilder.length() != 0) {
            String unit = 0 == unitBuilder.length() ? "MS" : unitBuilder.toString().toUpperCase();
            Long factor = UNITS.get(unit);
            if (factor == null) {
                throw new IllegalArgumentException("I don't know unit " + unit);
            }
            tally += Long.parseLong(numberBuilder.toString()) * factor;
        }
        return tally;
    }

    @Override
    public <T> T parse(String s, Class<T> t) {
        if (!SUPPORTED.contains(t)) {
            return null;
        }
        Long timespan = null;
        try {
            timespan = TimeSpanParser.parseTimespan(s);
        }
        catch (IllegalArgumentException x) {
            return null;
        }
        if (t == Long.class || t == Long.TYPE) {
            return (T)timespan;
        }
        if (t == Date.class) {
            return (T)new Date(timespan);
        }
        return null;
    }
}

