/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.id;

import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class IDMangler {
    public static final String PRIMARY_DELIM = "://";
    private static final char CHAR_SECONDARY_DELIM = '/';
    public static final String SECONDARY_DELIM;
    private static final BitSet PRINTABLE_CHARS;

    public static String mangle(String ... components) {
        StringAllocator id = new StringAllocator(50);
        boolean first = true;
        for (String component : components) {
            component = IDMangler.escape(component);
            id.append(component);
            String delim = first ? PRIMARY_DELIM : SECONDARY_DELIM;
            id.append(delim);
            first = false;
        }
        id.setNewLength(id.length() - 1);
        return id.toString();
    }

    private static String escape(String string) {
        if (string == null) {
            return null;
        }
        return IDMangler.encodeQP(string);
    }

    public static List<String> unmangle(String mangled) {
        return IDMangler.unmangle(mangled, false);
    }

    public static List<String> unmangle(String mangled, boolean stateMachine) {
        ArrayList<String> list = new ArrayList<String>(5);
        if (stateMachine) {
            StringAllocator buffer = new StringAllocator(50);
            ParserState state = ParserState.APPEND_PREFIX;
            ParserState unescapedState = null;
            block20: for (char c : mangled.toCharArray()) {
                switch (c) {
                    case '[': {
                        if (state == ParserState.ESCAPED) {
                            buffer.append(c);
                            continue block20;
                        }
                        unescapedState = state;
                        state = ParserState.ESCAPED;
                        continue block20;
                    }
                    case ']': {
                        if (state == ParserState.ESCAPED) {
                            state = unescapedState;
                            continue block20;
                        }
                        buffer.append(c);
                        continue block20;
                    }
                    case ':': {
                        switch (state) {
                            case APPEND: 
                            case ESCAPED: {
                                buffer.append(c);
                                break;
                            }
                            case APPEND_PREFIX: {
                                state = ParserState.PRIMARY_DELIM1;
                            }
                        }
                        continue block20;
                    }
                    case '/': {
                        switch (state) {
                            case APPEND: {
                                list.add(buffer.toString());
                                buffer.reinitTo(0);
                                break;
                            }
                            case ESCAPED: 
                            case APPEND_PREFIX: {
                                buffer.append(c);
                                break;
                            }
                            case PRIMARY_DELIM1: {
                                state = ParserState.PRIMARY_DELIM2;
                                break;
                            }
                            case PRIMARY_DELIM2: {
                                list.add(buffer.toString());
                                buffer.reinitTo(0);
                                state = ParserState.APPEND;
                            }
                        }
                        continue block20;
                    }
                    default: {
                        switch (state) {
                            case PRIMARY_DELIM1: {
                                buffer.append(':');
                                state = ParserState.APPEND_PREFIX;
                                break;
                            }
                            case PRIMARY_DELIM2: {
                                buffer.append(":/");
                                state = ParserState.APPEND_PREFIX;
                            }
                        }
                        buffer.append(c);
                    }
                }
            }
            if (buffer.length() != 0) {
                list.add(buffer.toString());
            }
        } else {
            int prev = 0;
            int pos = mangled.indexOf(PRIMARY_DELIM, prev);
            if (pos == -1) {
                list.add(mangled);
                return list;
            }
            list.add(IDMangler.decodeQP(mangled.substring(prev, pos)));
            prev = pos + PRIMARY_DELIM.length();
            while (prev > 0) {
                pos = mangled.indexOf(47, prev);
                if (pos > 0) {
                    list.add(IDMangler.decodeQP(mangled.substring(prev, pos)));
                    prev = pos + 1;
                    continue;
                }
                list.add(IDMangler.decodeQP(mangled.substring(prev)));
                prev = -1;
            }
        }
        return list;
    }

    private static String encodeQP(String string) {
        try {
            return new String(QuotedPrintableCodec.encodeQuotedPrintable((BitSet)PRINTABLE_CHARS, (byte[])string.getBytes(Charsets.UTF_8)), Charsets.US_ASCII);
        }
        catch (UnsupportedCharsetException e) {
            return string;
        }
    }

    private static String decodeQP(String string) {
        try {
            return new String(QuotedPrintableCodec.decodeQuotedPrintable((byte[])string.getBytes(Charsets.US_ASCII)), Charsets.UTF_8);
        }
        catch (DecoderException e) {
            return string;
        }
    }

    static {
        int i;
        SECONDARY_DELIM = Character.toString('/');
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(95);
    }

    private static enum ParserState {
        APPEND,
        APPEND_PREFIX,
        PRIMARY_DELIM1,
        PRIMARY_DELIM2,
        ESCAPED;

    }
}

