/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.hash;

public final class HashKey {
    public static final int DEFAULT_HASH = 5381;
    private static final int MULTIPLICATION_CONSTANT = 33;
    private final String value;
    private final int hash;

    public static HashKey valueOf(String key) {
        return new HashKey(key, 5381, null);
    }

    public static HashKey valueOf(String key, int hashStart) {
        return new HashKey(key, hashStart, null);
    }

    public static HashKey valueOf(String key, int hashStart, String salt) {
        return new HashKey(key, hashStart, salt);
    }

    public static HashKey valueOf(String key, String salt) {
        return new HashKey(key, 5381, salt);
    }

    private static int calcSafeHashCode(int hashStart, char[] val) {
        int h = hashStart;
        int len = val.length;
        if (len > 0) {
            int fac = 33;
            for (int i = 0; i < len; ++i) {
                h = 33 * h + val[i];
            }
        }
        return h;
    }

    private HashKey(String key, int hashStart, String salt) {
        this.value = key;
        if (null == salt) {
            this.hash = HashKey.calcSafeHashCode(hashStart, key.toCharArray());
        } else {
            StringBuilder sb = new StringBuilder(key).append('-').append(salt);
            int count = sb.length();
            char[] chars = new char[count];
            sb.getChars(0, count, chars, 0);
            this.hash = HashKey.calcSafeHashCode(hashStart, chars);
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HashKey)) {
            return false;
        }
        HashKey other = (HashKey)obj;
        return !(null == this.value ? null != other.value : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }
}

