/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.arrays;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;

public final class Arrays {
    private Arrays() {
    }

    public static boolean contains(int[] array, int search) {
        boolean found = false;
        for (int test : array) {
            if (test != search) continue;
            found = true;
            break;
        }
        return found;
    }

    public static int[] addUniquely(int[] toExtend, int ... other) {
        if (other == null) {
            return toExtend;
        }
        HashSet<Integer> tmp = new HashSet<Integer>();
        for (int i : toExtend) {
            tmp.add(new Integer(i));
        }
        for (int i : other) {
            tmp.add(new Integer(i));
        }
        int[] retval = new int[tmp.size()];
        int pos = 0;
        for (Integer i : tmp) {
            retval[pos++] = i;
        }
        return retval;
    }

    public static <T> T[] remove(T[] removeFrom, T ... toRemove) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T copy : removeFrom) {
            tmp.add(copy);
        }
        for (T remove : toRemove) {
            tmp.remove(remove);
        }
        Object[] retval = tmp.toArray((Object[])Array.newInstance(removeFrom.getClass().getComponentType(), tmp.size()));
        return retval;
    }

    public static <T> T[] add(T[] toExtend, T ... other) {
        if (other == null) {
            return toExtend;
        }
        Object[] tmp = (Object[])Array.newInstance(toExtend.getClass().getComponentType(), toExtend.length + other.length);
        System.arraycopy(toExtend, 0, tmp, 0, toExtend.length);
        System.arraycopy(other, 0, tmp, toExtend.length, other.length);
        return tmp;
    }

    public static <T> T[] clone(T[] toClone) {
        Object[] retval = (Object[])Array.newInstance(toClone.getClass().getComponentType(), toClone.length);
        System.arraycopy(toClone, 0, retval, 0, toClone.length);
        return retval;
    }

    public static int[] extract(int[] source, int start) {
        return Arrays.extract(source, start, source.length - start);
    }

    public static int[] extract(int[] source, int start, int length) {
        int realLength = Arrays.determineRealSize(source.length, start, length);
        int[] retval = new int[realLength];
        System.arraycopy(source, start, retval, 0, realLength);
        return retval;
    }

    public static int determineRealSize(int size, int start, int length) {
        if (start + length > size) {
            return size - start;
        }
        return length;
    }

    public static Serializable[] toSerializable(Integer[] ids) {
        Serializable[] retval = new Serializable[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = ids[i];
        }
        return retval;
    }
}

