/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum SessionExceptionCodes implements OXExceptionCode
{
    SESSIOND_EXCEPTION("Sessiond exception", Category.CATEGORY_ERROR, 1),
    MAX_SESSION_EXCEPTION("Maximum number of sessions elapsed", Category.CATEGORY_ERROR, 2),
    SESSIOND_CONFIG_EXCEPTION("Sessiond Config Exception", Category.CATEGORY_ERROR, 3),
    MISSING_PROPERTY("Missing property '%s'", Category.CATEGORY_CONFIGURATION, 4),
    UNKNOWN_EVENT_TOPIC("Unknown event topic %s", Category.CATEGORY_ERROR, 5),
    PASSWORD_UPDATE_FAILED("Password could not be changed", Category.CATEGORY_ERROR, 6),
    MAX_SESSION_PER_USER_EXCEPTION("Max. number of sessions exceeded for user %1$s in context %2$s", Category.CATEGORY_ERROR, 7),
    DUPLICATE_AUTHID("Authentication identifier duplicate found. Existing session login: %1$s. Current denied login request: %2$s.", Category.CATEGORY_ERROR, 8),
    WRONG_SESSION("SessionD returned wrong session with identifier %1$s for given session identifier %2$s.", Category.CATEGORY_ERROR, 9),
    SESSIONID_COLLISION("Got a collision while adding a new session to the session container. Colliding session has login %1$s and new session has login %2$s.", Category.CATEGORY_ERROR, 10),
    WRONG_BY_RANDOM("Received wrong session %1$s having random %2$s when looking for random %3$s and session %4$s.", Category.CATEGORY_ERROR, 11),
    SESSION_PARAMETER_MISSING("The session parameter is missing.", Category.CATEGORY_ERROR, 201),
    SESSION_EXPIRED("Your session %s expired. Please start a new browser session.", Category.CATEGORY_TRY_AGAIN, 203),
    CONTEXT_LOCKED("Context is locked.", Category.CATEGORY_TRY_AGAIN, 204),
    WRONG_CLIENT_IP("Request to server was refused. Original client IP address changed. Please try again.", Category.CATEGORY_PERMISSION_DENIED, 205),
    WRONG_SESSION_SECRET("Your session was invalidated. Please try again.", Category.CATEGORY_TRY_AGAIN, 206),
    MAX_SESSION_PER_CLIENT_EXCEPTION("Max. number of sessions exceeded for client %1$s of user %2$s in context %3$s", Category.CATEGORY_ERROR, 207);

    private static final String PREFIX = "SES";
    private final String message;
    private final Category category;
    private final int number;

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    public static String getErrorPrefix() {
        return PREFIX;
    }

    private SessionExceptionCodes(String message, Category category, int number) {
        this.message = message;
        this.category = category;
        this.number = number;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

