/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ServiceHolderInit
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(ServiceHolderInit.class));
    private static final String DEFAULT_TIMEOUT = "10000";
    private static final ServiceHolderInit SINGLETON = new ServiceHolderInit();
    private final AtomicBoolean started = new AtomicBoolean();

    public static ServiceHolderInit getInstance() {
        return SINGLETON;
    }

    private ServiceHolderInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws OXException {
        block19: {
            FileInputStream in;
            if (!this.started.compareAndSet(false, true)) {
                LOG.error((Object)"Service holder initialization already started", new Throwable());
                return;
            }
            String propDir = System.getProperties().getProperty("openexchange.propdir");
            if (null == propDir) {
                LOG.error((Object)"Missing property \"openexchange.propdir\"");
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            File sysPropFile = new File(propDir, "system.properties");
            if (!sysPropFile.exists() || !sysPropFile.isFile()) {
                LOG.error((Object)new StringAllocator("Missing property file \"system.properties\" in properties path \"").append(propDir).append('\"').toString());
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            try {
                in = new FileInputStream(sysPropFile);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            try {
                Properties sysProps = new Properties();
                try {
                    sysProps.load(in);
                    boolean serviceUsageInscpection = Boolean.parseBoolean(sysProps.getProperty("serviceUsageInspection", "false").trim());
                    if (serviceUsageInscpection) {
                        String serviceUsageTimeoutStr = sysProps.getProperty("serviceUsageTimeout", DEFAULT_TIMEOUT).trim();
                        int serviceUsageTimeout = -1;
                        try {
                            serviceUsageTimeout = Integer.parseInt(serviceUsageTimeoutStr);
                        }
                        catch (NumberFormatException e) {
                            LOG.error((Object)("Invalid property value for \"serviceUsageTimeout\": " + serviceUsageTimeoutStr));
                            serviceUsageTimeout = Integer.parseInt(DEFAULT_TIMEOUT);
                        }
                        ServiceHolder.enableServiceUsageInspection(serviceUsageTimeout);
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"Service usage inspection successfully enabled");
                        }
                        break block19;
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Service usage inspection not enabled");
                    }
                }
                catch (IOException e) {
                    throw ServiceExceptionCode.IO_ERROR.create();
                }
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error((Object)"Service holder initialization has not been started", new Throwable());
            return;
        }
    }
}

