/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceHolderListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

public abstract class ServiceHolder<S> {
    private static final Object PRESENT = new Object();
    private static boolean serviceUsageInspection = false;
    private static int serviceUsageTimeout;
    private static Timer serviceHolderTimer;
    private static final Log LOG;
    private final AtomicInteger countActive;
    private final Map<String, ServiceHolderListener<S>> listeners;
    private final Map<Thread, Map<ServiceProxy, Object>> usingThreads = new ConcurrentHashMap<Thread, Map<ServiceProxy, Object>>();
    private final AtomicBoolean waiting;
    private final AtomicReference<S> serviceReference;

    static void enableServiceUsageInspection(int serviceUsageTimeout) {
        ServiceHolder.serviceUsageTimeout = serviceUsageTimeout;
        serviceHolderTimer = new Timer("ServiceHolderTimer");
        serviceUsageInspection = true;
    }

    private static final String printStackTrace(StackTraceElement[] trace) {
        StringAllocator sb = new StringAllocator(512);
        for (int i = 2; i < trace.length; ++i) {
            sb.append("\tat ").append((Object)trace[i]).append('\n');
        }
        return sb.toString();
    }

    protected ServiceHolder() {
        this.countActive = new AtomicInteger();
        this.waiting = new AtomicBoolean();
        this.listeners = new ConcurrentHashMap<String, ServiceHolderListener<S>>();
        this.serviceReference = new AtomicReference();
        if (serviceUsageInspection) {
            serviceHolderTimer.schedule((TimerTask)new ServiceHolderTask(), 1000L, 5000L);
        }
    }

    public final void addServiceHolderListener(ServiceHolderListener<S> listener) throws Exception {
        if (this.listeners.containsKey(listener.getClass().getName())) {
            return;
        }
        this.listeners.put(listener.getClass().getName(), listener);
        if (null != this.serviceReference.get()) {
            listener.onServiceAvailable(this.serviceReference.get());
        }
    }

    public final S getService() {
        if (null == this.serviceReference.get()) {
            return null;
        }
        this.countActive.incrementAndGet();
        if (serviceUsageInspection) {
            ConcurrentHashMap<ServiceProxy, Object> newProxySet;
            Thread thread;
            ConcurrentHashMap<ServiceProxy, Object> proxySet;
            if (LOG.isWarnEnabled() && this.usingThreads.containsKey(Thread.currentThread())) {
                LOG.warn((Object)"Found thread using two (or more) services without ungetting service.", new Throwable());
            }
            if (null == (proxySet = this.usingThreads.get(thread = Thread.currentThread())) && null == (proxySet = (ConcurrentHashMap<ServiceProxy, Object>)this.usingThreads.put(thread, newProxySet = new ConcurrentHashMap<ServiceProxy, Object>()))) {
                proxySet = newProxySet;
            }
            ServiceProxy proxy = new ServiceProxy(this.serviceReference.get(), thread.getStackTrace());
            proxySet.put(proxy, PRESENT);
            return proxy.newProxyInstance();
        }
        return this.serviceReference.get();
    }

    private final void notifyListener(boolean isAvailable) throws Exception {
        if (isAvailable) {
            for (ServiceHolderListener<S> serviceHolderListener : this.listeners.values()) {
                serviceHolderListener.onServiceAvailable(this.serviceReference.get());
            }
        } else {
            for (ServiceHolderListener<S> serviceHolderListener : this.listeners.values()) {
                serviceHolderListener.onServiceRelease();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeService() throws Exception {
        if (null == this.serviceReference.get()) {
            return;
        }
        S service = this.serviceReference.get();
        if (serviceUsageInspection && this.countActive.get() > 0) {
            LOG.error((Object)("Service counting for " + this.getClass().getName() + " is not zero: " + this.countActive.toString()));
            if (this.waiting.compareAndSet(false, true)) {
                AtomicInteger atomicInteger = this.countActive;
                synchronized (atomicInteger) {
                    try {
                        while (this.countActive.get() > 0) {
                            this.countActive.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.waiting.set(false);
                    }
                }
            }
        }
        if (this.serviceReference.compareAndSet(service, null)) {
            this.notifyListener(false);
        }
    }

    public final void removeServiceHolderListenerByClass(Class<? extends ServiceHolderListener<S>> clazz) {
        this.listeners.remove(clazz.getName());
    }

    public final void removeServiceHolderListenerByName(String className) {
        this.listeners.remove(className);
    }

    public final void removeServiceHolderListenerByRef(ServiceHolderListener<S> listener) {
        Iterator<ServiceHolderListener<S>> iter = this.listeners.values().iterator();
        while (iter.hasNext()) {
            if (iter.next() != listener) continue;
            iter.remove();
        }
    }

    public final void clearServiceHolderListener() {
        this.listeners.clear();
    }

    public final void setService(S service) throws Exception {
        if (null == service) {
            LOG.warn((Object)"#setService called with null argument! ", new Throwable());
        }
        if (this.serviceReference.compareAndSet(null, service)) {
            this.notifyListener(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ungetService(S service) {
        Thread thread;
        Map<ServiceProxy, Object> proxySet;
        if (service == null || this.countActive.get() == 0) {
            return;
        }
        if (serviceUsageInspection && null != (proxySet = this.usingThreads.get(thread = Thread.currentThread()))) {
            Iterator<ServiceProxy> iter = proxySet.keySet().iterator();
            while (iter.hasNext()) {
                ServiceProxy proxy = iter.next();
                if (proxy.proxyService != service) continue;
                iter.remove();
            }
            if (proxySet.isEmpty()) {
                this.usingThreads.remove(thread);
            }
        }
        this.countActive.decrementAndGet();
        if (this.waiting.get()) {
            AtomicInteger atomicInteger = this.countActive;
            synchronized (atomicInteger) {
                if (this.waiting.get()) {
                    this.countActive.notifyAll();
                }
            }
        }
    }

    static {
        LOG = com.openexchange.log.Log.valueOf(LogFactory.getLog(ServiceHolder.class));
    }

    private final class ServiceProxy
    implements InvocationHandler {
        private final long creationTime;
        private S delegate;
        private S proxyService;
        private final StackTraceElement[] trace;

        public ServiceProxy(S service, StackTraceElement[] trace) {
            this.delegate = service;
            this.creationTime = System.currentTimeMillis();
            this.trace = trace;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result;
            if (this.delegate == null) {
                throw new NullPointerException("Service is not available anymore. Forgot to unget and reacquire?");
            }
            try {
                result = m.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            return result;
        }

        public S newProxyInstance() {
            if (this.proxyService == null) {
                Object s = Proxy.newProxyInstance(this.delegate.getClass().getClassLoader(), this.delegate.getClass().getInterfaces(), (InvocationHandler)this);
                this.proxyService = s;
            }
            return this.proxyService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propagateForcedUnget() {
            if (ServiceHolder.this.countActive.get() > 0) {
                ServiceHolder.this.countActive.decrementAndGet();
            }
            if (ServiceHolder.this.waiting.get()) {
                AtomicInteger atomicInteger = ServiceHolder.this.countActive;
                synchronized (atomicInteger) {
                    if (ServiceHolder.this.waiting.get()) {
                        ServiceHolder.this.countActive.notifyAll();
                    }
                }
            }
        }

        public boolean isExceeded() {
            return System.currentTimeMillis() - this.creationTime > (long)serviceUsageTimeout;
        }

        public StackTraceElement[] getTrace() {
            return this.trace;
        }
    }

    private final class ServiceHolderTask
    extends TimerTask {
        private ServiceHolderTask() {
        }

        @Override
        public void run() {
            try {
                if (ServiceHolder.this.usingThreads.isEmpty()) {
                    return;
                }
                Iterator iter = ServiceHolder.this.usingThreads.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    Map q = (Map)e.getValue();
                    Iterator proxyIter = q.keySet().iterator();
                    while (proxyIter.hasNext()) {
                        ServiceProxy proxy = (ServiceProxy)proxyIter.next();
                        if (!proxy.isExceeded()) continue;
                        LOG.error((Object)("Forced unget: Found non-ungetted service after " + serviceUsageTimeout + "msec that was acquired at:\n" + ServiceHolder.printStackTrace(proxy.trace)));
                        proxy.proxyService = null;
                        proxy.delegate = null;
                        proxy.propagateForcedUnget();
                        proxyIter.remove();
                    }
                    if (!q.isEmpty()) continue;
                    iter.remove();
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

