/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.Props;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LogProperties {
    private static final List<LogPropertyName> PROPERTY_NAMES = new CopyOnWriteArrayList<LogPropertyName>();
    private static final ConcurrentMap<Thread, Props> THREAD_LOCAL = new ConcurrentHashMap<Thread, Props>();

    private LogProperties() {
    }

    public static void configuredProperties(Collection<LogPropertyName> propertyNames) {
        PROPERTY_NAMES.clear();
        if (null != propertyNames && !propertyNames.isEmpty()) {
            PROPERTY_NAMES.addAll(new TreeSet<LogPropertyName>(propertyNames));
        }
    }

    public static List<LogPropertyName> getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public static boolean isEnabled() {
        return !PROPERTY_NAMES.isEmpty();
    }

    public static Props optLogProperties() {
        Props props = (Props)THREAD_LOCAL.get(Thread.currentThread());
        if (props == null) {
            return null;
        }
        return props.copy();
    }

    public static Props optLogProperties(Thread thread) {
        if (null == thread) {
            return null;
        }
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (props == null) {
            return null;
        }
        return props.copy();
    }

    public static void removeLogProperties() {
        THREAD_LOCAL.remove(Thread.currentThread());
    }

    public static Props getLogProperties() {
        Props newprops;
        Thread thread = Thread.currentThread();
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (null == props && null == (props = THREAD_LOCAL.putIfAbsent(thread, newprops = new Props(new ConcurrentHashMap<String, Object>(16))))) {
            props = newprops;
        }
        return props;
    }

    public static void cloneLogProperties(Thread other) {
        Thread thread = Thread.currentThread();
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (null == props) {
            return;
        }
        THREAD_LOCAL.put(other, new Props(new ConcurrentHashMap<String, Object>(props.getMap())));
    }

    public static <V> V getLogProperty(String name) {
        Thread thread = Thread.currentThread();
        Props props = (Props)THREAD_LOCAL.get(thread);
        return null == props ? null : (V)props.get(name);
    }

    public static void putLogProperty(String name, Object value) {
        if (null == value) {
            LogProperties.getLogProperties().remove(name);
        } else {
            LogProperties.getLogProperties().put(name, value);
        }
    }

    public static String getAndPrettyPrint() {
        String logString = "";
        Props logProperties = LogProperties.getLogProperties();
        if (logProperties != null) {
            StringAllocator logBuilder = new StringAllocator(1024);
            Map<String, Object> propertyMap = logProperties.getMap();
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                if (null == value) continue;
                sorted.put(propertyName, value.toString());
            }
            for (Map.Entry<String, Object> entry : sorted.entrySet()) {
                logBuilder.append(entry.getKey()).append('=').append((String)entry.getValue()).append('\n');
            }
            logString = logBuilder.toString();
        }
        return logString;
    }
}

