/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.log.AbstractDelegatingLogger;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CommonsLoggingLogger
extends AbstractDelegatingLogger {
    private final org.apache.commons.logging.Log logger;

    public CommonsLoggingLogger(Class<?> clazz) {
        super(clazz.getName(), null);
        this.logger = Log.valueOf(LogFactory.getLog(clazz.getName()));
    }

    public CommonsLoggingLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = Log.valueOf(LogFactory.getLog(name));
    }

    @Override
    protected boolean supportsHandlers() {
        return true;
    }

    @Override
    public Level getLevel() {
        Level level = this.logger.isTraceEnabled() ? Level.FINEST : (this.logger.isDebugEnabled() ? Level.FINER : (this.logger.isInfoEnabled() ? Level.INFO : (this.logger.isWarnEnabled() ? Level.WARNING : (this.logger.isErrorEnabled() ? Level.SEVERE : Level.OFF))));
        return level;
    }

    @Override
    public boolean isLoggable(Level level) {
        int i = level.intValue();
        if (i == Level.OFF.intValue()) {
            return false;
        }
        if (i >= Level.SEVERE.intValue()) {
            return this.logger.isErrorEnabled();
        }
        if (i >= Level.WARNING.intValue()) {
            return this.logger.isWarnEnabled();
        }
        if (i >= Level.INFO.intValue()) {
            return this.logger.isInfoEnabled();
        }
        if (i >= Level.FINER.intValue()) {
            return this.logger.isDebugEnabled();
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    protected void internalLogFormatted(String msg, LogRecord record) {
        Level level = record.getLevel();
        Throwable t = record.getThrown();
        Handler[] targets = this.getHandlers();
        if (targets != null) {
            for (Handler h : targets) {
                h.publish(record);
            }
        }
        if (!this.getUseParentHandlers()) {
            return;
        }
        if (Level.FINE.equals(level)) {
            this.logger.debug((Object)msg, t);
        } else if (Level.INFO.equals(level)) {
            this.logger.info((Object)msg, t);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn((Object)msg, t);
        } else if (Level.FINER.equals(level)) {
            this.logger.trace((Object)msg, t);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace((Object)msg, t);
        } else if (Level.ALL.equals(level)) {
            this.logger.error((Object)msg, t);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error((Object)msg, t);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.debug((Object)msg, t);
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }
}

