/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.LogLevel;

public interface Category {
    public static final Category CATEGORY_ERROR = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.ERROR;
        }

        public String toString() {
            return EnumType.ERROR.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_USER_INPUT = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.DEBUG;
        }

        @Override
        public Type getType() {
            return EnumType.USER_INPUT;
        }

        public String toString() {
            return EnumType.USER_INPUT.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_CONFIGURATION = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.CONFIGURATION;
        }

        public String toString() {
            return EnumType.CONFIGURATION.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_PERMISSION_DENIED = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.PERMISSION_DENIED;
        }

        public String toString() {
            return EnumType.PERMISSION_DENIED.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_TRY_AGAIN = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.DEBUG;
        }

        @Override
        public Type getType() {
            return EnumType.TRY_AGAIN;
        }

        public String toString() {
            return EnumType.TRY_AGAIN.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_CONNECTIVITY = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.TRY_AGAIN;
        }

        public String toString() {
            return EnumType.TRY_AGAIN.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_SERVICE_DOWN = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.SERVICE_DOWN;
        }

        public String toString() {
            return EnumType.SERVICE_DOWN.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_TRUNCATED = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.DEBUG;
        }

        @Override
        public Type getType() {
            return EnumType.TRUNCATED;
        }

        public String toString() {
            return EnumType.TRUNCATED.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_CONFLICT = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.CONFLICT;
        }

        public String toString() {
            return EnumType.CONFLICT.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_CAPACITY = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.CAPACITY;
        }

        public String toString() {
            return EnumType.CAPACITY.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };
    public static final Category CATEGORY_WARNING = new Category(){

        @Override
        public LogLevel getLogLevel() {
            return LogLevel.ERROR;
        }

        @Override
        public Type getType() {
            return EnumType.WARNING;
        }

        public String toString() {
            return EnumType.WARNING.getName();
        }

        @Override
        public int compareTo(Category other) {
            return LogLevel.COMPARATOR.compare(this.getLogLevel(), other.getLogLevel());
        }
    };

    public LogLevel getLogLevel();

    public Type getType();

    public int compareTo(Category var1);

    public static enum EnumCategory implements Category
    {
        ERROR(CATEGORY_ERROR),
        USER_INPUT(CATEGORY_USER_INPUT),
        CONFIGURATION(CATEGORY_CONFIGURATION),
        PERMISSION_DENIED(CATEGORY_PERMISSION_DENIED),
        TRY_AGAIN(CATEGORY_TRY_AGAIN),
        CONNECTIVITY(CATEGORY_CONNECTIVITY),
        SERVICE_DOWN(CATEGORY_SERVICE_DOWN),
        TRUNCATED(CATEGORY_TRUNCATED),
        CONFLICT(CATEGORY_CONFLICT),
        CAPACITY(CATEGORY_CAPACITY),
        WARNING(CATEGORY_WARNING);

        private final Category impl;

        private EnumCategory(Category impl) {
            this.impl = impl;
        }

        @Override
        public int compareTo(Category o) {
            return this.impl.compareTo(o);
        }

        @Override
        public LogLevel getLogLevel() {
            return this.impl.getLogLevel();
        }

        @Override
        public Type getType() {
            return this.impl.getType();
        }
    }

    public static enum EnumType implements Type
    {
        ERROR,
        TRY_AGAIN,
        USER_INPUT,
        PERMISSION_DENIED,
        CONFIGURATION,
        CONNECTIVITY,
        SERVICE_DOWN,
        TRUNCATED,
        CONFLICT,
        CAPACITY,
        WARNING;


        @Override
        public String getName() {
            return this.toString();
        }
    }

    public static interface Type {
        public String getName();
    }
}

