/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Filter;
import com.openexchange.config.PropertyListener;
import com.openexchange.config.WildcardFilter;
import com.openexchange.config.internal.PropertyWatcher;
import com.openexchange.config.internal.filewatcher.FileWatcher;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.ho.yaml.Yaml;

public final class ConfigurationImpl
implements ConfigurationService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ConfigurationImpl.class));
    private static final String EXT = ".properties";
    private final Map<String, String> texts;
    private final File[] dirs;
    private final Map<String, Properties> propertiesByFile;
    private final Map<String, String> properties;
    private final Map<String, String> propertiesFiles;
    final Map<String, Object> yamlFiles;
    final Map<String, String> yamlPaths;

    private static final String[] getDirectories() {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String property : new String[]{"openexchange.propdir"}) {
            String sysProp = System.getProperty(property);
            if (null == sysProp) continue;
            tmp.add(sysProp);
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    public ConfigurationImpl() {
        this(ConfigurationImpl.getDirectories());
    }

    public ConfigurationImpl(String[] directories) {
        if (null == directories || directories.length == 0) {
            throw new IllegalArgumentException("Missing configuration directory path.");
        }
        this.propertiesByFile = new HashMap<String, Properties>();
        this.texts = new ConcurrentHashMap<String, String>();
        this.properties = new HashMap<String, String>();
        this.propertiesFiles = new HashMap<String, String>();
        this.yamlFiles = new HashMap<String, Object>();
        this.yamlPaths = new HashMap<String, String>();
        PropertyFileFilter fileFilter = new PropertyFileFilter();
        this.dirs = new File[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            File dir;
            if (null == directories[i]) {
                throw new IllegalArgumentException("Given configuration directory path is null.");
            }
            this.dirs[i] = dir = new File(directories[i]);
            if (!dir.exists()) {
                throw new IllegalArgumentException(MessageFormat.format("Not found: \"{0}\".", directories[i]));
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(MessageFormat.format("Not a directory: {0}", directories[i]));
            }
            this.processDirectory(dir, fileFilter, new FileProcessor(){

                @Override
                public void processFile(File file) {
                    ConfigurationImpl.this.processPropertiesFile(file);
                }
            });
            this.processDirectory(dir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".yml") || pathname.getName().endsWith(".yaml");
                }
            }, new FileProcessor(){

                @Override
                public void processFile(File file) {
                    Object o = null;
                    try {
                        o = Yaml.load((File)file);
                    }
                    catch (FileNotFoundException e) {
                        return;
                    }
                    catch (RuntimeException x) {
                        LOG.error((Object)file, (Throwable)x);
                        throw x;
                    }
                    ConfigurationImpl.this.yamlPaths.put(file.getName(), file.getPath());
                    ConfigurationImpl.this.yamlFiles.put(file.getPath(), o);
                }
            });
        }
    }

    private void processDirectory(File dir, FileFilter fileFilter, FileProcessor processor) {
        File[] files = dir.listFiles(fileFilter);
        if (files == null) {
            LOG.info((Object)MessageFormat.format("Can't read {0}. Skipping.", dir));
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.processDirectory(file, fileFilter, processor);
                continue;
            }
            processor.processFile(file);
        }
    }

    void processPropertiesFile(File propFile) {
        try {
            if (!propFile.exists() || !propFile.canRead()) {
                return;
            }
            Properties tmp = ConfigurationImpl.loadProperties(propFile);
            String propFilePath = propFile.getPath();
            this.propertiesByFile.put(propFilePath, tmp);
            int size = tmp.size();
            Iterator<Map.Entry<Object, Object>> iter = tmp.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry<Object, Object> e = iter.next();
                String propName = e.getKey().toString().trim();
                String otherValue = this.properties.get(propName);
                if (this.properties.containsKey(propName) && otherValue != null && !otherValue.equals(e.getValue())) {
                    String otherFile = this.propertiesFiles.get(propName);
                    if (LOG.isDebugEnabled()) {
                        StringAllocator sa = new StringAllocator(64).append("Overwriting property ").append(propName).append(" from file '");
                        sa.append(otherFile).append("' with property from file '").append(propFilePath).append("', overwriting value '");
                        sa.append(otherValue).append("' with value '").append(e.getValue()).append("'.");
                        LOG.debug((Object)sa.toString());
                    }
                }
                this.properties.put(propName, e.getValue().toString().trim());
                this.propertiesFiles.put(propName, propFilePath);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An error occurred while processing property file \"" + propFile + "\"."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File propFile) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propFile));
        try {
            Properties tmp = new Properties();
            tmp.load(fis);
            Properties properties = tmp;
            return properties;
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Filter getFilterFromProperty(String name) {
        String value = this.properties.get(name);
        if (null == value) {
            return null;
        }
        return new WildcardFilter(value);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.properties.containsKey(name) ? this.properties.get(name) : defaultValue;
    }

    @Override
    public String getProperty(String name, PropertyListener listener) {
        if (this.properties.containsKey(name)) {
            PropertyWatcher pw = PropertyWatcher.addPropertyWatcher(name, this.properties.get(name), true);
            pw.addPropertyListener(listener);
            FileWatcher fileWatcher = FileWatcher.getFileWatcher(new File(this.propertiesFiles.get(name)));
            fileWatcher.addFileListener(pw);
            fileWatcher.startFileWatcher(10000L);
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public String getProperty(String name, String defaultValue, PropertyListener listener) {
        if (this.properties.containsKey(name)) {
            PropertyWatcher pw = PropertyWatcher.addPropertyWatcher(name, this.properties.get(name), true);
            pw.addPropertyListener(listener);
            FileWatcher fileWatcher = FileWatcher.getFileWatcher(new File(this.propertiesFiles.get(name)));
            fileWatcher.addFileListener(pw);
            fileWatcher.startFileWatcher(10000L);
            return this.properties.get(name);
        }
        return defaultValue;
    }

    @Override
    public void removePropertyListener(String name, PropertyListener listener) {
        PropertyWatcher pw = PropertyWatcher.getPropertyWatcher(name);
        if (pw != null) {
            pw.removePropertyListener(listener);
            if (pw.isEmpty()) {
                PropertyWatcher.removePropertWatcher(name);
            }
        }
    }

    @Override
    public Properties getFile(String fileName) {
        return this.getFile(fileName, null);
    }

    public Properties getFile(String filename, PropertyListener listener) {
        String key = null;
        for (String k : this.propertiesByFile.keySet()) {
            if (!k.endsWith(filename)) continue;
            key = k;
            break;
        }
        if (key == null) {
            return new Properties();
        }
        Properties tmp = this.propertiesByFile.get(key);
        Properties retval = new Properties();
        for (Map.Entry<Object, Object> entry : tmp.entrySet()) {
            retval.put(entry.getKey(), entry.getValue());
        }
        if (listener != null) {
            for (Object k : retval.keySet()) {
                this.getProperty((String)k, listener);
            }
        }
        return retval;
    }

    @Override
    public Properties getPropertiesInFolder(String folderName) {
        return this.getPropertiesInFolder(folderName, null);
    }

    public Properties getPropertiesInFolder(String folderName, PropertyListener listener) {
        Properties retval = new Properties();
        Iterator<Map.Entry<String, String>> iter = this.propertiesFiles.entrySet().iterator();
        String fldName = folderName;
        for (File dir : this.dirs) {
            fldName = dir.getAbsolutePath() + File.separatorChar + fldName + File.separatorChar;
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (!entry.getValue().startsWith(fldName)) continue;
                String value = null == listener ? this.getProperty(entry.getKey()) : this.getProperty(entry.getKey(), listener);
                retval.put(entry.getKey(), value);
            }
        }
        return retval;
    }

    @Override
    public boolean getBoolProperty(String name, boolean defaultValue) {
        String prop = this.properties.get(name);
        if (null != prop) {
            return Boolean.parseBoolean(prop.trim());
        }
        return defaultValue;
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        block3: {
            String prop = this.properties.get(name);
            if (prop != null) {
                try {
                    return Integer.parseInt(prop.trim());
                }
                catch (NumberFormatException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return defaultValue;
    }

    @Override
    public Iterator<String> propertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public File getFileByName(String fileName) {
        if (null == fileName) {
            return null;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            File f = this.traverseForFile(new File(dir), fileName);
            if (f == null) continue;
            return f;
        }
        int pos = fileName.lastIndexOf(47);
        if (pos < 0 && (pos = fileName.lastIndexOf(92)) < 0) {
            LOG.warn((Object)("No such file: " + fileName));
            return null;
        }
        String fn = fileName.substring(pos + 1);
        for (String dir : ConfigurationImpl.getDirectories()) {
            File f = this.traverseForFile(new File(dir), fn);
            if (f == null) continue;
            return f;
        }
        LOG.warn((Object)("No such file: " + fileName));
        return null;
    }

    private File traverseForFile(File file, String fileName) {
        if (null == file) {
            return null;
        }
        if (file.isFile()) {
            if (fileName.equals(file.getName())) {
                return file;
            }
            return null;
        }
        File[] subs = file.listFiles();
        if (subs != null) {
            for (File sub : subs) {
                File f = this.traverseForFile(sub, fileName);
                if (f == null) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public File getDirectory(String directoryName) {
        if (null == directoryName) {
            return null;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            File fdir = this.traverseForDir(new File(dir), directoryName);
            if (fdir == null) continue;
            return fdir;
        }
        LOG.warn((Object)("No such directory: " + directoryName));
        return null;
    }

    private File traverseForDir(File file, String directoryName) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory() && directoryName.equals(file.getName())) {
            return file;
        }
        File[] subDirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (subDirs != null) {
            for (File subDir : subDirs) {
                if (!subDir.isDirectory() || !directoryName.equals(subDir.getName())) continue;
                return subDir;
            }
            for (File subDir : subDirs) {
                File dir = this.traverseForDir(subDir, directoryName);
                if (dir == null) continue;
                return dir;
            }
        }
        return null;
    }

    @Override
    public String getText(String fileName) {
        String text = this.texts.get(fileName);
        if (text != null) {
            return text;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            String s = this.traverse(new File(dir), fileName);
            if (s == null) continue;
            this.texts.put(fileName, s);
            return s;
        }
        return null;
    }

    private String traverse(File file, String filename) {
        if (null == file) {
            return null;
        }
        if (file.isFile()) {
            if (file.getName().equals(filename)) {
                return this.readFile(file);
            }
            return null;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                String s = this.traverse(f, filename);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) {
        Reader reader = null;
        try {
            int read;
            reader = new InputStreamReader(new FileInputStream(file));
            StringAllocator builder = new StringAllocator((int)file.length());
            int buflen = 8192;
            char[] cbuf = new char[8192];
            while ((read = reader.read(cbuf, 0, 8192)) > 0) {
                builder.append(cbuf, 0, read);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException x) {
            LOG.fatal((Object)("Can't read file: " + file));
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Object getYaml(String filename) {
        String path = this.yamlPaths.get(filename);
        if (path == null) {
            path = this.yamlPaths.get(filename + ".yml");
        }
        if (path == null) {
            path = this.yamlPaths.get(filename + ".yaml");
        }
        if (path == null) {
            return null;
        }
        return this.yamlFiles.get(path);
    }

    @Override
    public Map<String, Object> getYamlInFolder(String folderName) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> iter = this.yamlFiles.entrySet().iterator();
        String fldName = folderName;
        for (File dir : this.dirs) {
            fldName = dir.getAbsolutePath() + File.separatorChar + fldName + File.separatorChar;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                if (!entry.getKey().startsWith(fldName)) continue;
                retval.put(entry.getKey(), entry.getValue());
            }
        }
        return retval;
    }

    private static interface FileProcessor {
        public void processFile(File var1);
    }

    private static final class PropertyFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(ConfigurationImpl.EXT);
        }
    }
}

