/*
 * Decompiled with CFR 0.152.
 */
package com.davekoelle;

import com.openexchange.java.StringAllocator;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class AlphanumComparator
implements Comparator<String> {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final Collator DEFAULT_COLLATOR;
    private final Collator collator;
    private final Locale locale;

    public AlphanumComparator() {
        this(null);
    }

    public AlphanumComparator(Locale locale) {
        if (null == locale) {
            this.collator = DEFAULT_COLLATOR;
            this.locale = DEFAULT_LOCALE;
        } else {
            this.locale = locale;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }
    }

    private final String getChunk(String s, int length, int start) {
        char c = s.charAt(start);
        boolean digit = Character.isDigit(c);
        StringAllocator chunk = new StringAllocator(length - start);
        chunk.append(c);
        for (int marker = start + 1; marker < length && digit == Character.isDigit(c = s.charAt(marker)); ++marker) {
            chunk.append(c);
        }
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (Character.isDigit(thisChunk.charAt(0)) && Character.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = this.collator.compare(thisChunk.toLowerCase(this.locale), thatChunk.toLowerCase(this.locale));
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    static {
        Collator collator = Collator.getInstance(DEFAULT_LOCALE);
        collator.setStrength(1);
        DEFAULT_COLLATOR = collator;
    }
}

