/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.TaskWriter;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.ResponseParser;
import com.openexchange.webdav.xml.request.PropFindMethod;
import com.openexchange.webdav.xml.types.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class TaskTest
extends AbstractWebdavXMLTest {
    protected int taskFolderId = -1;
    protected String userParticipant2 = null;
    protected String userParticipant3 = null;
    protected String groupParticipant = null;
    protected Date startTime = null;
    protected Date endTime = null;
    protected Date dateCompleted = null;
    protected static final long d7 = 604800000L;
    private static final String TASK_URL = "/servlet/webdav.tasks";

    public TaskTest(String name) {
        super(name);
    }

    protected static Date decrementDate(Date date) {
        return new Date(date.getTime() - 1L);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.startTime = new Date(c.getTimeInMillis());
        this.endTime = new Date(this.startTime.getTime() + 86400000L);
        this.dateCompleted = new Date(c.getTimeInMillis() + 604800000L);
        this.userParticipant2 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant2", (String)"");
        this.userParticipant3 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant3", (String)"");
        this.groupParticipant = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"group_participant", (String)"");
        FolderObject folderObj = FolderTest.getTaskDefaultFolder(this.webCon, "http://" + this.hostName, this.login, this.password, this.context);
        this.taskFolderId = folderObj.getObjectID();
        this.userId = folderObj.getCreatedBy();
    }

    public static void compareObject(Task taskObj1, Task taskObj2) throws Exception {
        TaskTest.assertEquals((String)"id is not equals", (int)taskObj1.getObjectID(), (int)taskObj2.getObjectID());
        TaskTest.assertEqualsAndNotNull("title is not equals", taskObj1.getTitle(), taskObj2.getTitle());
        TaskTest.assertEqualsAndNotNull("start is not equals", taskObj1.getStartDate(), taskObj2.getStartDate());
        TaskTest.assertEqualsAndNotNull("end is not equals", taskObj1.getEndDate(), taskObj2.getEndDate());
        TaskTest.assertEquals((String)"folder id is not equals", (int)taskObj1.getParentFolderID(), (int)taskObj2.getParentFolderID());
        TaskTest.assertEquals((String)"private flag is not equals", (boolean)taskObj1.getPrivateFlag(), (boolean)taskObj2.getPrivateFlag());
        TaskTest.assertEquals((String)"alarm is not equals", (Object)taskObj1.getAlarm(), (Object)taskObj2.getAlarm());
        TaskTest.assertEqualsAndNotNull("note is not equals", taskObj1.getNote(), taskObj2.getNote());
        TaskTest.assertEqualsAndNotNull("categories is not equals", taskObj1.getCategories(), taskObj2.getCategories());
        TaskTest.assertEqualsAndNotNull("actual costs is not equals", taskObj1.getActualCosts(), taskObj2.getActualCosts());
        TaskTest.assertEqualsAndNotNull("actual duration", taskObj1.getActualDuration(), taskObj2.getActualDuration());
        TaskTest.assertEqualsAndNotNull("billing information", taskObj1.getBillingInformation(), taskObj2.getBillingInformation());
        TaskTest.assertEqualsAndNotNull("companies", taskObj1.getCompanies(), taskObj2.getCompanies());
        TaskTest.assertEqualsAndNotNull("currency", taskObj1.getCurrency(), taskObj2.getCurrency());
        TaskTest.assertEqualsAndNotNull("date completed", taskObj1.getDateCompleted(), taskObj2.getDateCompleted());
        TaskTest.assertEqualsAndNotNull("percent complete", taskObj1.getPercentComplete(), taskObj2.getPercentComplete());
        TaskTest.assertEqualsAndNotNull("priority", taskObj1.getPriority(), taskObj2.getPriority());
        TaskTest.assertEqualsAndNotNull("status", taskObj1.getStatus(), taskObj2.getStatus());
        TaskTest.assertEqualsAndNotNull("target costs", taskObj1.getTargetCosts(), taskObj2.getTargetCosts());
        TaskTest.assertEqualsAndNotNull("target duration", taskObj1.getTargetDuration(), taskObj2.getTargetDuration());
        TaskTest.assertEqualsAndNotNull("trip meter", taskObj1.getTripMeter(), taskObj2.getTripMeter());
        TaskTest.assertEqualsAndNotNull("participants are not equals", TaskTest.participants2String(taskObj1.getParticipants()), TaskTest.participants2String(taskObj2.getParticipants()));
        TaskTest.assertEqualsAndNotNull("users are not equals", TaskTest.users2String(taskObj1.getUsers()), TaskTest.users2String(taskObj2.getUsers()));
    }

    protected Task createTask(String title) throws Exception {
        Task taskObj = new Task();
        taskObj.setTitle(title);
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(this.taskFolderId);
        taskObj.setStatus(2);
        taskObj.setPercentComplete(50);
        return taskObj;
    }

    public static int insertTask(WebConversation webCon, Task taskObj, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        int objectId = 0;
        taskObj.removeObjectID();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        TaskWriter taskWriter = new TaskWriter();
        taskWriter.addContent2PropElement(eProp, taskObj, false);
        Document doc = TaskTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + TASK_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + TaskTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        TaskTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 4);
        TaskTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        taskObj = (Task)response[0].getDataObject();
        objectId = taskObj.getObjectID();
        TaskTest.assertNotNull((String)"last modified is null", (Object)taskObj.getLastModified());
        TaskTest.assertTrue((String)"last modified is not > 0", (taskObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        TaskTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        TaskTest.assertTrue((String)"check objectId", (objectId > 0 ? 1 : 0) != 0);
        return objectId;
    }

    public static int[] insertTasks(WebConversation webCon, String host, String login, String password, String context, Task ... tasks) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        int[] objectIds = new int[tasks.length];
        TaskWriter taskWriter = new TaskWriter();
        Element rootElement = new Element("propertyupdate", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        Document doc = new Document(rootElement);
        for (Task taskObj : tasks) {
            Element eProp = new Element("prop", webdav);
            taskWriter.addContent2PropElement(eProp, taskObj, false);
            Element eSet = new Element("set", webdav);
            eSet.addContent((Content)eProp);
            rootElement.addContent((Content)eSet);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + TASK_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + TaskTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        TaskTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 4);
        TaskTest.assertEquals((String)"check response", (int)tasks.length, (int)response.length);
        for (int i = 0; i < tasks.length; ++i) {
            if (response[i].hasError()) {
                throw new TestException(response[i].getErrorMessage());
            }
            Task taskObj = (Task)response[i].getDataObject();
            objectIds[i] = taskObj.getObjectID();
            TaskTest.assertNotNull((String)"last modified is null", (Object)taskObj.getLastModified());
            TaskTest.assertTrue((String)"last modified is not > 0", (taskObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        }
        return objectIds;
    }

    public static void updateTask(WebConversation webCon, Task taskObj, int objectId, int inFolder, String host, String login, String password, String context) throws Exception {
        TaskTest.updateTask(webCon, taskObj, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static void updateTask(WebConversation webCon, Task taskObj, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        taskObj.setObjectID(objectId);
        taskObj.setLastModified(lastModified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        TaskWriter appointmentWriter = new TaskWriter();
        appointmentWriter.addContent2PropElement(eProp, taskObj, false);
        Document doc = TaskTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + TASK_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + TaskTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        TaskTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 4);
        TaskTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        taskObj = (Task)response[0].getDataObject();
        objectId = taskObj.getObjectID();
        TaskTest.assertNotNull((String)"last modified is null", (Object)taskObj.getLastModified());
        TaskTest.assertTrue((String)"last modified is not > 0", (taskObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        TaskTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static int[] deleteTask(WebConversation webCon, int[][] objectIdAndFolderId, String host, String login, String password, String context) throws Exception {
        new ArrayList();
        for (int a = 0; a < objectIdAndFolderId.length; ++a) {
            TaskTest.deleteTask(webCon, objectIdAndFolderId[a][0], objectIdAndFolderId[a][1], host, login, password, context);
        }
        return new int[0];
    }

    public static void deleteTask(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws Exception {
        TaskTest.deleteTask(webCon, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static void deleteTask(WebConversation webCon, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Task taskObj = new Task();
        taskObj.setObjectID(objectId);
        taskObj.setParentFolderID(inFolder);
        taskObj.setLastModified(lastModified);
        Element eProp = new Element("prop", webdav);
        TaskWriter taskWriter = new TaskWriter();
        taskWriter.addContent2PropElement(eProp, taskObj, false);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("DELETE");
        eProp.addContent((Content)eMethod);
        rootElement.addContent((Content)TaskTest.addProp2PropertyUpdate(eProp));
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + TASK_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + TaskTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        TaskTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 4);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        TaskTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static void confirmTask(WebConversation webCon, int objectId, int confirm, String confirmMessage, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eObjectId.addContent(String.valueOf(objectId));
        eProp.addContent((Content)eObjectId);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("CONFIRM");
        eProp.addContent((Content)eMethod);
        Element eConfirm = new Element("confirm", XmlServlet.NS);
        switch (confirm) {
            case 0: {
                eConfirm.addContent("none");
                break;
            }
            case 1: {
                eConfirm.addContent("accept");
                break;
            }
            case 2: {
                eConfirm.addContent("decline");
                break;
            }
            default: {
                eConfirm.addContent("invalid");
            }
        }
        eProp.addContent((Content)eConfirm);
        Document doc = TaskTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + TASK_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + TaskTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        TaskTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 4);
        TaskTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            TaskTest.fail((String)("xml error: " + response[0].getErrorMessage()));
        }
        TaskTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static int[] listTask(WebConversation webCon, int inFolder, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eObjectmode.addContent("LIST");
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, TaskTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + TASK_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        TaskTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 4, true);
        TaskTest.assertEquals((String)"response length not is 1", (int)1, (int)response.length);
        return (int[])response[0].getDataObject();
    }

    private static Credentials getCredentials(String login, String password, String context) {
        return new UsernamePasswordCredentials(context == null || context.equals("") ? login : login + "@" + context, password);
    }

    public static Task[] listTask(WebConversation webCon, int inFolder, Date modified, boolean changed, boolean deleted, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        if (!changed && !deleted) {
            return new Task[0];
        }
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eLastSync = new Element("lastsync", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eLastSync.addContent(String.valueOf(modified.getTime()));
        StringBuffer objectMode = new StringBuffer();
        if (changed) {
            objectMode.append("NEW_AND_MODIFIED,");
        }
        if (deleted) {
            objectMode.append("DELETED,");
        }
        objectMode.delete(objectMode.length() - 1, objectMode.length());
        eObjectmode.addContent(objectMode.toString());
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eLastSync);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, TaskTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + TASK_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        TaskTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 4);
        Task[] taskArray = new Task[response.length];
        for (int a = 0; a < taskArray.length; ++a) {
            if (response[a].hasError()) {
                TaskTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            taskArray[a] = (Task)response[a].getDataObject();
            TaskTest.assertNotNull((String)"last modified is null", (Object)taskArray[a].getLastModified());
        }
        return taskArray;
    }

    public static Task loadTask(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eObjectId.addContent(String.valueOf(objectId));
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eObjectId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, TaskTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + TASK_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        TaskTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 4);
        TaskTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        TaskTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        return (Task)response[0].getDataObject();
    }

    private static HashSet participants2String(Participant[] participant) throws Exception {
        if (participant == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < participant.length; ++a) {
            hs.add(TaskTest.participant2String(participant[a]));
        }
        return hs;
    }

    private static String participant2String(Participant p) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("T" + p.getType());
        sb.append("ID" + p.getIdentifier());
        return sb.toString();
    }

    private static HashSet users2String(UserParticipant[] users) throws Exception {
        if (users == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < users.length; ++a) {
            hs.add(TaskTest.user2String(users[a]));
        }
        return hs;
    }

    private static String user2String(UserParticipant user) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + user.getIdentifier());
        sb.append("C" + user.getConfirm());
        return sb.toString();
    }
}

