/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.test.XMLCompare;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavPropfindAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.util.Utils;
import java.util.Date;
import org.jdom2.Namespace;

public class PropfindTest
extends ActionTestCase {
    private static final Namespace TEST_NS = Namespace.getNamespace((String)"http://www.open-xchange.com/namespace/webdav-test");
    private WebdavPath INDEX_HTML_URL = null;
    private WebdavPath DEVELOPMENT_URL = null;
    private WebdavPath SPECIAL_URL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new WebdavPath((CharSequence)"index.html"));
        this.DEVELOPMENT_URL = this.testCollection.dup().append(new String[]{"development"});
        this.SPECIAL_URL = this.testCollection.dup().append(new String[]{"special characters?"});
    }

    public void testOneProperty() throws Exception {
        Date lastModified = this.factory.resolveResource(this.INDEX_HTML_URL).getLastModified();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:getlastmodified>" + Utils.convert((Date)lastModified) + "</D:getlastmodified></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>");
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("getlastmodified", "status");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>");
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("depth", "0");
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testManyProperties() throws Exception {
        Date lastModified = this.factory.resolveResource(this.INDEX_HTML_URL).getLastModified();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/><D:displayname/><D:resourcetype/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:getlastmodified>" + Utils.convert((Date)lastModified) + "</D:getlastmodified><D:displayname>index.html</D:displayname><D:resourcetype /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/><D:displayname/><D:resourcetype/></D:prop></D:propfind>");
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("getlastmodified", "displayname", "resourcetype", "status");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testPropNames() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:propname /></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><multistatus xmlns=\"DAV:\"><response><href>http://localhost/" + this.INDEX_HTML_URL + "</href><propstat><prop><getlastmodified /><creationdate /><resourcetype /><displayname /><getcontentlanguage /><getcontentlength /><getcontenttype /><getetag /><lockdiscovery /><supportedlock /><source /></prop><status>HTTP/1.1 200 OK</status></propstat></response></multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:propname /></D:propfind>");
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("creationdate", "resourcetype", "displayname", "getcontenttype", "getcontentlanguage", "getcontentlength", "getlastmodified", "getetag", "source", "status", "lockdiscovery", "supportedlock");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testAllProperties() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop /></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><multistatus xmlns=\"DAV:\"><response><href>http://localhost/" + this.INDEX_HTML_URL + "</href><propstat><prop><getlastmodified>" + Utils.convert((Date)resource.getLastModified()) + "</getlastmodified> <creationdate>" + Utils.convert((Date)resource.getCreationDate()) + "</creationdate><resourcetype /><displayname>" + resource.getDisplayName() + "</displayname><getcontentlanguage/><getcontentlength>" + resource.getLength() + "</getcontentlength><getcontenttype>" + resource.getContentType() + "</getcontenttype><getetag>" + resource.getETag() + "</getetag><lockdiscovery /><supportedlock><lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry></supportedlock><source /></prop><status>HTTP/1.1 200 OK</status></propstat></response></multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop /></D:propfind>");
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("creationdate", "resourcetype", "displayname", "getcontenttype", "getcontentlanguage", "getcontentlength", "getlastmodified", "getetag", "source", "lockdiscovery", "supportedlock");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testCollection() throws Exception {
        String PM_URL = this.testCollection + "/pm";
        String INDEX_HTML_URL = this.testCollection + "/index.html";
        String SITEMAP_HTML_URL = this.testCollection + "/sitemap.html";
        String GUI_URL = this.DEVELOPMENT_URL + "/gui";
        String INDEX3_HTML_URL = GUI_URL + "/index3.html";
        String SPECIAL_CHARACTERS_URL = this.testCollection + "/special%20characters%3F";
        String testCollDispName = this.factory.resolveResource(this.testCollection).getDisplayName();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:displayname/><D:resourcetype /></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.DEVELOPMENT_URL + "</D:href><D:propstat><D:prop><D:displayname>development</D:displayname><D:resourcetype><D:collection /></D:resourcetype></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.DEVELOPMENT_URL);
        req.setHeader("depth", "0");
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("displayname", "status");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:displayname/></D:prop></D:propfind>";
        expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost" + this.testCollection + "</D:href><D:propstat><D:prop><D:displayname>" + testCollDispName + "</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + this.DEVELOPMENT_URL + "</D:href><D:propstat><D:prop><D:displayname>development</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + PM_URL + "</D:href><D:propstat><D:prop><D:displayname>pm</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:displayname>index.html</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + SITEMAP_HTML_URL + "</D:href><D:propstat><D:prop><D:displayname>sitemap.html</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + SPECIAL_CHARACTERS_URL + "</D:href><D:propstat><D:prop><D:displayname>special characters?</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        res = new MockWebdavResponse();
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        req.setBodyAsString(body);
        req.setHeader("depth", "1");
        req.setUrl(this.testCollection);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.DEVELOPMENT_URL + "</D:href><D:propstat><D:prop><D:displayname>development</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + GUI_URL + "</D:href><D:propstat><D:prop><D:displayname>gui</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response><D:response><D:href>http://localhost/" + INDEX3_HTML_URL + "</D:href><D:propstat><D:prop><D:displayname>index3.html</D:displayname></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        res = new MockWebdavResponse();
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        req.setBodyAsString(body);
        req.setHeader("depth", "infinity");
        req.setUrl(this.DEVELOPMENT_URL);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testXMLProperty() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavProperty property = new WebdavProperty();
        property.setNamespace(TEST_NS.getURI());
        property.setName("test");
        property.setValue("<quark xmlns=\"http://www.open-xchange.com/namespace/webdav-test\"> In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!</quark>");
        property.setXML(true);
        resource.putProperty(property);
        resource.save();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:prop><OX:test/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><OX:test><OX:quark> In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!</OX:quark></OX:test></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("test", "quark", "status");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testMissingProperty() throws Exception {
        Date lastModified = this.factory.resolveResource(this.INDEX_HTML_URL).getLastModified();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/><D:displayname/><D:resourcetype/><testProp xmlns=\"" + TEST_NS.getURI() + "\"/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:getlastmodified>" + Utils.convert((Date)lastModified) + "</D:getlastmodified><D:displayname>index.html</D:displayname><D:resourcetype /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><testProp xmlns=\"" + TEST_NS.getURI() + "\"/></D:prop><D:status>HTTP/1.1 404 NOT FOUND</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("getlastmodified", "displayname", "resourcetype", "status", "testProp");
        PropfindTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testURLEncodedHREF() throws Exception {
        Date lastModified = this.factory.resolveResource(this.SPECIAL_URL).getLastModified();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost" + this.testCollection + "/special%20characters%3F/</D:href><D:propstat><D:prop><D:getlastmodified>" + Utils.convert((Date)lastModified) + "</D:getlastmodified></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>");
        req.setUrl(this.SPECIAL_URL);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("href");
        String response = res.getResponseBodyAsString();
        PropfindTest.assertTrue((boolean)compare.compare(expect, response));
    }

    public void testURLEncodedHREFWithSlash() throws Exception {
        WebdavPath problematicUrl = this.testCollection.dup().append(new String[]{"contains//slahes\\\\and backslashes"});
        this.factory.resolveCollection(problematicUrl).save();
        Date lastModified = this.factory.resolveResource(problematicUrl).getLastModified();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost" + this.testCollection + "/contains%2F%2Fslahes%5C%5Cand%20backslashes/</D:href><D:propstat><D:prop><D:getlastmodified>" + Utils.convert((Date)lastModified) + "</D:getlastmodified></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/></D:prop></D:propfind>");
        req.setUrl(problematicUrl);
        WebdavPropfindAction action = new WebdavPropfindAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PropfindTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("href");
        String response = res.getResponseBodyAsString();
        PropfindTest.assertTrue((boolean)compare.compare(expect, response));
    }
}

