/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import com.openexchange.webdav.action.ifheader.IfHeaderParser;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MockWebdavRequest
implements WebdavRequest {
    private WebdavPath url;
    private String uriPrefix = null;
    private final WebdavFactory factory;
    private String content;
    private final Map<String, String> headers = new HashMap<String, String>();
    private WebdavResource res = null;
    private WebdavResource dest;
    private final Map<String, Object> userInfo = new HashMap<String, Object>();

    public MockWebdavRequest(WebdavFactory factory, String prefix) {
        this.factory = factory;
        this.uriPrefix = prefix;
    }

    public void setUrl(WebdavPath url) {
        this.url = url;
    }

    public WebdavResource getResource() throws WebdavProtocolException {
        if (this.res != null) {
            return this.res;
        }
        this.res = this.factory.resolveResource(this.url);
        return this.res;
    }

    public WebdavResource getDestination() throws WebdavProtocolException {
        if (null == this.getHeader("destination")) {
            return null;
        }
        if (this.dest != null) {
            return this.dest;
        }
        this.dest = this.factory.resolveResource(this.getHeader("destination"));
        return this.dest;
    }

    public WebdavCollection getCollection() throws WebdavProtocolException {
        if (this.res != null) {
            return (WebdavCollection)this.res;
        }
        this.res = this.factory.resolveCollection(this.url);
        return this.res;
    }

    public WebdavPath getDestinationUrl() {
        return new WebdavPath((CharSequence)this.getHeader("destination"));
    }

    public WebdavPath getUrl() {
        return this.url;
    }

    public void setBodyAsString(String content) {
        this.content = content;
    }

    public InputStream getBody() {
        return new ByteArrayInputStream(this.content == null ? new byte[]{} : this.content.getBytes(Charsets.UTF_8));
    }

    public void setHeader(String header, String value) {
        this.headers.put(header.toLowerCase(), value);
    }

    public String getHeader(String header) {
        return this.headers.get(header.toLowerCase());
    }

    public List<String> getHeaderNames() {
        return new LinkedList<String>(this.headers.keySet());
    }

    public Document getBodyAsDocument() throws JDOMException, IOException {
        return new SAXBuilder().build(this.getBody());
    }

    public String getURLPrefix() {
        return this.uriPrefix;
    }

    public IfHeader getIfHeader() throws IfHeaderParseException {
        String ifHeader = this.getHeader("If");
        if (ifHeader == null) {
            return null;
        }
        return new IfHeaderParser().parse(this.getHeader("If"));
    }

    public int getDepth(int def) {
        String depth = this.getHeader("depth");
        if (null == depth) {
            return def;
        }
        return "Infinity".equalsIgnoreCase(depth) ? -1 : new Integer(depth);
    }

    public WebdavFactory getFactory() throws WebdavProtocolException {
        return this.factory;
    }

    public String getCharset() {
        return "UTF-8";
    }

    public boolean hasBody() {
        return this.content != null;
    }

    public Map<String, Object> getUserInfo() {
        return this.userInfo;
    }
}

