/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavHeadAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;

public class HeadTest
extends ActionTestCase {
    public void testBasic() throws Exception {
        WebdavPath INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(INDEX_HTML_URL);
        WebdavHeadAction action = new WebdavHeadAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        String content = this.getContent(INDEX_HTML_URL);
        HeadTest.assertEquals((String)"", (String)res.getResponseBodyAsString());
        HeadTest.assertEquals((int)content.getBytes(Charsets.UTF_8).length, (int)new Integer(res.getHeader("content-length")));
        HeadTest.assertEquals((String)"text/html", (String)res.getHeader("content-type"));
        HeadTest.assertEquals((String)"bytes", (String)res.getHeader("Accept-Ranges"));
    }
}

