/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.meterware.httpunit.Base64;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.test.WebdavInit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class TestUpload2
extends TestCase {
    private Properties webdavProps;
    private String login;
    private String password;
    private String hostname;
    private static final int PAKETS = 10;

    public TestUpload2(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.webdavProps = WebdavInit.getWebdavProperties();
        this.login = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"login", (String)"");
        this.password = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"password", (String)"");
        this.hostname = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"hostname", (String)"localhost");
    }

    public void testUpload() throws Throwable {
        HttpClient client = new HttpClient();
        String uri = "http://" + this.hostname + "/servlet/webdav.infostore/Marcus%20Klein/testfile";
        PutMethod put = new PutMethod(uri);
        put.setHttp11(true);
        put.setRequestHeader(new Header("Content-Type", "application/octet-stream"));
        byte[] bytes = new byte[10240];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 97;
        }
        put.setRequestBody((InputStream)new ByteArrayInputStream(bytes));
        put.setRequestContentLength(-1L);
        put.addRequestHeader(new Header("Authorization", "Basic " + Base64.encode((String)(this.login + ":" + this.password))));
        client.executeMethod((HttpMethod)put);
        TestUpload2.assertEquals((int)201, (int)put.getStatusCode());
    }
}

