/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XMLCompare {
    private static Map<String, Method> methods = new HashMap<String, Method>();
    private static boolean inited;
    private Set<String> checkTextNames = Collections.emptySet();

    public boolean compare(String expect, String got) throws UnsupportedEncodingException, JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document expectedDoc = builder.build((InputStream)new ByteArrayInputStream(expect.getBytes(Charsets.UTF_8)));
        Document gotDoc = builder.build((InputStream)new ByteArrayInputStream(got.getBytes(Charsets.UTF_8)));
        return this.compareDocuments(expectedDoc.getRootElement(), gotDoc.getRootElement());
    }

    public boolean compareDocuments(Element expectedDoc, Element gotDoc) {
        if (!expectedDoc.getName().equals(gotDoc.getName()) || !expectedDoc.getNamespace().equals((Object)gotDoc.getNamespace())) {
            return false;
        }
        String nodeName = expectedDoc.getName();
        Method m = this.findCompareMethod(nodeName);
        if (m != null) {
            try {
                return (Boolean)m.invoke((Object)this, expectedDoc, gotDoc);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.checkText(nodeName) && !expectedDoc.getText().equals(gotDoc.getText())) {
            return false;
        }
        return this.compareChildElems(expectedDoc, gotDoc);
    }

    protected boolean checkText(String nodeName) {
        return this.getCheckTextNames().contains(nodeName);
    }

    protected Set<String> getCheckTextNames() {
        return this.checkTextNames;
    }

    public void setCheckTextNames(String ... names) {
        this.checkTextNames = new HashSet<String>(Arrays.asList(names));
    }

    protected boolean compareChildElems(Element expectedDoc, Element gotDoc) {
        HashSet expectedNodes = new HashSet(expectedDoc.getChildren());
        HashSet gotNodes = new HashSet(gotDoc.getChildren());
        block0: for (Element expect : expectedNodes) {
            for (Element got : new HashSet(gotNodes)) {
                if (!this.compareDocuments(expect, got)) continue;
                gotNodes.remove(got);
                continue block0;
            }
            return false;
        }
        return gotNodes.isEmpty();
    }

    protected Method findCompareMethod(String nodeName) {
        this.initMethods();
        return methods.get(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMethods() {
        Map<String, Method> map = methods;
        synchronized (map) {
            if (inited) {
                return;
            }
            inited = true;
            for (Method method : this.getClass().getMethods()) {
                if (!method.isAccessible() || !method.getName().startsWith("compare")) continue;
                String name = method.getName().substring(8);
                methods.put(name, method);
            }
        }
    }
}

