/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug18981StructureTest
extends AbstractMailTest {
    private static final byte[] SOURCE = "Reply-To: <orderstatus_notification@barfoo.com>\nFrom: <orderstatus_notification@barfoo.com>\nTo: <foobar@dotcom.de>, \n    <>, \n    <>, \nCc: <>, \n    <blubber@barfoo.com>, \nSubject: Ihre Bestellung bei Foobar - Voraussichtliches Lieferdatum \nDate: Sat, 16 Apr 2011 06:16:43 +0100\nMessage-ID: 129474046034864895@E3BUSOPSDB\nMIME-Version: 1.0\nContent-Type: multipart/related;\n    boundary=\"----=_NextPart_000_0001_0ce908fe.cc7a5096\"\nX-Priority: 3 (Normal)\nX-MSMail-Priority: Normal\nX-Mailer: SuperMailer V1.0\nImportance: Normal\n\nThis is a multi-partmessage in MIME  format.\n\n------=_NextPart_000_0001_0ce908fe.cc7a5096\nContent-Type: multipart/alternative;\n    boundary=\"----=_NextPart_001_0002_0ce908fe.cc7a5096\"\n\n\n------=_NextPart_001_0002_0ce908fe.cc7a5096\nContent-Type: text/plain;\n    charset=\"ISO-8859-1\"\nContent-Transfer-Encoding: 7bit\n\nSome text\n\n\n------=_NextPart_001_0002_0ce908fe.cc7a5096\nContent-Type: text/html;\n    charset=\"ISO-8859-1\"\nContent-Transfer-Encoding: 7bit\n\n<html><body>Some text<br><br></body></html>\n\n------=_NextPart_001_0002_0ce908fe.cc7a5096--\n\n------=_NextPart_000_0001_0ce908fe.cc7a5096--".getBytes();

    public Bug18981StructureTest() {
    }

    public Bug18981StructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SOURCE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug18981StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            Bug18981StructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            Bug18981StructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray jsonBodyArray = (JSONArray)bodyObject;
            Bug18981StructureTest.assertTrue((String)("Unexpected array length: " + jsonBodyArray.length()), (jsonBodyArray.length() == 1 ? 1 : 0) != 0);
            JSONObject headers = jsonMailObject.getJSONObject("headers");
            Bug18981StructureTest.assertTrue((String)("Found more than one \"To\" header: " + headers.get("to")), (1 == headers.getJSONArray("to").length() ? 1 : 0) != 0);
            Bug18981StructureTest.assertTrue((String)("Found more than one \"Cc\" header: " + headers.get("cc")), (1 == headers.getJSONArray("cc").length() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug18981StructureTest.fail((String)e.getMessage());
        }
    }
}

