/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.folderstorage;

import com.openexchange.exception.OXException;
import com.openexchange.imap.dataobjects.IMAPMailFolder;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.Quota;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.io.IOException;
import java.util.HashSet;
import javax.mail.MessagingException;

public final class MailFolderTest
extends AbstractMailTest {
    private static final String SESSION_NAME = "mail-test-session";
    private static final String TEMPORARY_FOLDER = "TemporaryFolder";
    private static final String INBOX = "INBOX";
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};

    public MailFolderTest() {
    }

    public MailFolderTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStandardFolders() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                String fullname = mailAccess.getFolderStorage().getDraftsFolder();
                MailFolderTest.assertTrue((String)"Missing drafts folder", (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                fullname = mailAccess.getFolderStorage().getSentFolder();
                MailFolderTest.assertTrue((String)"Missing sent folder", (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                fullname = mailAccess.getFolderStorage().getSpamFolder();
                MailFolderTest.assertTrue((String)"Missing spam folder", (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                fullname = mailAccess.getFolderStorage().getTrashFolder();
                MailFolderTest.assertTrue((String)"Missing trash folder", (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                if (UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), this.getCid()).isSpamEnabled()) {
                    fullname = mailAccess.getFolderStorage().getConfirmedHamFolder();
                    MailFolderTest.assertTrue((String)("Missing confirmed ham folder: " + fullname), (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                    fullname = mailAccess.getFolderStorage().getConfirmedSpamFolder();
                    MailFolderTest.assertTrue((String)("Missing confirmed spam folder: " + fullname), (fullname != null && fullname.length() > 0 ? 1 : 0) != 0);
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailFolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExistStandardFolders() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                String fullname = mailAccess.getFolderStorage().getDraftsFolder();
                MailFolderTest.assertTrue((String)"Non-existing drafts folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                fullname = mailAccess.getFolderStorage().getSentFolder();
                MailFolderTest.assertTrue((String)"Non-existing sent folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                fullname = mailAccess.getFolderStorage().getSpamFolder();
                MailFolderTest.assertTrue((String)"Non-existing spam folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                fullname = mailAccess.getFolderStorage().getTrashFolder();
                MailFolderTest.assertTrue((String)"Non-existing trash folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                if (UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), this.getCid()).isSpamEnabled()) {
                    fullname = mailAccess.getFolderStorage().getConfirmedHamFolder();
                    MailFolderTest.assertTrue((String)"Non-existing confirmed ham folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                    fullname = mailAccess.getFolderStorage().getConfirmedSpamFolder();
                    MailFolderTest.assertTrue((String)"Non-existing confirmed spam folder", (boolean)mailAccess.getFolderStorage().exists(fullname));
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailFolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderGet() throws OXException {
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        try {
            MailFolder f = mailAccess.getFolderStorage().getFolder(INBOX);
            MailFolderTest.assertTrue((String)"Missing default folder flag", (boolean)f.containsDefaultFolder());
            MailFolderTest.assertTrue((String)"Missing deleted count", (boolean)f.containsDeletedMessageCount());
            MailFolderTest.assertTrue((String)"Missing exists flag", (boolean)f.containsExists());
            MailFolderTest.assertTrue((String)"Missing fullname", (boolean)f.containsFullname());
            MailFolderTest.assertTrue((String)"Missing holds folders flag", (boolean)f.containsHoldsFolders());
            MailFolderTest.assertTrue((String)"Missing holds messages flag", (boolean)f.containsHoldsMessages());
            MailFolderTest.assertTrue((String)"Missing message count", (boolean)f.containsMessageCount());
            MailFolderTest.assertTrue((String)"Missing name", (boolean)f.containsName());
            MailFolderTest.assertTrue((String)"Missing new message count", (boolean)f.containsNewMessageCount());
            if (f instanceof IMAPMailFolder) {
                MailFolderTest.assertTrue((String)"Missing non-existent flag", (boolean)((IMAPMailFolder)f).containsNonExistent());
            }
            MailFolderTest.assertTrue((String)"Missing own permission", (boolean)f.containsOwnPermission());
            MailFolderTest.assertTrue((String)"Missing parent fullname", (boolean)f.containsParentFullname());
            MailFolderTest.assertTrue((String)"Missing permissions", (boolean)f.containsPermissions());
            MailFolderTest.assertTrue((String)"Missing root folder flag", (boolean)f.containsRootFolder());
            MailFolderTest.assertTrue((String)"Missing separator flag", (boolean)f.containsSeparator());
            MailFolderTest.assertTrue((String)"Missing subfolder flag", (boolean)f.containsSubfolders());
            MailFolderTest.assertTrue((String)"Missing subscribed flag", (boolean)f.containsSubscribed());
            MailFolderTest.assertTrue((String)"Missing subscribed subfolders flag", (boolean)f.containsSubscribedSubfolders());
            MailFolderTest.assertTrue((String)"Missing supports user flags flag", (boolean)f.containsSupportsUserFlags());
            MailFolderTest.assertTrue((String)"Missing unread message count", (boolean)f.containsUnreadMessageCount());
        }
        finally {
            mailAccess.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderCreateAndSubfolders() throws OXException {
        MailAccess mailAccess;
        block10: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                MailFolder f = mailAccess.getFolderStorage().getFolder(INBOX);
                MailFolderTest.assertTrue((String)"Missing default folder flag", (boolean)f.containsDefaultFolder());
                MailFolderTest.assertTrue((String)"Missing deleted count", (boolean)f.containsDeletedMessageCount());
                MailFolderTest.assertTrue((String)"Missing exists flag", (boolean)f.containsExists());
                MailFolderTest.assertTrue((String)"Missing fullname", (boolean)f.containsFullname());
                MailFolderTest.assertTrue((String)"Missing holds folders flag", (boolean)f.containsHoldsFolders());
                MailFolderTest.assertTrue((String)"Missing holds messages flag", (boolean)f.containsHoldsMessages());
                MailFolderTest.assertTrue((String)"Missing message count", (boolean)f.containsMessageCount());
                MailFolderTest.assertTrue((String)"Missing name", (boolean)f.containsName());
                MailFolderTest.assertTrue((String)"Missing new message count", (boolean)f.containsNewMessageCount());
                if (f instanceof IMAPMailFolder) {
                    MailFolderTest.assertTrue((String)"Missing non-existent flag", (boolean)((IMAPMailFolder)f).containsNonExistent());
                }
                MailFolderTest.assertTrue((String)"Missing own permission", (boolean)f.containsOwnPermission());
                MailFolderTest.assertTrue((String)"Missing parent fullname", (boolean)f.containsParentFullname());
                MailFolderTest.assertTrue((String)"Missing permissions", (boolean)f.containsPermissions());
                MailFolderTest.assertTrue((String)"Missing root folder flag", (boolean)f.containsRootFolder());
                MailFolderTest.assertTrue((String)"Missing separator flag", (boolean)f.containsSeparator());
                MailFolderTest.assertTrue((String)"Missing subfolder flag", (boolean)f.containsSubfolders());
                MailFolderTest.assertTrue((String)"Missing subscribed flag", (boolean)f.containsSubscribed());
                MailFolderTest.assertTrue((String)"Missing subscribed subfolders flag", (boolean)f.containsSubscribedSubfolders());
                MailFolderTest.assertTrue((String)"Missing supports user flags flag", (boolean)f.containsSupportsUserFlags());
                MailFolderTest.assertTrue((String)"Missing unread message count", (boolean)f.containsUnreadMessageCount());
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                boolean found = false;
                MailFolder[] folders = mailAccess.getFolderStorage().getSubfolders(parentFullname, true);
                for (int i = 0; i < folders.length; ++i) {
                    MailFolder mf = folders[i];
                    MailFolderTest.assertTrue((String)"Missing default folder flag", (boolean)mf.containsDefaultFolder());
                    MailFolderTest.assertTrue((String)"Missing deleted count", (boolean)mf.containsDeletedMessageCount());
                    MailFolderTest.assertTrue((String)"Missing exists flag", (boolean)mf.containsExists());
                    MailFolderTest.assertTrue((String)"Missing fullname", (boolean)mf.containsFullname());
                    MailFolderTest.assertTrue((String)"Missing holds folders flag", (boolean)mf.containsHoldsFolders());
                    MailFolderTest.assertTrue((String)"Missing holds messages flag", (boolean)mf.containsHoldsMessages());
                    MailFolderTest.assertTrue((String)"Missing message count", (boolean)mf.containsMessageCount());
                    MailFolderTest.assertTrue((String)"Missing name", (boolean)mf.containsName());
                    MailFolderTest.assertTrue((String)"Missing new message count", (boolean)mf.containsNewMessageCount());
                    if (mf instanceof IMAPMailFolder) {
                        MailFolderTest.assertTrue((String)"Missing non-existent flag", (boolean)((IMAPMailFolder)mf).containsNonExistent());
                    }
                    MailFolderTest.assertTrue((String)"Missing own permission", (boolean)mf.containsOwnPermission());
                    MailFolderTest.assertTrue((String)"Missing parent fullname", (boolean)mf.containsParentFullname());
                    MailFolderTest.assertTrue((String)"Missing permissions", (boolean)mf.containsPermissions());
                    MailFolderTest.assertTrue((String)"Missing root folder flag", (boolean)mf.containsRootFolder());
                    MailFolderTest.assertTrue((String)"Missing separator flag", (boolean)mf.containsSeparator());
                    MailFolderTest.assertTrue((String)"Missing subfolder flag", (boolean)mf.containsSubfolders());
                    MailFolderTest.assertTrue((String)"Missing subscribed flag", (boolean)mf.containsSubscribed());
                    MailFolderTest.assertTrue((String)"Missing subscribed subfolders flag", (boolean)mf.containsSubscribedSubfolders());
                    MailFolderTest.assertTrue((String)"Missing supports user flags flag", (boolean)mf.containsSupportsUserFlags());
                    MailFolderTest.assertTrue((String)"Missing unread message count", (boolean)mf.containsUnreadMessageCount());
                    if (!fullname.equals(mf.getFullname())) continue;
                    found = true;
                    MailFolderTest.assertFalse((String)"Subscribed, but shouldn't be", (boolean)(MailProperties.getInstance().isSupportSubscription() ? mf.isSubscribed() : false));
                }
                MailFolderTest.assertTrue((String)"Newly created subfolder not found!", (boolean)found);
                if (MailProperties.getInstance().isSupportSubscription()) {
                    MailFolder mailFolder;
                    found = false;
                    MailFolder[] arr$ = folders = mailAccess.getFolderStorage().getSubfolders(parentFullname, false);
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; found |= fullname.equals(mailFolder.getFullname()), ++i$) {
                        mailFolder = arr$[i$];
                    }
                    MailFolderTest.assertFalse((String)"Unsubscribed subfolder listed as subscribed!", (boolean)found);
                }
                if (fullname == null) break block10;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderRoot() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                MailFolder f = mailAccess.getFolderStorage().getRootFolder();
                MailFolderTest.assertTrue((String)"Missing default folder flag", (boolean)f.containsDefaultFolder());
                MailFolderTest.assertTrue((String)"Missing deleted count", (boolean)f.containsDeletedMessageCount());
                MailFolderTest.assertTrue((String)"Missing exists flag", (boolean)f.containsExists());
                MailFolderTest.assertTrue((String)"Missing fullname", (boolean)f.containsFullname());
                MailFolderTest.assertTrue((String)"Missing holds folders flag", (boolean)f.containsHoldsFolders());
                MailFolderTest.assertTrue((String)"Missing holds messages flag", (boolean)f.containsHoldsMessages());
                MailFolderTest.assertTrue((String)"Missing message count", (boolean)f.containsMessageCount());
                MailFolderTest.assertTrue((String)"Missing name", (boolean)f.containsName());
                MailFolderTest.assertTrue((String)"Missing new message count", (boolean)f.containsNewMessageCount());
                if (f instanceof IMAPMailFolder) {
                    MailFolderTest.assertTrue((String)"Missing non-existent flag", (boolean)((IMAPMailFolder)f).containsNonExistent());
                }
                MailFolderTest.assertTrue((String)"Missing own permission", (boolean)f.containsOwnPermission());
                MailFolderTest.assertTrue((String)"Missing parent fullname", (boolean)f.containsParentFullname());
                MailFolderTest.assertTrue((String)"Missing permissions", (boolean)f.containsPermissions());
                MailFolderTest.assertTrue((String)"Missing root folder flag", (boolean)f.containsRootFolder());
                MailFolderTest.assertTrue((String)"Missing separator flag", (boolean)f.containsSeparator());
                MailFolderTest.assertTrue((String)"Missing subfolder flag", (boolean)f.containsSubfolders());
                MailFolderTest.assertTrue((String)"Missing subscribed flag", (boolean)f.containsSubscribed());
                MailFolderTest.assertTrue((String)"Missing subscribed subfolders flag", (boolean)f.containsSubscribedSubfolders());
                MailFolderTest.assertTrue((String)"Missing supports user flags flag", (boolean)f.containsSupportsUserFlags());
                MailFolderTest.assertTrue((String)"Missing unread message count", (boolean)f.containsUnreadMessageCount());
                MailFolderTest.assertTrue((String)"Unexpected root fullname", (boolean)"default".equals(f.getFullname()));
                MailFolderTest.assertTrue((String)"Unexpected root's parent fullname", (f.getParentFullname() == null ? 1 : 0) != 0);
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailFolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderUpdate() throws OXException {
        MailAccess mailAccess;
        block10: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                MailFolderDescription mfd;
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd2 = new MailFolderDescription();
                mfd2.setExists(false);
                mfd2.setParentFullname(parentFullname);
                mfd2.setSeparator(inbox.getSeparator());
                mfd2.setSubscribed(false);
                mfd2.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd2.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd2);
                if (MailProperties.getInstance().isSupportSubscription() && !MailProperties.getInstance().isIgnoreSubscription()) {
                    mfd = new MailFolderDescription();
                    mfd.setSubscribed(true);
                    mailAccess.getFolderStorage().updateFolder(fullname, mfd);
                    MailFolderTest.assertTrue((String)"Could not be subscribed", (boolean)mailAccess.getFolderStorage().getFolder(fullname).isSubscribed());
                }
                mfd = new MailFolderDescription();
                MailPermission p1 = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p1.setEntity(this.getUser());
                p1.setAllPermission(128, 128, 128, 128);
                p1.setFolderAdmin(true);
                p1.setGroupPermission(false);
                mfd.addPermission(p1);
                MailPermission p2 = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p2.setEntity(this.getSecondUser());
                p2.setAllPermission(2, 128, 0, 0);
                p2.setFolderAdmin(false);
                p2.setGroupPermission(false);
                mfd.addPermission(p2);
                MailFolderTest.assertTrue((String)"Hugh... No permissions?!", (boolean)mfd.containsPermissions());
                mailAccess.getFolderStorage().updateFolder(fullname, mfd);
                MailFolder updatedFolder = mailAccess.getFolderStorage().getFolder(fullname);
                MailPermission[] perms = updatedFolder.getPermissions();
                if (!mailAccess.getMailConfig().getCapabilities().hasPermissions()) {
                    MailFolderTest.assertTrue((String)("No default permission set!" + perms.length), (perms.length == 1 && DefaultMailPermission.class.isInstance(perms[0]) ? 1 : 0) != 0);
                } else {
                    MailFolderTest.assertTrue((String)("Unexpected number of permissions: " + perms.length), (perms.length == 2 ? 1 : 0) != 0);
                    for (MailPermission permission : perms) {
                        if (permission.getEntity() == this.getUser()) {
                            MailFolderTest.assertTrue((permission.getFolderPermission() >= 8 ? 1 : 0) != 0);
                            MailFolderTest.assertTrue((permission.getReadPermission() >= 4 ? 1 : 0) != 0);
                            MailFolderTest.assertTrue((permission.getWritePermission() >= 4 ? 1 : 0) != 0);
                            MailFolderTest.assertTrue((permission.getDeletePermission() >= 4 ? 1 : 0) != 0);
                            MailFolderTest.assertTrue((boolean)permission.isFolderAdmin());
                            continue;
                        }
                        if (permission.getEntity() != this.getSecondUser()) continue;
                        MailFolderTest.assertTrue((permission.getFolderPermission() == 2 ? 1 : 0) != 0);
                        MailFolderTest.assertTrue((permission.getReadPermission() >= 4 ? 1 : 0) != 0);
                        MailFolderTest.assertTrue((permission.getWritePermission() == 0 ? 1 : 0) != 0);
                        MailFolderTest.assertTrue((permission.getDeletePermission() == 0 ? 1 : 0) != 0);
                        MailFolderTest.assertFalse((boolean)permission.isFolderAdmin());
                    }
                }
                if (fullname == null) break block10;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderMove() throws OXException {
        MailAccess mailAccess;
        block13: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                boolean parentIsDefault;
                String parentFullname = null;
                char separator = '\u0000';
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                    parentIsDefault = false;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                    parentIsDefault = true;
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                separator = inbox.getSeparator();
                mfd.setSeparator(separator);
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                String newFullname = parentIsDefault ? "TemporaryFolderMoved" : parentFullname + separator + "TemporaryFolderMoved";
                mailAccess.getFolderStorage().moveFolder(fullname, newFullname);
                OXException exc = null;
                try {
                    mailAccess.getFolderStorage().getFolder(fullname);
                }
                catch (OXException e) {
                    exc = e;
                }
                MailFolderTest.assertTrue((String)"Moved folder still exists", (exc != null ? 1 : 0) != 0);
                fullname = newFullname;
                MailFolder mf = mailAccess.getFolderStorage().getFolder(fullname);
                MailFolderTest.assertEquals((String)("Unexpected name: " + mf.getName()), (String)"TemporaryFolderMoved", (String)mf.getName());
                MailFolderTest.assertEquals((String)("Unexpected parent: " + mf.getParentFullname()), (String)parentFullname, (String)mf.getParentFullname());
                MailFolder root = mailAccess.getFolderStorage().getRootFolder();
                MailPermission[] rootPerms = root.getPermissions();
                if (this.canCreateSubfolders((OCLPermission[])rootPerms)) {
                    newFullname = "TemporaryFolderMovedAgain";
                    exc = null;
                    try {
                        mailAccess.getFolderStorage().moveFolder(fullname, newFullname);
                    }
                    catch (OXException e) {
                        exc = e;
                    }
                    MailFolderTest.assertTrue((String)"Move below root folder failed", (exc == null ? 1 : 0) != 0);
                    exc = null;
                    try {
                        mailAccess.getFolderStorage().getFolder(fullname);
                    }
                    catch (OXException e) {
                        exc = e;
                    }
                    MailFolderTest.assertTrue((String)"Moved folder still exists", (exc != null ? 1 : 0) != 0);
                    fullname = newFullname;
                    mf = mailAccess.getFolderStorage().getFolder(fullname);
                    MailFolderTest.assertTrue((String)("Unexpected name: " + mf.getName()), (boolean)"TemporaryFolderMovedAgain".equals(mf.getName()));
                    MailFolderTest.assertTrue((String)("Unexpected parent: " + mf.getParentFullname()), (boolean)"default".equals(mf.getParentFullname()));
                } else {
                    fullname = null;
                }
                if (fullname == null) break block13;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    private boolean canCreateSubfolders(OCLPermission[] perms) {
        if (null == perms) {
            return false;
        }
        for (OCLPermission permission : perms) {
            if (permission.getEntity() != this.getUser()) continue;
            return permission.getFolderPermission() >= 8;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderRename() throws OXException {
        MailAccess mailAccess;
        block7: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                boolean isParentDefault;
                String parentFullname = null;
                char separator = '\u0000';
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                    isParentDefault = false;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                    isParentDefault = true;
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                separator = inbox.getSeparator();
                mfd.setSeparator(separator);
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                mailAccess.getFolderStorage().renameFolder(fullname, "TemporaryFolderRenamed");
                OXException exc = null;
                try {
                    mailAccess.getFolderStorage().getFolder(fullname);
                }
                catch (OXException e) {
                    exc = e;
                }
                MailFolderTest.assertTrue((String)"Renamed folder still exists", (exc != null ? 1 : 0) != 0);
                fullname = isParentDefault ? "TemporaryFolderRenamed" : parentFullname + separator + "TemporaryFolderRenamed";
                MailFolder mf = mailAccess.getFolderStorage().getFolder(fullname);
                MailFolderTest.assertEquals((String)("Unexpected name: " + mf.getName()), (String)"TemporaryFolderRenamed", (String)mf.getName());
                MailFolderTest.assertEquals((String)("Unexpected parent: " + mf.getParentFullname()), (String)parentFullname, (String)mf.getParentFullname());
                if (fullname == null) break block7;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderDelete() throws OXException {
        MailAccess mailAccess;
        block19: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                int numAppendix;
                String name = TEMPORARY_FOLDER;
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                int n = numAppendix = mailAccess.getFolderStorage().getFolder(mailAccess.getFolderStorage().getTrashFolder()).isHoldsFolders() ? 0 : -1;
                if (numAppendix == 0) {
                    MailFolder[] trashedFolders;
                    for (MailFolder mailFolder : trashedFolders = mailAccess.getFolderStorage().getSubfolders(mailAccess.getFolderStorage().getTrashFolder(), true)) {
                        String substr;
                        if (!mailFolder.getName().startsWith(TEMPORARY_FOLDER) || (substr = mailFolder.getName().substring(TEMPORARY_FOLDER.length())).length() <= 0) continue;
                        int tmp = numAppendix;
                        try {
                            numAppendix = Math.max(numAppendix, Integer.parseInt(substr));
                        }
                        catch (NumberFormatException e) {
                            numAppendix = tmp;
                        }
                    }
                    if (numAppendix > 0) {
                        ++numAppendix;
                    }
                }
                mailAccess.getFolderStorage().deleteFolder(fullname);
                OXException exc = null;
                try {
                    mailAccess.getFolderStorage().getFolder(fullname);
                }
                catch (OXException e) {
                    exc = e;
                }
                MailFolderTest.assertTrue((String)"Deleted folder still exists", (exc != null ? 1 : 0) != 0);
                if (numAppendix >= 0) {
                    boolean found = false;
                    MailFolder[] trashedFolders = mailAccess.getFolderStorage().getSubfolders(mailAccess.getFolderStorage().getTrashFolder(), true);
                    for (int i = 0; i < trashedFolders.length && !found; ++i) {
                        if (!trashedFolders[i].getName().startsWith(TEMPORARY_FOLDER)) continue;
                        if (numAppendix == 0) {
                            found = trashedFolders[i].getName().equals(TEMPORARY_FOLDER);
                        } else {
                            String substr = trashedFolders[i].getName().substring(TEMPORARY_FOLDER.length());
                            try {
                                found = numAppendix == Integer.parseInt(substr);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (!found) continue;
                        fullname = trashedFolders[i].getFullname();
                    }
                    if (!found) {
                        fullname = null;
                    }
                    MailFolderTest.assertTrue((String)"No backup folder found below trash folder", (boolean)found);
                }
                if (fullname == null) break block19;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderClear() throws OXException, MessagingException, IOException {
        String trashFullname;
        String[] trashedIDs;
        MailAccess mailAccess;
        block10: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            trashedIDs = null;
            trashFullname = null;
            try {
                int i;
                String parentFullname;
                String name = TEMPORARY_FOLDER;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailMessage[] mails = MailFolderTest.getMessages(this.getTestMailDir(), -1);
                String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, mails);
                MailFolderTest.assertTrue((String)("Messages not completely appended to mail folder " + fullname), (this.getMessageCount(mailAccess, fullname) == uids.length ? 1 : 0) != 0);
                trashFullname = mailAccess.getFolderStorage().getTrashFolder();
                int numTrashedMails = this.getMessageCount(mailAccess, trashFullname);
                HashSet<Long> ids = new HashSet<Long>(numTrashedMails);
                MailMessage[] trashed = mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_ID);
                for (int i2 = 0; i2 < trashed.length; ++i2) {
                    ids.add(Long.valueOf(trashed[i2].getMailId()));
                }
                mailAccess.getFolderStorage().clearFolder(fullname);
                MailFolderTest.assertTrue((String)"Folder should be empty", (this.getMessageCount(mailAccess, fullname) == 0 ? 1 : 0) != 0);
                int expectedMsgCount = numTrashedMails + uids.length;
                MailFolderTest.assertTrue((String)"Mails not completely backuped", (this.getMessageCount(mailAccess, trashFullname) == expectedMsgCount ? 1 : 0) != 0);
                HashSet<String> newIds = new HashSet<String>(expectedMsgCount);
                trashed = mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_ID);
                MailFolderTest.assertTrue((String)("Size mismatch: " + trashed.length + " but should be " + expectedMsgCount), (trashed.length == expectedMsgCount ? 1 : 0) != 0);
                for (i = 0; i < trashed.length; ++i) {
                    newIds.add(trashed[i].getMailId());
                }
                newIds.removeAll(ids);
                trashedIDs = new String[newIds.size()];
                i = 0;
                for (String id : newIds) {
                    trashedIDs[i++] = id;
                }
                mailAccess.getMessageStorage().deleteMessages(trashFullname, trashedIDs, true);
                trashedIDs = null;
                uids = mailAccess.getMessageStorage().appendMessages(fullname, mails);
                MailFolderTest.assertTrue((String)("Messages not completely appended to mail folder " + fullname), (this.getMessageCount(mailAccess, fullname) == uids.length ? 1 : 0) != 0);
                numTrashedMails = this.getMessageCount(mailAccess, trashFullname);
                mailAccess.getFolderStorage().clearFolder(fullname, true);
                MailFolderTest.assertTrue((String)"Folder should be empty", (this.getMessageCount(mailAccess, fullname) == 0 ? 1 : 0) != 0);
                MailFolderTest.assertTrue((String)"Mails not deleted permanently although hardDelete flag set to true", (this.getMessageCount(mailAccess, trashFullname) == numTrashedMails ? 1 : 0) != 0);
                if (fullname == null) break block10;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                if (trashedIDs != null) {
                    mailAccess.getMessageStorage().deleteMessages(trashFullname, trashedIDs, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        if (trashedIDs != null) {
            mailAccess.getMessageStorage().deleteMessages(trashFullname, trashedIDs, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderQuota() throws OXException, MessagingException, IOException {
        MailAccess mailAccess;
        block9: {
            long prevUsage;
            Quota.Type[] types;
            String fullname;
            block7: {
                block8: {
                    SessionObject session = this.getSession();
                    mailAccess = MailAccess.getInstance((Session)session);
                    mailAccess.connect();
                    MailCapabilities caps = mailAccess.getMailConfig().getCapabilities();
                    if (!caps.hasQuota()) {
                        return;
                    }
                    fullname = null;
                    try {
                        String parentFullname;
                        String name = TEMPORARY_FOLDER;
                        MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                        if (inbox.isHoldsFolders()) {
                            fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                            parentFullname = INBOX;
                        } else {
                            fullname = TEMPORARY_FOLDER;
                            parentFullname = "default";
                        }
                        MailFolderDescription mfd = new MailFolderDescription();
                        mfd.setExists(false);
                        mfd.setParentFullname(parentFullname);
                        mfd.setSeparator(inbox.getSeparator());
                        mfd.setSubscribed(false);
                        mfd.setName(TEMPORARY_FOLDER);
                        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                        p.setEntity(this.getUser());
                        p.setAllPermission(128, 128, 128, 128);
                        p.setFolderAdmin(true);
                        p.setGroupPermission(false);
                        mfd.addPermission(p);
                        mailAccess.getFolderStorage().createFolder(mfd);
                        types = new Quota.Type[]{Quota.Type.STORAGE};
                        prevUsage = mailAccess.getFolderStorage().getQuotas(fullname, types)[0].getUsage();
                        if (prevUsage != -1L) break block7;
                        if (fullname == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (fullname != null) {
                            mailAccess.getFolderStorage().deleteFolder(fullname, true);
                        }
                        mailAccess.close(false);
                        throw throwable;
                    }
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                return;
            }
            mailAccess.getMessageStorage().appendMessages(fullname, MailFolderTest.getMessages(this.getTestMailDir(), -1));
            MailFolderTest.assertTrue((String)"QUOTA not increased although mails were appended", (mailAccess.getFolderStorage().getQuotas(fullname, types)[0].getUsage() > prevUsage ? 1 : 0) != 0);
            if (fullname == null) break block9;
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPath2DefaultFolder() throws OXException {
        String fullname;
        MailAccess mailAccess;
        block13: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            fullname = null;
            String anotherFullname = null;
            try {
                boolean isParentDefault;
                String parentFullname;
                String name = TEMPORARY_FOLDER;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                    isParentDefault = false;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                    isParentDefault = true;
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailFolder[] path = mailAccess.getFolderStorage().getPath2DefaultFolder(fullname);
                MailFolderTest.assertEquals((String)("Unexpected path length: " + path.length), (int)(isParentDefault ? 1 : 2), (int)path.length);
                for (int i = 0; i < path.length; ++i) {
                    if (i == 0) {
                        MailFolderTest.assertTrue((String)"Unexpected mail folder in first path position", (boolean)path[i].getFullname().equals(fullname));
                        continue;
                    }
                    MailFolderTest.assertTrue((String)"Unexpected mail folder in second path position", (boolean)path[i].getFullname().equals(INBOX));
                }
                path = null;
                MailFolder temp = mailAccess.getFolderStorage().getFolder(fullname);
                if (temp.isHoldsFolders()) {
                    anotherFullname = temp.getFullname() + temp.getSeparator() + TEMPORARY_FOLDER;
                    String parentFullname2 = temp.getFullname();
                    MailFolderDescription mfd2 = new MailFolderDescription();
                    mfd2.setExists(false);
                    mfd2.setParentFullname(parentFullname2);
                    mfd2.setSeparator(temp.getSeparator());
                    mfd2.setSubscribed(false);
                    mfd2.setName(TEMPORARY_FOLDER);
                    MailPermission p2 = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                    p2.setEntity(this.getUser());
                    p2.setAllPermission(128, 128, 128, 128);
                    p2.setFolderAdmin(true);
                    p2.setGroupPermission(false);
                    mfd2.addPermission(p2);
                    mailAccess.getFolderStorage().createFolder(mfd2);
                    MailFolder[] apath = mailAccess.getFolderStorage().getPath2DefaultFolder(anotherFullname);
                    MailFolderTest.assertTrue((String)("Unexpected path length: " + apath.length), (apath.length == (isParentDefault ? 2 : 3) ? 1 : 0) != 0);
                    for (int i = 0; i < apath.length; ++i) {
                        if (i == 0) {
                            MailFolderTest.assertTrue((String)"Unexpected mail folder in first path position", (boolean)apath[i].getFullname().equals(anotherFullname));
                            continue;
                        }
                        if (i == 1) {
                            MailFolderTest.assertTrue((String)"Unexpected mail folder in first path position", (boolean)apath[i].getFullname().equals(fullname));
                            continue;
                        }
                        MailFolderTest.assertTrue((String)"Unexpected mail folder in second path position", (boolean)apath[i].getFullname().equals(INBOX));
                    }
                }
                if (anotherFullname == null) break block13;
            }
            catch (Throwable throwable) {
                if (anotherFullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(anotherFullname, true);
                }
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(anotherFullname, true);
        }
        if (fullname != null) {
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }
}

