/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.webdav.FolderCollection;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderTools;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;

public class FolderCollectionPermissionHandlingTest
extends TestCase {
    private static int count = 0;
    private Context ctx;
    private int userIdA;
    private int userIdB;
    private User userA;
    private User userB;
    private UserConfiguration userConfigA;
    private UserConfiguration userConfigB;
    private SessionObject session;
    private SessionObject sessionB;
    private FolderObject privateInfostoreFolder;
    private final List<FolderObject> folders = new ArrayList<FolderObject>();
    private final List<FolderObject> foldersB = new ArrayList<FolderObject>();
    private OXFolderManager manager = null;
    private OXFolderManager managerB = null;
    private WebdavFactory factory;

    private static String getUsername(String un) {
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Init.startServer();
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        String userNameA = AjaxInit.getAJAXProperty("login");
        String userNameB = AjaxInit.getAJAXProperty("seconduser");
        this.userIdA = UserStorage.getInstance().getUserId(FolderCollectionPermissionHandlingTest.getUsername(userNameA), this.ctx);
        this.userIdB = UserStorage.getInstance().getUserId(FolderCollectionPermissionHandlingTest.getUsername(userNameB), this.ctx);
        this.userA = UserStorage.getInstance().getUser(this.userIdA, this.ctx);
        this.userB = UserStorage.getInstance().getUser(this.userIdB, this.ctx);
        this.userConfigA = RdbUserConfigurationStorage.loadUserConfiguration((int)this.userIdA, (Context)this.ctx);
        this.userConfigB = RdbUserConfigurationStorage.loadUserConfiguration((int)this.userIdB, (Context)this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.userIdA, (Context)this.ctx, (String)"blupp");
        this.sessionB = SessionObjectWrapper.createSessionObject((int)this.userIdB, (Context)this.ctx, (String)"blupp");
        this.manager = OXFolderManager.getInstance((Session)this.session);
        this.managerB = OXFolderManager.getInstance((Session)this.sessionB);
        this.folders.clear();
        this.foldersB.clear();
        SearchIterator iter = OXFolderTools.getAllVisibleFoldersIteratorOfModule((int)this.userIdA, (int[])this.userA.getGroups(), (int[])this.userConfigA.getAccessibleModules(), (int)8, (Context)this.ctx);
        try {
            while (this.privateInfostoreFolder == null && iter.hasNext()) {
                FolderObject f = (FolderObject)iter.next();
                List perms = f.getPermissions();
                for (OCLPermission perm : perms) {
                    if (perm.getFolderPermission() < 128 || perm.getEntity() != this.userIdA) continue;
                    this.privateInfostoreFolder = f;
                }
            }
        }
        finally {
            iter.close();
        }
        TestWebdavFactoryBuilder.setUp();
        this.factory = TestWebdavFactoryBuilder.buildFactory();
        this.factory.beginRequest();
        FolderCollectionPermissionHandlingTest.assertTrue((String)"Can't find suitable infostore folder", (null != this.privateInfostoreFolder ? 1 : 0) != 0);
    }

    public void tearDown() throws Exception {
        Collections.reverse(this.folders);
        for (FolderObject fo : this.folders) {
            this.manager.deleteFolder(fo, true, System.currentTimeMillis());
        }
        Collections.reverse(this.foldersB);
        for (FolderObject fo : this.foldersB) {
            this.managerB.deleteFolder(fo, true, System.currentTimeMillis());
        }
        this.factory.endRequest(200);
        TestWebdavFactoryBuilder.tearDown();
        Init.stopServer();
    }

    public void testCreate() throws Exception {
        FolderObject folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin = new FolderObject();
        this.addDefaults(folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin);
        folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin.setFolderName("User B May Read All and User A may read all and is Admin");
        OCLPermission perm1 = this.buildReadAll(this.userIdA, true);
        OCLPermission perm2 = this.buildReadAll(this.userIdB, false);
        folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        this.manager.createFolder(folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin, true, System.currentTimeMillis());
        this.folders.add(folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin);
        String url = this.url(this.privateInfostoreFolder, folderWithUserBMayReadAllAndUserAMayReadAllAndAdmin) + "/subfolder";
        this.factory.resolveCollection(url).create();
        FolderCollection coll = (FolderCollection)this.factory.resolveCollection(url);
        FolderObject newFolder = FolderObject.loadFolderObjectFromDB((int)coll.getId(), (Context)this.ctx);
        this.folders.add(newFolder);
        FolderCollectionPermissionHandlingTest.assertPermissions(newFolder.getPermissions(), perm1, perm2);
    }

    public void testAddAdminOnCreate() throws Exception {
        FolderObject folderWithUserBMayReadAllAndAdminAndUserAMayReadAll = new FolderObject();
        this.addDefaults(folderWithUserBMayReadAllAndAdminAndUserAMayReadAll);
        folderWithUserBMayReadAllAndAdminAndUserAMayReadAll.setFolderName("User B May Read All and is Admin and User A may read all " + System.currentTimeMillis());
        OCLPermission perm1 = this.buildReadAll(this.userIdA, false);
        perm1.setFolderPermission(8);
        OCLPermission perm2 = this.buildReadAll(this.userIdB, true);
        folderWithUserBMayReadAllAndAdminAndUserAMayReadAll.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        this.manager.createFolder(folderWithUserBMayReadAllAndAdminAndUserAMayReadAll, true, System.currentTimeMillis());
        this.foldersB.add(folderWithUserBMayReadAllAndAdminAndUserAMayReadAll);
        String url = this.url(this.privateInfostoreFolder, folderWithUserBMayReadAllAndAdminAndUserAMayReadAll) + "/subfolder";
        this.factory.resolveCollection(url).create();
        FolderCollection coll = (FolderCollection)this.factory.resolveCollection(url);
        FolderObject newFolder = FolderObject.loadFolderObjectFromDB((int)coll.getId(), (Context)this.ctx);
        this.folders.add(newFolder);
        FolderCollectionPermissionHandlingTest.assertPermissions(newFolder.getPermissions(), this.buildReadAll(this.userIdA, true), perm2);
    }

    public void testAddAdminOnCreateAndDontInheritFromSystemFolders() throws Exception {
        FolderObject publicInfostore = FolderObject.loadFolderObjectFromDB((int)15, (Context)this.ctx);
        String url = "/" + publicInfostore.getFolderName() + "/subfolder";
        this.factory.resolveCollection(url).create();
        FolderCollection coll = (FolderCollection)this.factory.resolveCollection(url);
        FolderObject newFolder = FolderObject.loadFolderObjectFromDB((int)coll.getId(), (Context)this.ctx);
        this.folders.add(newFolder);
        FolderCollectionPermissionHandlingTest.assertPermissions(newFolder.getPermissions(), this.buildReadAll(this.userIdA, true));
    }

    public void testCopy() throws Exception {
        FolderObject copyMe = this.buildFolderToCopy();
        OCLPermission[] perms = this.buildFolderToCopyPermissions();
        this.manager.createFolder(copyMe, true, System.currentTimeMillis());
        this.folders.add(copyMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, copyMe);
        WebdavPath copyUrl = new WebdavPath(new String[]{"userstore", this.privateInfostoreFolder.getFolderName()}).append(new String[]{"copy"});
        this.factory.resolveCollection(url).copy(copyUrl);
        FolderCollection theCopy = (FolderCollection)this.factory.resolveCollection(copyUrl);
        FolderObject theCopiedFolder = FolderObject.loadFolderObjectFromDB((int)theCopy.getId(), (Context)this.ctx);
        this.folders.add(theCopiedFolder);
        FolderCollectionPermissionHandlingTest.assertPermissions(theCopiedFolder.getPermissions(), perms);
    }

    public void testMove() throws Exception {
        FolderObject moveMe = this.buildFolderToCopy();
        OCLPermission[] perms = this.buildFolderToCopyPermissions();
        this.manager.createFolder(moveMe, true, System.currentTimeMillis());
        this.folders.add(moveMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, moveMe);
        WebdavPath moveUrl = new WebdavPath(new String[]{"userstore", this.privateInfostoreFolder.getFolderName()}).append(new String[]{"moved"});
        this.factory.resolveCollection(url).move(moveUrl);
        FolderCollection theDestination = (FolderCollection)this.factory.resolveCollection(moveUrl);
        FolderObject theDestinationFolder = FolderObject.loadFolderObjectFromDB((int)theDestination.getId(), (Context)this.ctx);
        this.folders.remove(moveMe);
        this.folders.add(theDestinationFolder);
        FolderCollectionPermissionHandlingTest.assertPermissions(theDestinationFolder.getPermissions(), perms);
    }

    public void testCopyWithOverwrite() throws Exception {
        FolderObject copyMe = this.buildFolderToCopy();
        OCLPermission[] perms = this.buildFolderToCopyPermissions();
        this.manager.createFolder(copyMe, true, System.currentTimeMillis());
        this.folders.add(copyMe);
        FolderObject overwriteMe = this.buildFolderToOverwrite();
        this.manager.createFolder(overwriteMe, true, System.currentTimeMillis());
        this.folders.add(overwriteMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, copyMe);
        WebdavPath copyUrl = this.url(this.privateInfostoreFolder, overwriteMe);
        this.factory.resolveCollection(url).copy(copyUrl, false, true);
        FolderCollection theCopy = (FolderCollection)this.factory.resolveCollection(copyUrl);
        FolderObject theCopiedFolder = FolderObject.loadFolderObjectFromDB((int)theCopy.getId(), (Context)this.ctx);
        FolderCollectionPermissionHandlingTest.assertPermissions(theCopiedFolder.getPermissions(), perms);
    }

    public void testMoveWithOverwrite() throws Exception {
        FolderObject moveMe = this.buildFolderToCopy();
        OCLPermission[] perms = this.buildFolderToCopyPermissions();
        this.manager.createFolder(moveMe, true, System.currentTimeMillis());
        this.folders.add(moveMe);
        FolderObject overwriteMe = this.buildFolderToOverwrite();
        this.manager.createFolder(overwriteMe, true, System.currentTimeMillis());
        this.folders.add(overwriteMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, moveMe);
        WebdavPath moveUrl = this.url(this.privateInfostoreFolder, overwriteMe);
        this.factory.resolveCollection(url).move(moveUrl, false, true);
        FolderCollection theDestination = (FolderCollection)this.factory.resolveCollection(moveUrl);
        this.folders.remove(moveMe);
        FolderObject theDestinationFolder = FolderObject.loadFolderObjectFromDB((int)theDestination.getId(), (Context)this.ctx);
        FolderCollectionPermissionHandlingTest.assertPermissions(theDestinationFolder.getPermissions(), perms);
    }

    public void testCopyWithoutOverwrite() throws Exception {
        FolderObject copyMe = this.buildFolderToCopy();
        this.manager.createFolder(copyMe, true, System.currentTimeMillis());
        this.folders.add(copyMe);
        FolderObject overwriteMe = this.buildFolderToOverwrite();
        this.manager.createFolder(overwriteMe, true, System.currentTimeMillis());
        this.folders.add(overwriteMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, copyMe);
        WebdavPath copyUrl = this.url(this.privateInfostoreFolder, overwriteMe);
        this.factory.resolveCollection(url).copy(copyUrl, false, false);
        FolderCollection theCopy = (FolderCollection)this.factory.resolveCollection(copyUrl);
        FolderObject theCopiedFolder = FolderObject.loadFolderObjectFromDB((int)theCopy.getId(), (Context)this.ctx);
        FolderCollectionPermissionHandlingTest.assertPermissions(theCopiedFolder.getPermissions(), this.buildFolderToOverwritePermissions());
    }

    public void testMoveWithoutOverwrite() throws Exception {
        FolderObject moveMe = this.buildFolderToCopy();
        this.manager.createFolder(moveMe, true, System.currentTimeMillis());
        this.folders.add(moveMe);
        FolderObject overwriteMe = this.buildFolderToOverwrite();
        this.manager.createFolder(overwriteMe, true, System.currentTimeMillis());
        this.folders.add(overwriteMe);
        WebdavPath url = this.url(this.privateInfostoreFolder, moveMe);
        WebdavPath moveUrl = this.url(this.privateInfostoreFolder, overwriteMe);
        this.factory.resolveCollection(url).move(moveUrl, false, false);
        FolderCollection theDestination = (FolderCollection)this.factory.resolveCollection(moveUrl);
        this.folders.remove(moveMe);
        FolderObject theDestinationFolder = FolderObject.loadFolderObjectFromDB((int)theDestination.getId(), (Context)this.ctx);
        FolderCollectionPermissionHandlingTest.assertPermissions(theDestinationFolder.getPermissions(), this.buildFolderToOverwritePermissions());
    }

    private void addDefaults(FolderObject folder) {
        folder.setType(2);
        folder.setModule(8);
        folder.setParentFolderID(this.privateInfostoreFolder.getObjectID());
    }

    private OCLPermission buildReadAll(int userId, boolean admin) {
        OCLPermission perm = new OCLPermission();
        perm.setFolderAdmin(admin);
        if (admin) {
            perm.setFolderPermission(128);
        } else {
            perm.setFolderPermission(8);
        }
        perm.setReadObjectPermission(4);
        perm.setWriteObjectPermission(4);
        perm.setDeleteObjectPermission(4);
        perm.setGroupPermission(false);
        perm.setEntity(userId);
        return perm;
    }

    private OCLPermission buildReadOwn(int userId, boolean admin) {
        OCLPermission perm = new OCLPermission();
        perm.setFolderAdmin(admin);
        if (admin) {
            perm.setFolderPermission(128);
        } else {
            perm.setFolderPermission(8);
        }
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(2);
        perm.setWriteObjectPermission(2);
        perm.setDeleteObjectPermission(2);
        perm.setGroupPermission(false);
        perm.setEntity(userId);
        return perm;
    }

    private WebdavPath url(FolderObject ... folders) {
        WebdavPath path = new WebdavPath((CharSequence)"userstore");
        for (FolderObject fo : folders) {
            path.append(new String[]{fo.getFolderName()});
        }
        return path;
    }

    private OCLPermission[] buildFolderToCopyPermissions() {
        OCLPermission perm1 = this.buildReadAll(this.userIdA, true);
        OCLPermission perm2 = this.buildReadOwn(this.userIdB, false);
        return new OCLPermission[]{perm1, perm2};
    }

    private FolderObject buildFolderToCopy() {
        FolderObject folderToCopy = new FolderObject();
        this.addDefaults(folderToCopy);
        folderToCopy.setFolderName("CopyMe" + count++);
        folderToCopy.setPermissionsAsArray(this.buildFolderToCopyPermissions());
        return folderToCopy;
    }

    private OCLPermission[] buildFolderToOverwritePermissions() {
        OCLPermission perm1 = this.buildReadAll(this.userIdA, true);
        OCLPermission perm2 = this.buildReadAll(this.userIdB, false);
        return new OCLPermission[]{perm1, perm2};
    }

    private FolderObject buildFolderToOverwrite() {
        FolderObject folderToOverwrite = new FolderObject();
        this.addDefaults(folderToOverwrite);
        folderToOverwrite.setFolderName("OverwriteMe");
        folderToOverwrite.setPermissionsAsArray(this.buildFolderToOverwritePermissions());
        return folderToOverwrite;
    }

    public static void assertPermissions(Collection<OCLPermission> perms, OCLPermission ... expected) {
        HashSet<OCLPermission> expectSet = new HashSet<OCLPermission>(Arrays.asList(expected));
        for (OCLPermission perm : perms) {
            OCLPermission matches = null;
            for (OCLPermission permExpect : expectSet) {
                if (permExpect.getReadPermission() != perm.getReadPermission() || permExpect.getWritePermission() != perm.getWritePermission() || permExpect.getDeletePermission() != perm.getDeletePermission() || permExpect.getFolderPermission() != perm.getFolderPermission() || permExpect.getEntity() != perm.getEntity()) continue;
                matches = permExpect;
            }
            FolderCollectionPermissionHandlingTest.assertNotNull((String)("Permission not expected on folder " + FolderCollectionPermissionHandlingTest.stringify(perm)), matches);
            FolderCollectionPermissionHandlingTest.assertTrue((boolean)expectSet.remove(matches));
        }
        FolderCollectionPermissionHandlingTest.assertTrue((boolean)expectSet.isEmpty());
    }

    private static String stringify(OCLPermission perm) {
        StringBuilder b = new StringBuilder();
        b.append("Read: ").append(perm.getReadPermission()).append(" Write: ").append(perm.getWritePermission()).append(" Delete: ").append(perm.getDeletePermission()).append(" Folder: ").append(perm.getFolderPermission()).append(" Entity: ").append(perm.getEntity());
        return b.toString();
    }
}

