/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.groupware.infostore.AbstractInfostoreActionTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.UpdateDocumentAction;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.tx.UndoableAction;

public class UpdateDocumentActionTest
extends AbstractInfostoreActionTest {
    CreateDocumentAction create = new CreateDocumentAction();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.create.setProvider(this.getProvider());
        this.create.setContext(this.getContext());
        this.create.setDocuments(this.getDocuments());
        this.create.setQueryCatalog(this.getQueryCatalog());
        this.create.perform();
    }

    @Override
    public void tearDown() throws Exception {
        this.create.undo();
        super.tearDown();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        UpdateDocumentAction update = new UpdateDocumentAction();
        update.setProvider(this.getProvider());
        update.setContext(this.getContext());
        update.setDocuments(this.getUpdatedDocuments());
        update.setOldDocuments(this.getDocuments());
        update.setQueryCatalog(this.getQueryCatalog());
        update.setModified(new Metadata[]{Metadata.COLOR_LABEL_LITERAL, Metadata.FILENAME_LITERAL});
        update.setTimestamp(Long.MAX_VALUE);
        return update;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        for (DocumentMetadata doc : this.getUpdatedDocuments()) {
            this.assertResult("SELECT 1 FROM infostore WHERE color_label = ? and cid = ? and id = ?", doc.getColorLabel(), this.getContext().getContextId(), doc.getId());
        }
    }

    @Override
    protected void verifyUndone() throws Exception {
        for (DocumentMetadata doc : this.getDocuments()) {
            this.assertResult("SELECT 1 FROM infostore WHERE color_label = ? and cid = ? and id = ?", doc.getColorLabel(), this.getContext().getContextId(), doc.getId());
        }
    }
}

