/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport.importers;

import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.contact.helpers.ContactSwitcher;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.Expectations;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.importexport.csv.CSVParser;
import com.openexchange.groupware.importexport.importers.MockCalendarCollectionService;
import com.openexchange.importexport.importers.OutlookCSVContactImporter;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.List;
import junit.framework.TestCase;

public class CsvDoesDifferentLanguages
extends TestCase {
    private final String dutch = "Voornaam,Achternaam,Weergavenaam,Bijnaam,Eerste e-mail,Tweede e-mail,Telefoon werk,Telefoon thuis,Faxnummer,Piepernummer,Mobiel nummer,Adres,Adres 2,Woonplaats,Provincie,Postcode,Land,Werkadres,Werkadres 2,Werkplaats,Werkprovincie,Werkpostcode,Werkland,Werktitel,Afdeling,Organisatie,Webpagina 1,Webpagina 2,Geboortejaar,Geboortemaand,Geboortedag,Overig 1,Overig 2,Overig 3,Overig 4,Aantekeningen,\nVorname1,Nachname1,,,email1@open-xchange.com,email2@open-xchange.com,phone_work1,phone_home1,fax,beeper,mobile,home_street1,home_street2,home_city,home_state,555,home_country,business_street1,business_street2,business_city,business_state,666,business_country,job_title,department,company,website1,website2,1981,2,1,add1,add2,add3,add4,notes,\n";
    private CalendarCollectionService oldInstance;

    private void assertBasicFields(String message, Contact c) {
        Expectations expectations = new Expectations();
        expectations.put(501, (Object)"Vorname1");
        expectations.put(502, (Object)"Nachname1");
        expectations.put(555, (Object)"email1@open-xchange.com");
        expectations.put(556, (Object)"email2@open-xchange.com");
        expectations.put(542, (Object)"phone_work1");
        expectations.put(548, (Object)"phone_home1");
        expectations.put(506, (Object)"home_street1");
        expectations.put(508, (Object)"home_city");
        expectations.put(509, (Object)"home_state");
        expectations.put(510, (Object)"home_country");
        expectations.put(507, (Object)"555");
        expectations.put(569, (Object)"company");
        expectations.put(519, (Object)"department");
        expectations.put(523, (Object)"business_street1");
        expectations.put(526, (Object)"business_city");
        expectations.put(527, (Object)"business_state");
        expectations.put(528, (Object)"business_country");
        expectations.put(525, (Object)"666");
        expectations.put(558, (Object)"website1");
        expectations.put(518, (Object)"notes");
        expectations.verify(message, (CommonObject)c);
    }

    public void testBug15231WithDutch() throws Throwable {
        Contact c = this.makeContact("Voornaam,Achternaam,Weergavenaam,Bijnaam,Eerste e-mail,Tweede e-mail,Telefoon werk,Telefoon thuis,Faxnummer,Piepernummer,Mobiel nummer,Adres,Adres 2,Woonplaats,Provincie,Postcode,Land,Werkadres,Werkadres 2,Werkplaats,Werkprovincie,Werkpostcode,Werkland,Werktitel,Afdeling,Organisatie,Webpagina 1,Webpagina 2,Geboortejaar,Geboortemaand,Geboortedag,Overig 1,Overig 2,Overig 3,Overig 4,Aantekeningen,\nVorname1,Nachname1,,,email1@open-xchange.com,email2@open-xchange.com,phone_work1,phone_home1,fax,beeper,mobile,home_street1,home_street2,home_city,home_state,555,home_country,business_street1,business_street2,business_city,business_state,666,business_country,job_title,department,company,website1,website2,1981,2,1,add1,add2,add3,add4,notes,\n");
        this.assertBasicFields("Dutch", c);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Class<CalendarCollectionService> myClass = CalendarCollectionService.class;
        this.oldInstance = (CalendarCollectionService)ServerServiceRegistry.getInstance().getService(myClass);
        ServerServiceRegistry.getInstance().addService(myClass, (Object)new MockCalendarCollectionService());
    }

    protected void tearDown() throws Exception {
        if (this.oldInstance != null) {
            ServerServiceRegistry.getInstance().addService(CalendarCollectionService.class, (Object)this.oldInstance);
        }
        super.tearDown();
    }

    private Contact makeContact(String csv) throws Throwable {
        CSVParser parser = new CSVParser();
        List list = parser.parse(csv);
        CsvDoesDifferentLanguages.assertEquals((String)"Should have one header + one one data row", (int)2, (int)list.size());
        List header = (List)list.get(0);
        List data = (List)list.get(1);
        OutlookCSVContactImporter importer = new OutlookCSVContactImporter();
        boolean[] atLeastOneFieldInserted = new boolean[]{false};
        ContactSwitcher conSet = importer.getContactSwitcher();
        ImportResult result = new ImportResult();
        CsvDoesDifferentLanguages.assertTrue((String)"The importer should consider itself", (boolean)importer.checkFields(header));
        return importer.convertCsvToContact(header, data, conSet, 1, result, atLeastOneFieldInserted);
    }
}

