/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.AbstractVCardTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class VCardImportTest
extends AbstractVCardTest {
    public static Test suite() {
        return new JUnit4TestAdapter(VCardImportTest.class);
    }

    @org.junit.Test
    public void test6825_tooMuchInformation() throws OXException, NumberFormatException, OXException, UnsupportedEncodingException, OXException, OXException {
        folderId = VCardImportTest.createTestFolder(3, sessObj, ctx, "vcard6825Folder");
        String stringTooLong = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999";
        String expected = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmm";
        String vcard = "BEGIN:VCARD\nVERSION:3.0\n\nN:aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999;givenName;;;\nEND:VCARD\n";
        List<String> folders = Arrays.asList(Integer.toString(folderId));
        List results = this.imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCARD\nVERSION:3.0\n\nN:aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999;givenName;;;\nEND:VCARD\n".getBytes(Charsets.UTF_8)), folders, null);
        Assert.assertTrue((String)"One import?", (1 == results.size() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should have no error", (boolean)((ImportResult)results.get(0)).hasError());
        ImportResult res = (ImportResult)results.get(0);
        RdbContactSQLImpl contacts = new RdbContactSQLImpl((Session)sessObj);
        Contact co = contacts.getObjectById(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()));
        Assert.assertEquals((String)"Should have truncated name", (Object)"aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmm", (Object)co.getSurName());
    }

    @org.junit.Test
    public void test7719() throws OXException, NumberFormatException, OXException, UnsupportedEncodingException, OXException, OXException {
        folderId = VCardImportTest.createTestFolder(3, sessObj, ctx, "vcard7719Folder");
        String telex = "7787987897897897897";
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nN:Schmitz;Hansi;;Dr.;\nFN:Dr. Hansi Schmitz\nEMAIL;PREF;INTERNET;CHARSET=Windows-1252:Hansi@Schmitz.super\nEMAIL;TLX:7787987897897897897\nEND:VCARD";
        List<String> folders = Arrays.asList(Integer.toString(folderId));
        List results = this.imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nN:Schmitz;Hansi;;Dr.;\nFN:Dr. Hansi Schmitz\nEMAIL;PREF;INTERNET;CHARSET=Windows-1252:Hansi@Schmitz.super\nEMAIL;TLX:7787987897897897897\nEND:VCARD".getBytes(Charsets.UTF_8)), folders, null);
        Assert.assertTrue((String)"One import?", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = (ImportResult)results.get(0);
        Assert.assertEquals((String)"Should have no error", null, (Object)((Object)res.getException()));
        RdbContactSQLImpl contacts = new RdbContactSQLImpl((Session)sessObj);
        Contact co = contacts.getObjectById(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()));
        Assert.assertEquals((String)"Has telex", (Object)"7787987897897897897", (Object)co.getTelephoneTelex());
    }

    @org.junit.Test
    public void testEmpty() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException, OXException {
        folderId = VCardImportTest.createTestFolder(3, sessObj, ctx, "vcard7719Folder");
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nN:;;;;\nEND:VCARD\n";
        List<String> folders = Arrays.asList(Integer.toString(folderId));
        List results = this.imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nN:;;;;\nEND:VCARD\n".getBytes(Charsets.UTF_8)), folders, null);
        Assert.assertTrue((String)"One import?", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = (ImportResult)results.get(0);
        Assert.assertEquals((String)"Should have no error", null, (Object)((Object)res.getException()));
        RdbContactSQLImpl contacts = new RdbContactSQLImpl((Session)sessObj);
        contacts.getObjectById(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()));
    }
}

