/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.ajax.writer.ImportExportWriter;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportExportWriterTest
extends TestCase {
    public void testWriteObject() throws JSONException {
        ImportExportWriter writer = new ImportExportWriter(null);
        ImportResult result = new ImportResult("1", "3", new Date());
        writer.writeObject(result);
        JSONObject temp = (JSONObject)writer.getObject();
        ImportExportWriterTest.assertEquals((String)"ID is incorrect", (Object)"1", (Object)temp.get("id"));
        ImportExportWriterTest.assertEquals((String)"Folder is incorrect", (Object)"3", (Object)temp.get("folder_id"));
        ImportExportWriterTest.assertNull((Object)temp.optJSONArray("warnings"));
    }

    public void testWriteObjects() throws JSONException {
        ImportExportWriter writer = new ImportExportWriter(null);
        List<ImportResult> results = Arrays.asList(new ImportResult("1", "3", new Date()), new ImportResult("2", "4", new Date()));
        writer.writeObjects(results);
        JSONArray resArr = (JSONArray)writer.getObject();
        JSONObject temp = resArr.getJSONObject(0);
        ImportExportWriterTest.assertEquals((String)"ID is incorrect", (Object)"1", (Object)temp.get("id"));
        ImportExportWriterTest.assertEquals((String)"Folder is incorrect", (Object)"3", (Object)temp.get("folder_id"));
        temp = resArr.getJSONObject(1);
        ImportExportWriterTest.assertEquals((String)"ID is incorrect", (Object)"2", (Object)temp.get("id"));
        ImportExportWriterTest.assertEquals((String)"Folder is incorrect", (Object)"4", (Object)temp.get("folder_id"));
    }

    public void testWarnings() throws JSONException {
        OXException exception = OXException.general((String)"EXCEPTION");
        ArrayList<ConversionWarning> warnings = new ArrayList<ConversionWarning>();
        warnings.add(new ConversionWarning(1, "Warning 1", new Object[0]));
        warnings.add(new ConversionWarning(1, "Warning 2", new Object[0]));
        warnings.add(new ConversionWarning(1, "Warning 3", new Object[0]));
        warnings.add(new ConversionWarning(1, "Warning 4", new Object[0]));
        ImportExportWriter writer = new ImportExportWriter(null);
        ImportResult result = new ImportResult();
        result.setObjectId("12");
        result.setException(exception);
        result.addWarnings(warnings);
        writer.writeObject(result);
        JSONObject temp = (JSONObject)writer.getObject();
        ImportExportWriterTest.assertFalse((boolean)temp.isNull("error"));
        JSONArray jsonWarnings = temp.optJSONArray("warnings");
        ImportExportWriterTest.assertNotNull((Object)jsonWarnings);
        HashSet<String> expectedStrings = new HashSet<String>(Arrays.asList("Warning 1", "Warning 2", "Warning 3", "Warning 4"));
        int size = jsonWarnings.length();
        for (int i = 0; i < size; ++i) {
            JSONObject warning = jsonWarnings.getJSONObject(i);
            ImportExportWriterTest.assertTrue((boolean)expectedStrings.remove(warning.getJSONObject("warnings").getJSONArray("error_stack").get(0)));
        }
        ImportExportWriterTest.assertTrue((boolean)expectedStrings.isEmpty());
    }
}

