/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.ContactTestData;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.importers.Importer;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractContactTest {
    protected static final int[] POSSIBLE_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 501, 502, 517, 537, 511, 533, 534, 100, 551, 552, 526, 508, 539, 532, 569, 528, 510, 541, 519, 500, 555, 556, 557, 521, 544, 550, 554, 20, 501, 535, 565, 566, 536, 512, 503, 515, 518, 513, 529, 520, 525, 507, 540, 514, 522, 530, 516, 527, 509, 598, 523, 506, 538, 504, 531, 568, 542, 543, 545, 546, 547, 548, 549, 567, 559, 553, 560, 561, 562, 563, 564, 505, 558, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 605};
    public static ServerSession sessObj;
    public static int userId;
    public static int contextId;
    public static int folderId;
    public String DISPLAY_NAME1 = ContactTestData.DISPLAY_NAME1;
    public String NAME1 = ContactTestData.NAME1;
    public String EMAIL1 = ContactTestData.EMAIL1;
    public String DISPLAY_NAME2 = ContactTestData.DISPLAY_NAME2;
    public String NAME2 = ContactTestData.NAME2;
    public String EMAIL2 = ContactTestData.EMAIL2;
    public static Importer imp;
    public Format defaultFormat;

    public static int createTestFolder(int type, ServerSession sessObj, Context ctx, String folderTitle) throws OXException, OXException {
        User user = UserStorage.getInstance().getUser(sessObj.getUserId(), ctx);
        FolderObject fo = new FolderObject();
        fo.setFolderName(folderTitle);
        fo.setParentFolderID(1);
        fo.setModule(type);
        fo.setType(1);
        OCLPermission ocl = new OCLPermission();
        ocl.setEntity(user.getId());
        ocl.setAllPermission(128, 128, 128, 128);
        ocl.setGroupPermission(false);
        ocl.setFolderAdmin(true);
        fo.setPermissionsAsArray(new OCLPermission[]{ocl});
        OXFolderManager oxfa = OXFolderManager.getInstance((Session)sessObj);
        int tempFolderId = -1;
        if (fo.exists(sessObj.getContext())) {
            AbstractContactTest.deleteTestFolder(fo.getObjectID());
        }
        tempFolderId = oxfa.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
        return tempFolderId;
    }

    public static void deleteTestFolder(int fuid) throws OXException {
        if (fuid < 0) {
            return;
        }
        OXFolderManager oxfa = OXFolderManager.getInstance((Session)sessObj, (AppointmentSQLInterface)new CalendarSql((Session)sessObj));
        FolderObject fo = new FolderObject(fuid);
        if (fo.exists(sessObj.getContext())) {
            oxfa.deleteFolder(fo, true, System.currentTimeMillis());
        }
    }

    @BeforeClass
    public static void initialize() throws Exception {
        Init.startServer();
        UserStorage uStorage = UserStorage.getInstance();
        Context ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId(AjaxInit.getAJAXProperty("contextName")));
        String loginname = AjaxInit.getAJAXProperty("login");
        String namePart = loginname.split("@")[0];
        userId = uStorage.getUserId(namePart, ctx);
        sessObj = ServerSessionFactory.createServerSession(userId, ctx, "csv-tests");
        folderId = AbstractContactTest.createTestFolder(3, sessObj, ctx, "csvContactTestFolder");
    }

    @AfterClass
    public static void debrief() throws Exception {
        AbstractContactTest.deleteTestFolder(folderId);
        Init.stopServer();
    }

    protected List<ImportResult> importStuff(String csv) throws OXException, UnsupportedEncodingException {
        return this.importStuff(csv, "UTF-8");
    }

    protected List<ImportResult> importStuff(String csv, String encoding) throws OXException, UnsupportedEncodingException {
        ByteArrayInputStream is = new ByteArrayInputStream(csv.getBytes(encoding));
        return imp.importData(sessObj, this.defaultFormat, (InputStream)is, this._folders(), null);
    }

    protected boolean existsEntry(int entryNumber) throws OXException {
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        try {
            Contact co = contactSql.getObjectById(entryNumber, folderId);
            return co != null;
        }
        catch (OXException e) {
            return false;
        }
    }

    protected Contact getEntry(int entryNumber) throws OXException, OXException {
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        return contactSql.getObjectById(entryNumber, folderId);
    }

    protected List<String> _folders() {
        return Arrays.asList(Integer.toString(folderId));
    }

    protected ImportResult performOneEntryCheck(String file, Format format, int folderObjectType, String foldername, Context ctx, boolean errorExpected) throws UnsupportedEncodingException, OXException, OXException {
        return this.performMultipleEntryImport(file, format, folderObjectType, foldername, ctx, Autoboxing.B((boolean)errorExpected)).get(0);
    }

    protected List<ImportResult> performMultipleEntryImport(String file, Format format, int folderObjectType, String foldername, Context ctx, Boolean ... expectedErrors) throws UnsupportedEncodingException, OXException, OXException {
        folderId = AbstractContactTest.createTestFolder(folderObjectType, sessObj, ctx, foldername);
        Assert.assertTrue((String)"Can import?", (boolean)imp.canImport(sessObj, format, this._folders(), null));
        List results = imp.importData(sessObj, format, (InputStream)new ByteArrayInputStream(file.getBytes(Charsets.UTF_8)), this._folders(), null);
        Assert.assertEquals((String)"Correct number of results?", (Object)expectedErrors.length, (Object)results.size());
        for (int i = 0; i < expectedErrors.length; ++i) {
            Assert.assertEquals((String)("Entry " + i + " is as expected? " + (Object)((Object)((ImportResult)results.get(i)).getException())), (Object)expectedErrors[i], (Object)Autoboxing.B((boolean)((ImportResult)results.get(i)).hasError()));
        }
        return results;
    }

    public static User getUserParticipant() throws Exception {
        Init.startServer();
        UserStorage uStorage = UserStorage.getInstance();
        Context ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId(AjaxInit.getAJAXProperty("contextName")));
        int uid = uStorage.getUserId(AjaxInit.getAJAXProperty("user_participant1"), ctx);
        return uStorage.getUser(uid, ctx);
    }

    public static class TestSession
    extends SessionObject {
        public SessionObject delegateSessionObject;
        public UserConfiguration delegateUserConfiguration;

        public TestSession(String sessionid) {
            super(sessionid);
        }

        public boolean equals(Object obj) {
            return this.delegateSessionObject.equals(obj);
        }

        public int getContextId() {
            return this.delegateSessionObject.getContextId();
        }

        public Date getCreationtime() {
            return this.delegateSessionObject.getCreationtime();
        }

        public String getHost() {
            return this.delegateSessionObject.getHost();
        }

        public String getLanguage() {
            return this.delegateSessionObject.getLanguage();
        }

        public long getLifetime() {
            return this.delegateSessionObject.getLifetime();
        }

        public String getLocalIp() {
            return this.delegateSessionObject.getLocalIp();
        }

        public String getLoginName() {
            return this.delegateSessionObject.getLoginName();
        }

        public String getPassword() {
            return this.delegateSessionObject.getPassword();
        }

        public String getRandomToken() {
            return this.delegateSessionObject.getRandomToken();
        }

        public String getSecret() {
            return this.delegateSessionObject.getSecret();
        }

        public String getSessionID() {
            return this.delegateSessionObject.getSessionID();
        }

        public Date getTimestamp() {
            return this.delegateSessionObject.getTimestamp();
        }

        public UserConfiguration getUserConfiguration() {
            return this.delegateUserConfiguration;
        }

        public String getUserlogin() {
            return this.delegateSessionObject.getUserlogin();
        }

        public String getUsername() {
            return this.delegateSessionObject.getUsername();
        }

        public int hashCode() {
            return this.delegateSessionObject.hashCode();
        }

        public void setContextId(int id) {
            this.delegateSessionObject.setContextId(id);
        }

        public void setCreationtime(Date creationtime) {
            this.delegateSessionObject.setCreationtime(creationtime);
        }

        public void setHost(String host) {
            this.delegateSessionObject.setHost(host);
        }

        public void setLanguage(String language) {
            this.delegateSessionObject.setLanguage(language);
        }

        public void setLifetime(long lifetime) {
            this.delegateSessionObject.setLifetime(lifetime);
        }

        public void setLocalIp(String localip) {
            this.delegateSessionObject.setLocalIp(localip);
        }

        public void setLoginName(String loginName) {
            this.delegateSessionObject.setLoginName(loginName);
        }

        public void setPassword(String password) {
            this.delegateSessionObject.setPassword(password);
        }

        public void setRandomToken(String randomToken) {
            this.delegateSessionObject.setRandomToken(randomToken);
        }

        public void setSecret(String secret) {
            this.delegateSessionObject.setSecret(secret);
        }

        public void setTimestamp(Date timestamp) {
            this.delegateSessionObject.setTimestamp(timestamp);
        }

        public void setUserlogin(String userlogin) {
            this.delegateSessionObject.setUserlogin(userlogin);
        }

        public void setUsername(String username) {
            this.delegateSessionObject.setUsername(username);
        }

        public String toString() {
            return this.delegateSessionObject.toString();
        }
    }
}

