/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactInterfaceProvider;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistration;
import com.openexchange.session.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimContactInterfaceDiscoveryService
implements ContactInterfaceDiscoveryService {
    private final Map<Integer, ContactInterface> registered = new HashMap<Integer, ContactInterface>();
    private ContactInterface defaultContactInterface;

    public ContactInterfaceProvider getContactInterfaceProvider(int folderId, int contextId) throws OXException {
        return new StaticContactInterfaceProvider(this.newContactInterface(folderId, null));
    }

    public boolean hasSpecificContactInterface(int folderId, int contextId) {
        return this.registered.containsKey(folderId);
    }

    public ContactInterface newContactInterface(int folderId, Session session) throws OXException {
        return this.hasSpecificContactInterface(folderId, -1) ? this.registered.get(folderId) : this.newDefaultContactInterface(session);
    }

    public ContactInterface newDefaultContactInterface(Session session) throws OXException {
        return this.defaultContactInterface;
    }

    public void register(ContactInterface contacts, int folderId) {
        this.registered.put(folderId, contacts);
    }

    public void setDefaultContactInterface(ContactInterface defaultContactInterface) {
        this.defaultContactInterface = defaultContactInterface;
    }

    public List<ContactInterfaceProviderRegistration> getRegistrations(int contextId) {
        Set<Map.Entry<Integer, ContactInterface>> entrySet = this.registered.entrySet();
        LinkedList<ContactInterfaceProviderRegistration> registrations = new LinkedList<ContactInterfaceProviderRegistration>();
        for (Map.Entry<Integer, ContactInterface> entry : entrySet) {
            registrations.add(new ContactInterfaceProviderRegistration(entry.getKey().intValue(), (ContactInterfaceProvider)new StaticContactInterfaceProvider(entry.getValue())));
        }
        return registrations;
    }

    private static final class StaticContactInterfaceProvider
    implements ContactInterfaceProvider {
        private final ContactInterface contacts;

        public StaticContactInterfaceProvider(ContactInterface contacts) {
            this.contacts = contacts;
        }

        public ContactInterface newContactInterface(Session session) throws OXException {
            return this.contacts;
        }
    }
}

