/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;

public class Bug13068Test
extends CalendarSqlTest {
    public void testRemoveReminderIfChangedIntoPast() throws Throwable {
        long oneHour = 3600000L;
        long tomorrow = System.currentTimeMillis() + 86400000L;
        long yesterday = System.currentTimeMillis() - 86400000L;
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(new Date(tomorrow), new Date(tomorrow + 3600000L));
        appointment.setTitle("Bug 13068 Test");
        appointment.setAlarm(5);
        appointment.setAlarmFlag(true);
        appointment.setIgnoreConflicts(true);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        ReminderHandler reminderInterface = new ReminderHandler(this.ctx);
        SearchIterator iterator = reminderInterface.listReminder(1, appointment.getObjectID());
        Bug13068Test.assertTrue((String)"Reminder expected", (boolean)iterator.hasNext());
        CalendarDataObject updateAppointment = this.appointments.createIdentifyingCopy(appointment);
        updateAppointment.setStartDate(new Date(yesterday));
        updateAppointment.setEndDate(new Date(yesterday + 3600000L));
        this.appointments.save(updateAppointment);
        iterator = reminderInterface.listReminder(1, appointment.getObjectID());
        Bug13068Test.assertFalse((String)"No Reminder expected", (boolean)iterator.hasNext());
    }
}

