/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.calendar.ConflictHandler;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.tools.CalendarAssertions;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.setuptools.TestFolderToolkit;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class ConflictHandlerTest
extends TestCase {
    private String participant1;
    private String participant2;
    private String participant3;
    private String resource1;
    private String resource2;
    private String resource3;
    private String group;
    private String member;
    private String user;
    private String secondUser;
    private Context ctx;
    private CommonAppointments appointments;
    private TestFolderToolkit folders;
    List<CalendarDataObject> clean = new ArrayList<CalendarDataObject>();

    public void setUp() throws Exception {
        Init.startServer();
        TestConfig config = new TestConfig();
        this.user = config.getUser();
        this.secondUser = config.getSecondUser();
        TestContextToolkit tools = new TestContextToolkit();
        this.ctx = tools.getDefaultContext();
        this.appointments = new CommonAppointments(this.ctx, this.user);
        this.participant1 = config.getParticipant1();
        this.participant2 = config.getParticipant2();
        this.participant3 = config.getParticipant3();
        this.resource1 = config.getResource1();
        this.resource2 = config.getResource2();
        this.resource3 = config.getResource3();
        this.group = config.getGroup();
        int groupid = tools.resolveGroup(this.group, this.ctx);
        int memberid = tools.loadGroup(groupid, this.ctx).getMember()[0];
        this.member = tools.loadUser(memberid, this.ctx).getLoginInfo();
        this.appointments.deleteAll(this.ctx);
        this.folders = new TestFolderToolkit();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
        this.appointments.removeAll(this.user, this.clean);
    }

    public void testShouldSupplyConflictingUserParticipants() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertUserParticipants(conflict, this.user, this.participant1);
    }

    public void testShouldSupplyConflictingResourceParticipants() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1, this.resource2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1, this.resource3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertResourceParticipants(conflict, this.resource1);
    }

    public void testShouldSupplyConflictingUserParticipantsInGroup() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithGroupParticipants(this.group);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.member);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertUserParticipants(conflict, this.member);
    }

    public void testShouldSupplyTitleIfPermissionsAllowIt() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertEquals((String)appointment.getTitle(), (String)conflict.getTitle());
    }

    public void testShouldSuppressTitleIfPermissionsDenyIt() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        this.appointments.switchUser(this.secondUser);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertNull((Object)conflict.getTitle());
    }

    public void testShouldIncludeCurrentUserInConflictsWithCurrentUserOnly() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
        ConflictHandlerTest.assertNotNull((Object)conflicts);
        ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        ConflictHandlerTest.assertEquals((String)appointment.getTitle(), (String)conflict.getTitle());
        CalendarAssertions.assertUserParticipants(conflict, this.user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShouldShowTitleIfReadPermissionsInPrivateFolderAllowIt() throws OXException {
        Session session = this.appointments.getSession();
        int secondUserId = new TestContextToolkit().resolveUser(this.secondUser);
        this.folders.sharePrivateFolder(session, this.ctx, secondUserId);
        try {
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant2);
            this.appointments.save(appointment);
            this.clean.add(appointment);
            this.appointments.switchUser(this.secondUser);
            CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant3);
            conflictingAppointment.setIgnoreConflicts(false);
            CalendarDataObject[] conflicts = this.getConflicts(conflictingAppointment);
            ConflictHandlerTest.assertNotNull((Object)conflicts);
            ConflictHandlerTest.assertEquals((int)1, (int)conflicts.length);
            CalendarDataObject conflict = conflicts[0];
            ConflictHandlerTest.assertNotNull((Object)conflict.getTitle());
        }
        finally {
            this.folders.unsharePrivateFolder(session, this.ctx);
        }
    }

    private CalendarDataObject[] getConflicts(CalendarDataObject conflictingAppointment) throws OXException {
        CalendarDataObject[] conflicts;
        ConflictHandler ch = new ConflictHandler(conflictingAppointment, null, this.appointments.getSession(), false);
        for (CalendarDataObject conflict : conflicts = ch.getConflicts()) {
            conflict.setContext(this.ctx);
        }
        return conflicts;
    }
}

