/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.ThrowableHolder;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.sourceforge.cardme.vcard.features.ExtendedFeature;
import net.sourceforge.cardme.vcard.types.ExtendedType;

public class NewTest
extends CardDAVTest {
    public NewTest(String name) {
        super(name);
    }

    public void testCreateSimpleOnClient() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst;test;;;\r\nFN:test horst\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:test@example.com\r\nTEL;type=WORK;type=pref:24235423\r\nTEL;type=CELL:352-3534\r\nTEL;type=HOME:346346\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        NewTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        NewTest.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        NewTest.assertEquals((String)"lastname wrong", (String)"horst", (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)"test", (String)card.getVCard().getName().getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)"horst", (String)card.getVCard().getName().getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)"test horst", (String)card.getVCard().getFormattedName().getFormattedName());
    }

    public void testCreateSimpleOnServer() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "otto";
        Contact contact = new Contact();
        contact.setSurName("otto");
        contact.setGivenName("test");
        contact.setDisplayName("test otto");
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken);
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)"test", (String)card.getVCard().getName().getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)"otto", (String)card.getVCard().getName().getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)"test otto", (String)card.getVCard().getFormattedName().getFormattedName());
        contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        NewTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        NewTest.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        NewTest.assertEquals((String)"lastname wrong", (String)"otto", (String)contact.getSurName());
    }

    public void testAddContactInSubfolderServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + NewTest.randomUID();
        FolderObject folder = super.createFolder(folderName);
        super.rememberForCleanUp(folder);
        FolderObject createdFolder = super.getFolder(folderName);
        NewTest.assertNotNull((String)"folder not found on server", (Object)createdFolder);
        NewTest.assertEquals((String)"foldername wrong", (String)folderName, (String)createdFolder.getFolderName());
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "herbert";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, createdFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
    }

    public void testCreateContactInGroupOnClient() throws Throwable {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String listUid = NewTest.randomUID();
        String listName = "test distribution list";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        super.rememberForCleanUp(super.create(distributionList));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource groupCard = NewTest.assertContains(listUid, addressData);
        NewTest.assertEquals((String)"FN wrong", (String)listName, (String)groupCard.getFN());
        final String contactUid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "daphne";
        String email = "daphne88@example.com";
        final String contactVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test88;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:" + email + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:547547" + "\r\n" + "UID:" + contactUid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        ExtendedType newMember = new ExtendedType("X-ADDRESSBOOKSERVER-MEMBER", "urn:uuid:" + contactUid);
        groupCard.getVCard().addExtendedType((ExtendedFeature)newMember);
        final ThrowableHolder throwableHolder = new ThrowableHolder();
        Thread createThread = new Thread(){

            @Override
            public void run() {
                try {
                    Assert.assertEquals((String)"response code wrong", (int)201, (int)NewTest.this.putVCard(contactUid, contactVCard));
                }
                catch (Throwable t) {
                    throwableHolder.setThrowable(t);
                }
            }
        };
        createThread.start();
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)this.putVCardUpdate(groupCard.getUID(), groupCard.toString(), groupCard.getETag()));
        createThread.join();
        throwableHolder.reThrowIfSet();
        Contact contact = super.getContact(contactUid);
        NewTest.assertNotNull((String)"contact not found on server", (Object)contact);
        super.rememberForCleanUp(contact);
        NewTest.assertEquals((String)"uid wrong", (String)contactUid, (String)contact.getUid());
        NewTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        NewTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        NewTest.assertEquals((String)"email wrong", (String)email, (String)contact.getEmail1());
        distributionList = super.getContact(listUid);
        NewTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        NewTest.assertEquals((String)"uid wrong", (String)listUid, (String)distributionList.getUid());
        NewTest.assertEquals((String)"displayname wrong", (String)listName, (String)distributionList.getDisplayName());
        NewTest.assertTrue((String)"list not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        NewTest.assertNotNull((String)"no members in distribution list", (Object)distributionList.getDistributionList());
        NewTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList.getNumberOfDistributionLists() ? 1 : 0) != 0);
        NewTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList.getDistributionList().length ? 1 : 0) != 0);
        DistributionListEntryObject member = distributionList.getDistributionList()[0];
        NewTest.assertNotNull((String)"no member in distribution list", (Object)member);
        NewTest.assertEquals((String)"email wrong", (String)email, (String)member.getEmailaddress());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(contactUid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        card = NewTest.assertContains(listUid, addressData);
        NewTest.assertEquals((String)"FN wrong", (String)listName, (String)card.getFN());
        NewTest.assertContainsMemberUID(contactUid, card);
    }
}

