/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;
import net.sourceforge.cardme.vcard.features.ExtendedFeature;
import net.sourceforge.cardme.vcard.types.ExtendedType;

public class MoveTest
extends CardDAVTest {
    public MoveTest(String name) {
        super(name);
    }

    public void testMoveContactToSubfolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String subFolderName = "testfolder_" + MoveTest.randomUID();
        FolderObject subFolder = super.createFolder(subFolderName);
        super.rememberForCleanUp(subFolder);
        String uid = MoveTest.randomUID();
        String firstName = "test";
        String lastName = "jaqueline";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = MoveTest.assertContains(uid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        contact.setParentFolderID(subFolder.getObjectID());
        super.update(super.getDefaultFolder().getObjectID(), contact);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        contactCard = MoveTest.assertContains(uid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
    }

    public void testMoveContactToDefaultFolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String subFolderName = "testfolder_" + MoveTest.randomUID();
        FolderObject subFolder = super.createFolder(subFolderName);
        super.rememberForCleanUp(subFolder);
        String uid = MoveTest.randomUID();
        String firstName = "test";
        String lastName = "jaqueline";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, subFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = MoveTest.assertContains(uid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        contact.setParentFolderID(super.getDefaultFolder().getObjectID());
        super.update(subFolder.getObjectID(), contact);
        contact.setParentFolderID(subFolder.getObjectID());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        contactCard = MoveTest.assertContains(uid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
    }

    public void testMoveContactToGroupOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String listUid = MoveTest.randomUID();
        String listName = "liste6546";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        super.rememberForCleanUp(super.create(distributionList));
        String uid = MoveTest.randomUID();
        String firstName = "Waldo";
        String lastName = "Nacktnasenwombat";
        String email = "nacktnasenwombat@example.com";
        Contact contact = new Contact();
        contact.setEmail1(email);
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource groupCard = MoveTest.assertContains(listUid, addressData);
        MoveTest.assertNotContainsMemberUID(uid, groupCard);
        MoveTest.assertEquals((String)"FN wrong", (String)listName, (String)groupCard.getVCard().getFormattedName().getFormattedName());
        VCardResource contactCard = MoveTest.assertContains(uid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        ExtendedType newMember = new ExtendedType("X-ADDRESSBOOKSERVER-MEMBER", "urn:uuid:" + uid);
        groupCard.getVCard().addExtendedType((ExtendedFeature)newMember);
        MoveTest.assertEquals((String)"response code wrong", (int)201, (int)this.putVCardUpdate(groupCard.getUID(), groupCard.toString(), groupCard.getETag()));
        distributionList = super.getContact(listUid);
        MoveTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        MoveTest.assertEquals((String)"uid wrong", (String)listUid, (String)distributionList.getUid());
        MoveTest.assertEquals((String)"displayname wrong", (String)listName, (String)distributionList.getDisplayName());
        MoveTest.assertTrue((String)"list not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        MoveTest.assertNotNull((String)"no members in distribution list", (Object)distributionList.getDistributionList());
        MoveTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList.getNumberOfDistributionLists() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList.getDistributionList().length ? 1 : 0) != 0);
        DistributionListEntryObject member = distributionList.getDistributionList()[0];
        MoveTest.assertNotNull((String)"no member in distribution list", (Object)member);
        MoveTest.assertEquals((String)"email wrong", (String)email, (String)member.getEmailaddress());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        groupCard = MoveTest.assertContains(listUid, addressData);
        MoveTest.assertContainsMemberUID(uid, groupCard);
    }

    public void testMoveContactToOtherGroupOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String contactUid = MoveTest.randomUID();
        String firstName = "test";
        String lastName = "hund";
        String email = "test.hund@example.org";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setEmail1(email);
        contact.setUid(contactUid);
        super.rememberForCleanUp(super.create(contact));
        Contact otherContact = new Contact();
        otherContact.setSurName("otto");
        otherContact.setGivenName("kurz");
        super.rememberForCleanUp(super.create(otherContact));
        Contact furtherContact = new Contact();
        furtherContact.setSurName("anton");
        furtherContact.setGivenName("lang");
        super.rememberForCleanUp(super.create(furtherContact));
        String list1Uid = MoveTest.randomUID();
        String list1Name = "liste1";
        Contact distributionList1 = new Contact();
        distributionList1.setDisplayName(list1Name);
        distributionList1.setUid(list1Uid);
        distributionList1.setMarkAsDistributionlist(true);
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{MoveTest.asDistListMember(otherContact), MoveTest.asDistListMember(contact), MoveTest.asDistListMember(furtherContact)};
        distributionList1.setDistributionList(members);
        super.rememberForCleanUp(super.create(distributionList1));
        String list2Uid = MoveTest.randomUID();
        String list2Name = "liste2";
        Contact distributionList2 = new Contact();
        distributionList2.setDisplayName(list2Name);
        distributionList2.setUid(list2Uid);
        distributionList2.setMarkAsDistributionlist(true);
        super.rememberForCleanUp(super.create(distributionList2));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = MoveTest.assertContains(contactUid, addressData);
        MoveTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        MoveTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        MoveTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        VCardResource groupCard1 = MoveTest.assertContains(list1Uid, addressData);
        MoveTest.assertEquals((String)"FN wrong", (String)list1Name, (String)groupCard1.getVCard().getFormattedName().getFormattedName());
        MoveTest.assertContainsMemberUID(contactUid, groupCard1);
        VCardResource groupCard2 = MoveTest.assertContains(list2Uid, addressData);
        MoveTest.assertEquals((String)"FN wrong", (String)list2Name, (String)groupCard2.getVCard().getFormattedName().getFormattedName());
        MoveTest.assertNotContainsMemberUID(contactUid, groupCard2);
        ExtendedType newMember = new ExtendedType("X-ADDRESSBOOKSERVER-MEMBER", "urn:uuid:" + contactUid);
        groupCard2.getVCard().addExtendedType((ExtendedFeature)newMember);
        MoveTest.assertEquals((String)"response code wrong", (int)201, (int)this.putVCardUpdate(groupCard2.getUID(), groupCard2.toString(), groupCard2.getETag()));
        distributionList2 = super.getContact(list2Uid);
        MoveTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList2);
        MoveTest.assertEquals((String)"uid wrong", (String)list2Uid, (String)distributionList2.getUid());
        MoveTest.assertEquals((String)"displayname wrong", (String)list2Name, (String)distributionList2.getDisplayName());
        MoveTest.assertTrue((String)"list not marked as distribution list", (boolean)distributionList2.getMarkAsDistribtuionlist());
        MoveTest.assertNotNull((String)"no members in distribution list", (Object)distributionList2.getDistributionList());
        MoveTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList2.getNumberOfDistributionLists() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"invalid member count in distribution list", (1 == distributionList2.getDistributionList().length ? 1 : 0) != 0);
        DistributionListEntryObject member = distributionList2.getDistributionList()[0];
        MoveTest.assertNotNull((String)"no member in distribution list", (Object)member);
        MoveTest.assertEquals((String)"email wrong", (String)email, (String)member.getEmailaddress());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        MoveTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        groupCard2 = MoveTest.assertContains(list2Uid, addressData);
        MoveTest.assertContainsMemberUID(contactUid, groupCard2);
    }
}

