/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GroupTest
extends CardDAVTest {
    public GroupTest(String name) {
        super(name);
    }

    public void testCreateGroupOnClient() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = GroupTest.randomUID();
        String listName = "testlist_" + uid;
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//AddressBook 6.0//EN\r\nN:" + listName + "\r\n" + "FN:" + listName + "\r\n" + "X-ADDRESSBOOKSERVER-KIND:group" + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "END:VCARD" + "\r\n";
        GroupTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact distributionList = super.getContact(uid);
        GroupTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        super.rememberForCleanUp(distributionList);
        GroupTest.assertEquals((String)"listname wrong", (String)listName, (String)distributionList.getDisplayName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = GroupTest.assertContains(uid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)listName, (String)card.getFN());
    }

    public void testUpdateGroupOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = GroupTest.randomUID();
        String listName = "testlist_" + uid;
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//AddressBook 6.0//EN\r\nN:" + listName + "\r\n" + "FN:" + listName + "\r\n" + "X-ADDRESSBOOKSERVER-KIND:group" + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "END:VCARD" + "\r\n";
        GroupTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact distributionList = super.getContact(uid);
        GroupTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        super.rememberForCleanUp(distributionList);
        GroupTest.assertEquals((String)"listname wrong", (String)listName, (String)distributionList.getDisplayName());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = GroupTest.assertContains(uid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)listName, (String)card.getFN());
        String updatedListName = listName + "_changed";
        card.getVCard().getFormattedName().setFormattedName(updatedListName);
        GroupTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(card.getUID(), card.toString(), card.getETag()));
        distributionList = super.getContact(uid);
        GroupTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        super.rememberForCleanUp(distributionList);
        GroupTest.assertEquals((String)"listname wrong", (String)updatedListName, (String)distributionList.getDisplayName());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        GroupTest.assertNotContainsFN(listName, addressData);
        card = GroupTest.assertContains(uid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)updatedListName, (String)card.getFN());
    }

    public void testCreateGroupOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String listUid = GroupTest.randomUID();
        String listName = "test list";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        super.rememberForCleanUp(super.create(distributionList));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = GroupTest.assertContains(listUid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)listName, (String)card.getFN());
        GroupTest.assertTrue((String)"card doesn't represent a group", (boolean)card.isGroup());
    }

    public void testUpdateGroupOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String listUid = GroupTest.randomUID();
        String listName = "test list 77";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        super.rememberForCleanUp(super.create(distributionList));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = GroupTest.assertContains(listUid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)listName, (String)card.getFN());
        GroupTest.assertTrue((String)"card doesn't represent a group", (boolean)card.isGroup());
        String updatedListName = listName + "_changed";
        distributionList.setDisplayName(updatedListName);
        distributionList = super.update(distributionList);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        GroupTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = GroupTest.assertContains(listUid, addressData);
        GroupTest.assertEquals((String)"FN wrong", (String)updatedListName, (String)card.getFN());
        GroupTest.assertTrue((String)"card doesn't represent a group", (boolean)card.isGroup());
    }
}

