/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contactcollector;

import com.openexchange.contactcollector.folder.ContactCollectorFolderCreator;
import com.openexchange.contactcollector.internal.ContactCollectorServiceImpl;
import com.openexchange.contactcollector.osgi.CCServiceRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Autoboxing;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;

public class ContactCollectorTest
extends TestCase {
    private String user;
    private int userId;
    private Context ctx;
    private Session session;
    private TestContextToolkit tools;
    private FolderObject contactFolder;
    private final String mail = "test-contact-collector@example.invalid";

    public void setUp() throws Exception {
        Init.startServer();
        TestConfig config = new TestConfig();
        this.user = ContactCollectorTest.prepareUser(config.getUser());
        this.tools = new TestContextToolkit();
        this.ctx = this.tools.getContextByName(config.getContextName());
        this.userId = this.tools.resolveUser(this.user, this.ctx);
        this.session = this.tools.getSessionForUser(this.user, this.ctx);
        this.contactFolder = this.getStandardContactFolder();
        this.deleteContactFromFolder("test-contact-collector@example.invalid");
    }

    private static String prepareUser(String user) {
        int pos = user.indexOf(64);
        if (-1 == pos) {
            return user;
        }
        return user.substring(0, pos);
    }

    public void tearDown() throws Exception {
        ServerUserSetting.getInstance().setContactCollectOnMailAccess(this.ctx.getContextId(), this.userId, false);
        ServerUserSetting.getInstance().setContactCollectOnMailTransport(this.ctx.getContextId(), this.userId, false);
        Init.stopServer();
        this.deleteContactFromFolder("test-contact-collector@example.invalid");
    }

    public void testNoFolder() throws Throwable {
        ServerUserSetting.getInstance().setContactCollectOnMailAccess(this.ctx.getContextId(), this.userId, true);
        this.setFolderNULL();
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        new ContactCollectorFolderCreator().create(this.session, this.ctx, StringHelper.valueOf((Locale)Locale.ENGLISH).getString("Collected addresses"), con);
        DBPool.closeWriterSilent((Context)this.ctx, (Connection)con);
        Integer folder = ServerUserSetting.getInstance().getContactCollectionFolder(this.ctx.getContextId(), this.userId);
        ContactCollectorTest.assertNotNull((String)"Folder should not be NULL", (Object)folder);
        ContactCollectorTest.assertTrue((String)"Invalid folder id", (folder > 0 ? 1 : 0) != 0);
    }

    public void testNewFeature() throws Throwable {
        this.removeUserEntry();
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        new ContactCollectorFolderCreator().create(this.session, this.ctx, StringHelper.valueOf((Locale)Locale.ENGLISH).getString("Collected addresses"), con);
        ServerUserSetting setting = ServerUserSetting.getInstance();
        ContactCollectorTest.assertNotNull((String)"No folder for contact collection", (Object)setting.getContactCollectionFolder(this.ctx.getContextId(), this.userId));
        ContactCollectorTest.assertTrue((String)"No folder for contact collection", (setting.getContactCollectionFolder(this.ctx.getContextId(), this.userId) > 0 ? 1 : 0) != 0);
        ContactCollectorTest.assertFalse((String)"Feature should be switched off", (boolean)setting.isContactCollectionEnabled(this.ctx.getContextId(), this.userId));
        ContactCollectorTest.assertFalse((String)"Should not collect on incoming mail", (boolean)setting.isContactCollectOnMailAccess(this.ctx.getContextId(), this.userId));
        ContactCollectorTest.assertFalse((String)"Should not collect on outgoing mail", (boolean)setting.isContactCollectOnMailTransport(this.ctx.getContextId(), this.userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewContact() throws Throwable {
        ServerUserSetting.getInstance().setContactCollectionFolder(this.ctx.getContextId(), this.userId, Autoboxing.I((int)this.contactFolder.getObjectID()));
        ServerUserSetting.getInstance().setContactCollectOnMailAccess(this.ctx.getContextId(), this.userId, true);
        ContactCollectorServiceImpl collector = new ContactCollectorServiceImpl();
        collector.start();
        try {
            InternetAddress address = new InternetAddress("test-contact-collector@example.invalid");
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
            addresses.add(address);
            collector.memorizeAddresses(addresses, this.session, false);
            List<Contact> contacts = this.searchContact("test-contact-collector@example.invalid");
            ContactCollectorTest.assertEquals((String)"No object found", (int)1, (int)contacts.size());
            ContactCollectorTest.assertEquals((String)"Count does not match", (int)1, (int)contacts.get(0).getUseCount());
        }
        finally {
            collector.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExistingContact() throws Throwable {
        ServerUserSetting.getInstance().setContactCollectionFolder(this.ctx.getContextId(), this.userId, Autoboxing.I((int)this.contactFolder.getObjectID()));
        ServerUserSetting.getInstance().setContactCollectOnMailAccess(this.ctx.getContextId(), this.userId, true);
        ContactCollectorServiceImpl collector = new ContactCollectorServiceImpl();
        collector.start();
        try {
            InternetAddress address = new InternetAddress("test-contact-collector@example.invalid");
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
            addresses.add(address);
            collector.memorizeAddresses(addresses, this.session, false);
            collector.memorizeAddresses(addresses, this.session, false);
            collector.memorizeAddresses(addresses, this.session, false);
            List<Contact> contacts = this.searchContact("test-contact-collector@example.invalid");
            ContactCollectorTest.assertEquals((String)"Ammount of objects found is not correct", (int)1, (int)contacts.size());
            ContactCollectorTest.assertEquals((String)"Count does not match", (int)3, (int)contacts.get(0).getUseCount());
        }
        finally {
            collector.stop();
        }
    }

    private FolderObject getStandardContactFolder() {
        OXFolderAccess access = new OXFolderAccess(this.ctx);
        FolderObject fo = null;
        try {
            fo = access.getDefaultFolder(this.userId, 3);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
        return fo;
    }

    private List<Contact> searchContact(String pattern) throws Exception {
        ContactInterface contactInterface = ((ContactInterfaceDiscoveryService)CCServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class)).getContactInterfaceProvider(this.contactFolder.getObjectID(), this.ctx.getContextId()).newContactInterface(this.session);
        ContactSearchObject searchObject = new ContactSearchObject();
        searchObject.setEmail1(pattern);
        searchObject.setEmail2(pattern);
        searchObject.setEmail3(pattern);
        searchObject.setOrSearch(true);
        searchObject.addFolder(this.contactFolder.getObjectID());
        int[] columns = new int[]{20, 5, 1, 590};
        SearchIterator iterator = contactInterface.getContactsByExtendedSearch(searchObject, 0, null, null, columns);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        while (iterator.hasNext()) {
            Contact foundContact = (Contact)iterator.next();
            contacts.add(foundContact);
        }
        return contacts;
    }

    private void deleteContactFromFolder(String pattern) throws Exception {
        List<Contact> contacts = this.searchContact(pattern);
        for (Contact contact : contacts) {
            ContactInterface contactInterface = ((ContactInterfaceDiscoveryService)CCServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class)).getContactInterfaceProvider(this.contactFolder.getObjectID(), this.ctx.getContextId()).newContactInterface(this.session);
            contactInterface.deleteContactObject(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified());
        }
    }

    private void removeUserEntry() throws Throwable {
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        PreparedStatement stmt = con.prepareStatement("DELETE FROM user_setting_server WHERE cid = ? AND user = ?");
        stmt.setInt(1, this.ctx.getContextId());
        stmt.setInt(2, this.userId);
        stmt.execute();
        stmt.close();
        DBPool.closeWriterSilent((Context)this.ctx, (Connection)con);
    }

    private void setFolderNULL() throws Throwable {
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        PreparedStatement stmt = con.prepareStatement("UPDATE user_setting_server SET contact_collect_folder = ? WHERE cid = ? AND user = ?");
        stmt.setNull(1, 4);
        stmt.setInt(2, this.ctx.getContextId());
        stmt.setInt(3, this.userId);
        int count = stmt.executeUpdate();
        stmt.close();
        if (count == 0) {
            stmt = con.prepareStatement("INSERT INTO user_setting_server (cid, user, contact_collect_folder) VALUES (?, ?, ?)");
            stmt.setInt(1, this.ctx.getContextId());
            stmt.setInt(2, this.userId);
            stmt.setNull(3, 4);
            stmt.execute();
            stmt.close();
        }
        DBPool.closeWriterSilent((Context)this.ctx, (Connection)con);
    }

    private FolderObject createSubFolder() throws Throwable {
        FolderObject fo = new FolderObject();
        fo.setFolderName("Contact Collect Folder" + System.currentTimeMillis());
        fo.setParentFolderID(1);
        fo.setModule(3);
        fo.setType(1);
        OCLPermission ocl = new OCLPermission();
        ocl.setEntity(this.userId);
        ocl.setAllPermission(128, 128, 128, 128);
        ocl.setGroupPermission(false);
        ocl.setFolderAdmin(true);
        fo.setPermissionsAsArray(new OCLPermission[]{ocl});
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        int fuid = oxma.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
        fo.setObjectID(fuid);
        return fo;
    }

    private void deleteFolder(FolderObject fo) throws Throwable {
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        oxma.deleteFolder(new FolderObject(fo.getObjectID()), true, System.currentTimeMillis());
    }
}

