/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.TestConfig;
import com.openexchange.exception.OXException;
import com.openexchange.tools.conf.AbstractConfig;

public class WebDAVConfig
extends AbstractConfig {
    private static final TestConfig.Property KEY = TestConfig.Property.WEBDAV_PROPS;
    private static WebDAVConfig singleton;

    protected String getPropertyFileName() throws OXException {
        String fileName = TestConfig.getProperty(KEY);
        if (null == fileName) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{KEY.getPropertyName()});
        }
        return fileName;
    }

    public static void init() throws OXException {
        TestConfig.init();
        if (null == singleton) {
            singleton = new WebDAVConfig();
            singleton.loadPropertiesInternal();
        }
    }

    public static String getProperty(Property key) {
        return singleton.getPropertyInternal(key.getPropertyName());
    }

    public static enum Property {
        HOSTNAME("hostname"),
        LOGIN("login"),
        PASSWORD("password"),
        PROTOCOL("protocol"),
        SECONDUSER("secondlogin");

        private final String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

