/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.exception.OXException;
import com.openexchange.tools.conf.AbstractConfig;

public class TestConfig
extends AbstractConfig {
    private static TestConfig singleton;
    private static final String KEY = "test.propfile";

    private TestConfig() {
    }

    protected String getPropertyFileName() throws OXException {
        String fileName = System.getProperty(KEY);
        if (null == fileName) {
            fileName = "conf/test.properties";
        }
        return fileName;
    }

    public static void init() throws OXException {
        if (null == singleton) {
            singleton = new TestConfig();
            singleton.loadPropertiesInternal();
        }
    }

    public static String getProperty(Property key) {
        return singleton.getPropertyInternal(key.getPropertyName());
    }

    public static enum Property {
        AJAX_PROPS("ajaxPropertiesFile"),
        MAIL_PROPS("mailPropertiesFile"),
        PUBSUB_PROPS("pubsubPropertiesFile"),
        WEBDAV_PROPS("webdavPropertiesFile");

        private String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

