/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug18204Test
extends AbstractAJAXSession {
    AJAXClient client;
    TimeZone tz;
    Calendar start;
    Calendar due;
    Task task;

    public Bug18204Test(String name) throws Exception {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.start = TimeTools.createCalendar(this.tz);
        this.due = (Calendar)this.start.clone();
        this.due.add(11, 2);
        this.task = this.createTask();
    }

    public void testBug18204() throws Exception {
        InsertResponse insertResponse = this.client.execute(new InsertRequest(this.task, this.tz, true));
        insertResponse.fillTask(this.task);
        this.task.removeOccurrence();
        this.due.add(5, 4);
        this.task.setUntil(this.due.getTime());
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(this.task, this.tz, true));
        this.task.setLastModified(updateResponse.getTimestamp());
        GetResponse getResponse = this.client.execute(new GetRequest(this.task));
        Task toCompare = getResponse.getTask(this.tz);
        Bug18204Test.assertFalse((String)"Task contains Occurrences although it should not.", (boolean)toCompare.containsOccurrence());
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task, true));
        super.tearDown();
    }

    private Task createTask() throws Exception {
        Task task = new Task();
        task.setTitle("Bug18204 Task");
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setRecurrenceType(1);
        task.setInterval(1);
        task.setOccurrence(2);
        task.setStartDate(this.start.getTime());
        task.setEndDate(this.due.getTime());
        return task;
    }
}

