/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.actions.ListSubscriptionsResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.Subscription;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ListSubscriptionsTest
extends AbstractSubscriptionTest {
    public ListSubscriptionsTest(String name) {
        super(name);
    }

    public void testShouldSurviveBasicOXMFSubscription() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription subscription = this.generateOXMFSubscription(formDescription);
        subscription.setFolderId(String.valueOf(folder.getObjectID()));
        this.subMgr.newAction(subscription);
        ListSubscriptionsTest.assertFalse((String)"Precondition: Creation of subscription should work", (boolean)this.subMgr.getLastResponse().hasError());
        List<String> columns = Arrays.asList("id", "folder", "source");
        List<Integer> ids = Arrays.asList(subscription.getId());
        JSONArray list = this.subMgr.listAction(ids, columns);
        ListSubscriptionsResponse listResp = (ListSubscriptionsResponse)this.subMgr.getLastResponse();
        ListSubscriptionsTest.assertFalse((String)"List request should have worked flawlessly", (boolean)listResp.hasError());
        ListSubscriptionsTest.assertEquals((String)"Should only have one result", (int)1, (int)list.length());
        JSONArray elements = list.getJSONArray(0);
        ListSubscriptionsTest.assertEquals((String)"Should have three elements", (int)3, (int)elements.length());
        ListSubscriptionsTest.assertEquals((String)"Should return the same ID", (int)subscription.getId(), (int)elements.getInt(0));
        ListSubscriptionsTest.assertEquals((String)"Should return the same folder", (String)subscription.getFolderId(), (String)elements.getString(1));
        ListSubscriptionsTest.assertEquals((String)"Should return the same source ID", (String)subscription.getSource().getId(), (String)elements.getString(2));
    }
}

