/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.reminder.ReminderObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug7590Test
extends AbstractAJAXSession {
    private static final int alarmMinutes = 60;
    private AJAXClient client;
    private TimeZone tz;
    private int folderId;
    private Calendar calendar;
    private Appointment appointment;

    public Bug7590Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.calendar = TimeTools.createCalendar(this.tz);
        this.appointment = this.createAppointment();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testBug7590() throws Exception {
        RangeRequest request = new RangeRequest(this.appointment.getEndDate());
        RangeResponse response = this.client.execute(request);
        ReminderObject actual = null;
        for (ReminderObject reminder : response.getReminder(this.tz)) {
            if (this.appointment.getObjectID() != reminder.getTargetId()) continue;
            actual = reminder;
            break;
        }
        Bug7590Test.assertNotNull((String)"No reminder found for created appointment.", actual);
        ReminderObject expected = new ReminderObject();
        int reminderId = actual.getObjectId();
        expected.setObjectId(reminderId);
        expected.setFolder(this.folderId);
        expected.setTargetId(this.appointment.getObjectID());
        this.calendar.setTime(this.appointment.getStartDate());
        this.calendar.add(12, -60);
        expected.setDate(this.calendar.getTime());
        ReminderTest.compareReminder(expected, actual);
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug7590");
        this.calendar.add(10, 1);
        appointmentObj.setStartDate(this.calendar.getTime());
        this.calendar.add(10, 1);
        appointmentObj.setEndDate(this.calendar.getTime());
        appointmentObj.setAlarm(60);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.folderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(3);
        appointmentObj.setIgnoreConflicts(true);
        AppointmentInsertResponse insertR = this.client.execute(new InsertRequest(appointmentObj, this.tz));
        insertR.fillAppointment(appointmentObj);
        return appointmentObj;
    }
}

