/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public final class ViewTest
extends AbstractMailTest {
    public ViewTest(String name) {
        super(name);
    }

    public void testGet() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        String[] folderAndID = Executor.execute(this.getSession(), new SendRequest(mailObject_25kb)).getFolderAndID();
        GetRequest getRequest = new GetRequest(folderAndID[0], folderAndID[1], GetRequest.View.RAW);
        GetResponse response = Executor.execute(this.getSession(), getRequest);
        JSONArray attachments = response.getAttachments();
        ViewTest.assertNotNull((String)"Attachments not present in JSON mail object.", (Object)attachments);
        int len = attachments.length();
        ViewTest.assertEquals((String)"Unexpected number of attachments: ", (int)2, (int)len);
        for (int i = 0; i < len; ++i) {
            JSONObject attachmentObj = attachments.getJSONObject(i);
            String id = attachmentObj.getString("id");
            if ("1".equals(id)) {
                ViewTest.assertEquals((String)"Unexpected Content-Type: ", (String)"text/plain", (String)attachmentObj.getString("content_type"));
                ViewTest.assertTrue((String)"Unexpected HTML content", (-1 == attachmentObj.getString("content").indexOf("<br />") ? 1 : 0) != 0);
                continue;
            }
            if (!"2".equals(id)) continue;
            ViewTest.assertEquals((String)"Unexpected Content-Type: ", (String)"text/html", (String)attachmentObj.getString("content_type"));
            ViewTest.assertFalse((String)"Unexpected plain text content", (boolean)attachmentObj.getString("content").startsWith("Mail text."));
        }
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }
}

