/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class SendTest
extends AbstractMailTest {
    private MailTestManager manager;

    public SendTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new MailTestManager(this.client, false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testSend() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        SendResponse response = Executor.execute(this.getSession(), new SendRequest(mailObject_25kb));
        SendTest.assertTrue((String)"Send request failed", (response.getFolderAndID() != null && response.getFolderAndID().length > 0 ? 1 : 0) != 0);
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }

    public void testSendWithManager() throws OXException, IOException, SAXException, JSONException {
        UserValues values = this.client.getValues();
        TestMail mail = new TestMail();
        mail.setSubject("Test sending with manager");
        mail.setFrom(values.getSendAddress());
        mail.setTo(Arrays.asList(values.getSendAddress()));
        mail.setContentType(MailContentType.PLAIN.toString());
        mail.setBody("This is the message body.");
        mail.sanitize();
        TestMail inSentBox = this.manager.send(mail);
        SendTest.assertFalse((String)"Sending resulted in error", (boolean)this.manager.getLastResponse().hasError());
        SendTest.assertEquals((String)"Mail went into inbox", (String)values.getSentFolder(), (String)inSentBox.getFolder());
    }
}

