/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class NewMailTest
extends AbstractMailTest {
    private static final String EML_WITHOUT_FROM = "Message-Id: <4A002517.4650.0059.1@deployfast.com>\nX-Mailer: Novell GroupWise Internet Agent 8.0.0 \nDate: Tue, 05 May 2009 11:37:58 -0500\nTo: #TOADDR#\nSubject: Re: Your order for East Texas Lighthouse\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \nproperly handle MIME multipart messages.";
    private UserValues values;

    public NewMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTransportNewRFC822MailWithoutFrom() throws OXException, IOException, SAXException, JSONException {
        System.out.println(this.values.getDraftsFolder());
        NewMailRequest newMailRequest = new NewMailRequest(null, EML_WITHOUT_FROM.replaceFirst("#TOADDR#", this.values.getSendAddress()), -1, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        NewMailTest.assertNotNull((String)"Missing folder in response.", (Object)newMailResponse.getFolder());
        NewMailTest.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
    }

    public void testAppendNewRFC822MailWithoutFrom() throws OXException, IOException, SAXException, JSONException {
        System.out.println(this.values.getDraftsFolder());
        NewMailRequest newMailRequest = new NewMailRequest(this.values.getDraftsFolder(), EML_WITHOUT_FROM.replaceFirst("#TOADDR#", this.values.getSendAddress()), -1, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        NewMailTest.assertNotNull((String)"Missing folder in response.", (Object)newMailResponse.getFolder());
        NewMailTest.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
    }
}

