/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.MailSearchRequest;
import com.openexchange.ajax.mail.actions.MailSearchResponse;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailListField;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailSearchTest
extends AbstractMailTest {
    private String folder;

    public MailSearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.getSentFolder();
        this.clearFolder(this.folder);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.folder);
        super.tearDown();
    }

    public void testSearch() throws Exception {
        String searchText = "The mail subject";
        JSONArray search = this.searchBySubject("The mail subject");
        MailSearchTest.assertEquals((String)"Should not yield results in empty folder.", (int)0, (int)search.length());
        this.sendMail(this.generateMail());
        Thread.sleep(1000L);
        search = this.searchBySubject("The mail subject");
        MailSearchTest.assertEquals((String)"Should yield one result.", (int)1, (int)search.length());
        this.sendMail(this.generateMail());
        Thread.sleep(1000L);
        search = this.searchBySubject("The mail subject");
        MailSearchTest.assertEquals((String)"Should yield two results when facing two identical mails.", (int)2, (int)search.length());
        this.sendMail(this.generateMail("Different subject than original one."));
        Thread.sleep(1000L);
        search = this.searchBySubject("The mail subject");
        MailSearchTest.assertEquals((String)"Should still yield two results after being sent a different one", (int)2, (int)search.length());
    }

    public JSONArray searchBySubject(String pattern) throws OXException, IOException, JSONException {
        JSONArray body = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("col", MailListField.SUBJECT.getField());
        obj.put("pattern", (Object)pattern);
        body.put((Object)obj);
        MailSearchRequest request = new MailSearchRequest(body, this.folder, COLUMNS_DEFAULT_LIST, 0, "asc", true);
        MailSearchResponse response = this.getClient().execute(request);
        return response.getDataAsJSONArray();
    }
}

