/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ListRequest;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.mail.MailListField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ListTest
extends AbstractMailTest {
    private static final Log LOG = LogFactory.getLog(ListTest.class);

    public ListTest(String name) {
        super(name);
    }

    public void testList() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        int numOfMails = 25;
        LOG.info((Object)"Sending 25 mails to fill emptied INBOX");
        for (int i = 0; i < 25; ++i) {
            Executor.execute(this.getSession(), new SendRequest(mailObject_25kb));
            LOG.info((Object)("Sent " + (i + 1) + ". mail of " + 25));
        }
        String[][] folderAndIDs = this.getFolderAndIDs(this.getInboxFolder());
        int[] columns = new int[COLUMNS_DEFAULT_LIST.length + 1];
        System.arraycopy(COLUMNS_DEFAULT_LIST, 0, columns, 0, COLUMNS_DEFAULT_LIST.length);
        columns[columns.length - 1] = MailListField.ACCOUNT_NAME.getField();
        CommonListResponse response = Executor.execute(this.getSession(), new ListRequest(folderAndIDs, columns));
        if (response.hasError()) {
            ListTest.fail((String)response.getException().toString());
        }
        Object[][] array = response.getArray();
        ListTest.assertNotNull((String)"Array of list request is null.", (Object)array);
        ListTest.assertEquals((String)"List request shows different number of mails.", (int)25, (int)array.length);
        for (int i = 0; i < array.length; ++i) {
            Object[] fields = array[i];
            Object accountName = fields[fields.length - 1];
            ListTest.assertNotNull((String)"Account name is null.", (Object)accountName);
        }
        Executor.execute(this.getSession(), new DeleteRequest(folderAndIDs, true));
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }
}

